/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels.search;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggle;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.checkbox.bootstraptoggle.BootstrapToggleConfig;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.collections4.functors.StringValueTransformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.rest.RelationshipTypeRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxEventBehavior;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.FieldPanel;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.RelationshipTypeTO;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class SearchClausePanel
extends FieldPanel<SearchClause> {
    private static final long serialVersionUID = -527351923968737757L;
    private final boolean required;
    private final IModel<List<SearchClause.Type>> types;
    private final IModel<Map<String, PlainSchemaTO>> anames;
    private final IModel<List<String>> dnames;
    private final IModel<Map<String, String>> groupNames;
    private final IModel<List<String>> roleNames;
    private final IModel<List<String>> resourceNames;
    private IModel<SearchClause> clause;
    private final LoadableDetachableModel<List<SearchClause.Comparator>> comparators;
    private final LoadableDetachableModel<List<String>> properties;
    private final Fragment operatorFragment;
    private final Fragment searchButtonFragment;
    private final AjaxSubmitLink searchButton;
    private IEventSink resultContainer;

    public SearchClausePanel(String id, String name, Model<SearchClause> clause, boolean required, IModel<List<SearchClause.Type>> types, final IModel<Map<String, PlainSchemaTO>> anames, final IModel<List<String>> dnames, final IModel<Map<String, String>> groupNames, final IModel<List<String>> roleNames, final IModel<List<String>> resourceNames) {
        super(id, name, clause);
        this.clause = clause == null ? new Model(null) : clause;
        this.required = required;
        this.types = types;
        this.anames = anames;
        this.dnames = dnames;
        this.groupNames = groupNames;
        this.roleNames = roleNames;
        this.resourceNames = resourceNames;
        this.searchButton = new AjaxSubmitLink("search"){
            private static final long serialVersionUID = 5538299138211283825L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                if (SearchClausePanel.this.resultContainer == null) {
                    this.send((IEventSink)this, Broadcast.BUBBLE, new SearchEvent(target));
                } else {
                    this.send(SearchClausePanel.this.resultContainer, Broadcast.EXACT, new SearchEvent(target));
                }
            }
        };
        this.searchButtonFragment = new Fragment("operator", "searchButtonFragment", (MarkupContainer)this);
        this.searchButtonFragment.add(new Component[]{this.searchButton.setEnabled(false)});
        this.operatorFragment = new Fragment("operator", "operatorFragment", (MarkupContainer)this);
        this.field = new FormComponent<SearchClause>("container", this.clause){
            private static final long serialVersionUID = -8204140666393922700L;
        };
        this.add(new Component[]{this.field});
        this.comparators = new LoadableDetachableModel<List<SearchClause.Comparator>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<SearchClause.Comparator> load() {
                if (SearchClausePanel.this.field.getModel().getObject() == null || ((SearchClause)SearchClausePanel.this.field.getModel().getObject()).getType() == null) {
                    return Collections.emptyList();
                }
                switch (((SearchClause)SearchClausePanel.this.field.getModel().getObject()).getType()) {
                    case ATTRIBUTE: {
                        return Arrays.asList(SearchClause.Comparator.values());
                    }
                    case ROLE_MEMBERSHIP: 
                    case GROUP_MEMBERSHIP: 
                    case GROUP_MEMBER: 
                    case RESOURCE: {
                        return Arrays.asList(SearchClause.Comparator.EQUALS, SearchClause.Comparator.NOT_EQUALS);
                    }
                    case RELATIONSHIP: {
                        return Arrays.asList(SearchClause.Comparator.IS_NOT_NULL, SearchClause.Comparator.IS_NULL, SearchClause.Comparator.EQUALS, SearchClause.Comparator.NOT_EQUALS);
                    }
                }
                return Collections.emptyList();
            }
        };
        this.properties = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                if (SearchClausePanel.this.field.getModel().getObject() == null || ((SearchClause)SearchClausePanel.this.field.getModel().getObject()).getType() == null) {
                    return Collections.emptyList();
                }
                switch (((SearchClause)SearchClausePanel.this.field.getModel().getObject()).getType()) {
                    case ATTRIBUTE: {
                        ArrayList<String> names = new ArrayList<String>((Collection)dnames.getObject());
                        if (anames != null && anames.getObject() != null && !((Map)anames.getObject()).isEmpty()) {
                            names.addAll(((Map)anames.getObject()).keySet());
                        }
                        Collections.sort(names);
                        return names;
                    }
                    case GROUP_MEMBERSHIP: {
                        List groups = (List)CollectionUtils.collect(((Map)groupNames.getObject()).keySet(), (Transformer)StringValueTransformer.stringValueTransformer(), new ArrayList());
                        Collections.sort(groups);
                        return groups;
                    }
                    case ROLE_MEMBERSHIP: {
                        ArrayList<String> roles = new ArrayList<String>((Collection)roleNames.getObject());
                        Collections.sort(roles);
                        return roles;
                    }
                    case RESOURCE: {
                        ArrayList<String> resources = new ArrayList<String>((Collection)resourceNames.getObject());
                        Collections.sort(resources);
                        return resources;
                    }
                    case RELATIONSHIP: {
                        List relations = (List)CollectionUtils.collect(new RelationshipTypeRestClient().list(), (Transformer)new Transformer<RelationshipTypeTO, String>(){

                            public String transform(RelationshipTypeTO input) {
                                return input.getKey();
                            }
                        }, new ArrayList());
                        return relations;
                    }
                }
                return Collections.emptyList();
            }
        };
    }

    public void enableSearch(final IEventSink resultContainer) {
        this.resultContainer = resultContainer;
        this.searchButton.setEnabled(true);
        this.field.add(new Behavior[]{AttributeModifier.replace((String)"onkeydown", (IModel)Model.of((Serializable)((Object)"if(event.keyCode == 13) {event.preventDefault();}")))});
        this.field.add(new Behavior[]{new AjaxEventBehavior("onkeydown"){
            private static final long serialVersionUID = -7133385027739964990L;

            protected void onEvent(AjaxRequestTarget target) {
                if (resultContainer == null) {
                    SearchClausePanel.this.send((IEventSink)SearchClausePanel.this, Broadcast.BUBBLE, new SearchEvent(target));
                } else {
                    SearchClausePanel.this.send(resultContainer, Broadcast.EXACT, new SearchEvent(target));
                }
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getAjaxCallListeners().add(new AjaxCallListener(){
                    private static final long serialVersionUID = 7160235486520935153L;

                    public CharSequence getPrecondition(Component component) {
                        return "if (Wicket.Event.keyCode(attrs.event)  == 13) { return true; } else { return false; }";
                    }
                });
            }
        }});
    }

    @Override
    public SearchClause getModelObject() {
        return (SearchClause)this.clause.getObject();
    }

    @Override
    public FieldPanel<SearchClause> setModelObject(SearchClause object) {
        this.clause.setObject((Object)object);
        return super.setModelObject(object);
    }

    @Override
    public FieldPanel<SearchClause> setNewModel(ListItem item) {
        this.clause.setObject(SearchClause.class.cast(item.getModelObject()));
        return this;
    }

    @Override
    public FieldPanel<SearchClause> setNewModel(IModel<SearchClause> model) {
        this.clause = model;
        return super.setNewModel(model);
    }

    public final MarkupContainer add(Component ... childs) {
        return super.add(childs);
    }

    @Override
    public FieldPanel<SearchClause> settingsDependingComponents() {
        final SearchClause searchClause = (SearchClause)this.clause.getObject();
        WebMarkupContainer operatorContainer = new WebMarkupContainer("operatorContainer");
        operatorContainer.setOutputMarkupId(true);
        this.field.add(new Component[]{operatorContainer});
        BootstrapToggleConfig config = new BootstrapToggleConfig().withOnStyle(BootstrapToggleConfig.Style.info).withOffStyle(BootstrapToggleConfig.Style.warning).withSize(BootstrapToggleConfig.Size.mini);
        this.operatorFragment.add(new Component[]{new BootstrapToggle("operator", (IModel)new Model<Boolean>(){
            private static final long serialVersionUID = -7157802546272668001L;

            public Boolean getObject() {
                return searchClause.getOperator() == SearchClause.Operator.AND;
            }

            public void setObject(Boolean object) {
                searchClause.setOperator(object != false ? SearchClause.Operator.AND : SearchClause.Operator.OR);
            }
        }, config){
            private static final long serialVersionUID = 2969634208049189343L;

            protected IModel<String> getOffLabel() {
                return Model.of((Serializable)((Object)"OR"));
            }

            protected IModel<String> getOnLabel() {
                return Model.of((Serializable)((Object)"AND"));
            }

            protected CheckBox newCheckBox(String id, IModel<Boolean> model) {
                CheckBox checkBox = super.newCheckBox(id, model);
                checkBox.add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                    private static final long serialVersionUID = 1L;

                    protected void onUpdate(AjaxRequestTarget target) {
                    }
                }});
                return checkBox;
            }
        }.setOutputMarkupPlaceholderTag(true)});
        if (this.getIndex() > 0) {
            operatorContainer.add(new Component[]{this.operatorFragment});
        } else {
            operatorContainer.add(new Component[]{this.searchButtonFragment});
        }
        final AjaxDropDownChoicePanel<String> property = new AjaxDropDownChoicePanel<String>("property", "property", (IModel<String>)new PropertyModel((Object)searchClause, "property"));
        property.hideLabel().setRequired(this.required).setOutputMarkupId(true);
        property.setChoices((IModel<List<String>>)this.properties);
        property.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        this.field.add(new Component[]{property});
        final AjaxDropDownChoicePanel<SearchClause.Comparator> comparator = new AjaxDropDownChoicePanel<SearchClause.Comparator>("comparator", "comparator", (IModel<SearchClause.Comparator>)new PropertyModel((Object)searchClause, "comparator"));
        comparator.setChoices((IModel<List<SearchClause.Comparator>>)this.comparators);
        comparator.setNullValid(false).hideLabel().setOutputMarkupId(true);
        comparator.setRequired(this.required);
        comparator.setChoiceRenderer(this.getComparatorRender((IModel<SearchClause>)this.field.getModel()));
        this.field.add(new Component[]{comparator});
        final AjaxTextFieldPanel value = new AjaxTextFieldPanel("value", "value", (IModel<String>)new PropertyModel((Object)searchClause, "value"), false);
        value.hideLabel().setOutputMarkupId(true);
        this.field.add(new Component[]{value});
        value.getField().add(new Behavior[]{AttributeModifier.replace((String)"onkeydown", (IModel)Model.of((Serializable)((Object)"if(event.keyCode == 13) {event.preventDefault();}")))});
        value.getField().add(new Behavior[]{new IndicatorAjaxEventBehavior("onkeydown"){
            private static final long serialVersionUID = -7133385027739964990L;

            protected void onEvent(AjaxRequestTarget target) {
                target.focusComponent(null);
                value.getField().inputChanged();
                value.getField().validate();
                if (value.getField().isValid()) {
                    value.getField().valid();
                    value.getField().updateModel();
                }
            }

            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.getAjaxCallListeners().add(new AjaxCallListener(){
                    private static final long serialVersionUID = 7160235486520935153L;

                    public CharSequence getPrecondition(Component component) {
                        return "if (Wicket.Event.keyCode(attrs.event)  == 13) { return true; } else { return false; }";
                    }
                });
            }
        }});
        final AjaxDropDownChoicePanel<SearchClause.Type> type = new AjaxDropDownChoicePanel<SearchClause.Type>("type", "type", (IModel<SearchClause.Type>)new PropertyModel((Object)searchClause, "type"));
        type.setChoices(this.types).hideLabel().setRequired(this.required).setOutputMarkupId(true);
        type.setNullValid(false);
        type.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                SearchClause searchClause = new SearchClause();
                if (StringUtils.isNotEmpty((CharSequence)type.getDefaultModelObjectAsString())) {
                    searchClause.setType(SearchClause.Type.valueOf(type.getDefaultModelObjectAsString()));
                }
                SearchClausePanel.this.clause.setObject((Object)searchClause);
                SearchClausePanel.this.setFieldAccess(searchClause.getType(), property, comparator, value);
                target.add(new Component[]{property});
                target.add(new Component[]{comparator});
                target.add(new Component[]{value});
            }
        }});
        this.field.add(new Component[]{type});
        comparator.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                if (type.getModelObject() == SearchClause.Type.ATTRIBUTE || type.getModelObject() == SearchClause.Type.RELATIONSHIP) {
                    if (comparator.getModelObject() == SearchClause.Comparator.IS_NULL || comparator.getModelObject() == SearchClause.Comparator.IS_NOT_NULL) {
                        value.setModelObject("");
                        value.setEnabled(false);
                    } else {
                        value.setEnabled(true);
                    }
                    target.add(new Component[]{value});
                }
                if (type.getModelObject() == SearchClause.Type.RELATIONSHIP) {
                    if (comparator.getModelObject() == SearchClause.Comparator.EQUALS || comparator.getModelObject() == SearchClause.Comparator.NOT_EQUALS) {
                        property.setEnabled(false);
                    } else {
                        property.setEnabled(true);
                    }
                    SearchClause searchClause = new SearchClause();
                    searchClause.setType(SearchClause.Type.valueOf(type.getDefaultModelObjectAsString()));
                    searchClause.setComparator((SearchClause.Comparator)((Object)comparator.getModelObject()));
                    SearchClausePanel.this.clause.setObject((Object)searchClause);
                    target.add(new Component[]{property});
                }
            }
        }});
        this.setFieldAccess(searchClause.getType(), property, comparator, value);
        return this;
    }

    private void setFieldAccess(SearchClause.Type type, AjaxDropDownChoicePanel<String> property, FieldPanel<SearchClause.Comparator> comparator, FieldPanel<String> value) {
        if (type != null) {
            property.setEnabled(true);
            comparator.setEnabled(true);
            value.setEnabled(true);
            switch (type) {
                case ATTRIBUTE: {
                    if (!comparator.isEnabled()) {
                        comparator.setEnabled(true);
                        comparator.setRequired(true);
                    }
                    if (comparator.getModelObject() == SearchClause.Comparator.IS_NULL || comparator.getModelObject() == SearchClause.Comparator.IS_NOT_NULL) {
                        value.setEnabled(false);
                        value.setModelObject("");
                    }
                    property.setChoiceRenderer(new DefaultChoiceRender());
                    break;
                }
                case ROLE_MEMBERSHIP: {
                    property.setChoiceRenderer(new DefaultChoiceRender());
                    value.setEnabled(false);
                    value.setModelObject("");
                    break;
                }
                case GROUP_MEMBERSHIP: {
                    property.setChoiceRenderer(new GroupChoiceRender());
                    value.setEnabled(false);
                    value.setModelObject("");
                    break;
                }
                case GROUP_MEMBER: {
                    value.setEnabled(true);
                    property.setEnabled(false);
                    property.setModelObject(null);
                    break;
                }
                case RESOURCE: {
                    property.setChoiceRenderer(new DefaultChoiceRender());
                    value.setEnabled(false);
                    value.setModelObject("");
                    break;
                }
                case RELATIONSHIP: {
                    property.setChoiceRenderer(new DefaultChoiceRender());
                    if (comparator.getModelObject() == SearchClause.Comparator.IS_NULL || comparator.getModelObject() == SearchClause.Comparator.IS_NOT_NULL) {
                        value.setEnabled(false);
                        value.setModelObject("");
                        property.setEnabled(true);
                        break;
                    }
                    value.setEnabled(true);
                    property.setEnabled(false);
                    property.setModelObject(null);
                    break;
                }
            }
        }
    }

    private IChoiceRenderer<SearchClause.Comparator> getComparatorRender(final IModel<SearchClause> clause) {
        return new IChoiceRenderer<SearchClause.Comparator>(){
            private static final long serialVersionUID = -9086043750227867686L;

            public Object getDisplayValue(SearchClause.Comparator object) {
                String display;
                if (clause == null || clause.getObject() == null || ((SearchClause)clause.getObject()).getType() == null) {
                    return object.toString();
                }
                block0 : switch (((SearchClause)clause.getObject()).getType()) {
                    case ATTRIBUTE: {
                        switch (object) {
                            case IS_NULL: {
                                display = "NULL";
                                break block0;
                            }
                            case IS_NOT_NULL: {
                                display = "NOT NULL";
                                break block0;
                            }
                            case EQUALS: {
                                display = "==";
                                break block0;
                            }
                            case NOT_EQUALS: {
                                display = "!=";
                                break block0;
                            }
                            case LESS_THAN: {
                                display = "<";
                                break block0;
                            }
                            case LESS_OR_EQUALS: {
                                display = "<=";
                                break block0;
                            }
                            case GREATER_THAN: {
                                display = ">";
                                break block0;
                            }
                            case GREATER_OR_EQUALS: {
                                display = ">=";
                                break block0;
                            }
                        }
                        display = "";
                        break;
                    }
                    case GROUP_MEMBERSHIP: {
                        switch (object) {
                            case EQUALS: {
                                display = "IN";
                                break block0;
                            }
                            case NOT_EQUALS: {
                                display = "NOT IN";
                                break block0;
                            }
                        }
                        display = "";
                        break;
                    }
                    case GROUP_MEMBER: {
                        switch (object) {
                            case EQUALS: {
                                display = "WITH";
                                break block0;
                            }
                            case NOT_EQUALS: {
                                display = "NOT WITH";
                                break block0;
                            }
                        }
                        display = "";
                        break;
                    }
                    case ROLE_MEMBERSHIP: 
                    case RESOURCE: {
                        switch (object) {
                            case EQUALS: {
                                display = "HAS";
                                break block0;
                            }
                            case NOT_EQUALS: {
                                display = "HAS NOT";
                                break block0;
                            }
                        }
                        display = "";
                        break;
                    }
                    case RELATIONSHIP: {
                        switch (object) {
                            case IS_NOT_NULL: {
                                display = "EXIST";
                                break block0;
                            }
                            case IS_NULL: {
                                display = "NOT EXIST";
                                break block0;
                            }
                            case EQUALS: {
                                display = "WITH";
                                break block0;
                            }
                            case NOT_EQUALS: {
                                display = "NOT WITH";
                                break block0;
                            }
                        }
                        display = "";
                        break;
                    }
                    default: {
                        display = object.toString();
                    }
                }
                return display;
            }

            public String getIdValue(SearchClause.Comparator object, int index) {
                return this.getDisplayValue(object).toString();
            }

            public SearchClause.Comparator getObject(String id, IModel<? extends List<? extends SearchClause.Comparator>> choices) {
                SearchClause.Comparator res;
                if (id == null) {
                    return SearchClause.Comparator.EQUALS;
                }
                switch (id) {
                    case "HAS": 
                    case "IN": 
                    case "WITH": {
                        res = SearchClause.Comparator.EQUALS;
                        break;
                    }
                    case "HAS NOT": 
                    case "NOT IN": 
                    case "NOT WITH": {
                        res = SearchClause.Comparator.NOT_EQUALS;
                        break;
                    }
                    case "NULL": 
                    case "NOT EXIST": {
                        res = SearchClause.Comparator.IS_NULL;
                        break;
                    }
                    case "NOT NULL": 
                    case "EXIST": {
                        res = SearchClause.Comparator.IS_NOT_NULL;
                        break;
                    }
                    case "==": {
                        res = SearchClause.Comparator.EQUALS;
                        break;
                    }
                    case "!=": {
                        res = SearchClause.Comparator.NOT_EQUALS;
                        break;
                    }
                    case "<": {
                        res = SearchClause.Comparator.LESS_THAN;
                        break;
                    }
                    case "<=": {
                        res = SearchClause.Comparator.LESS_OR_EQUALS;
                        break;
                    }
                    case ">": {
                        res = SearchClause.Comparator.GREATER_THAN;
                        break;
                    }
                    case ">=": {
                        res = SearchClause.Comparator.GREATER_OR_EQUALS;
                        break;
                    }
                    default: {
                        res = SearchClause.Comparator.EQUALS;
                    }
                }
                return res;
            }
        };
    }

    @Override
    public FieldPanel<SearchClause> clone() {
        SearchClausePanel panel = new SearchClausePanel(this.getId(), this.name, null, this.required, this.types, this.anames, this.dnames, this.groupNames, this.roleNames, this.resourceNames);
        panel.setReadOnly(this.isReadOnly());
        panel.setRequired(this.isRequired());
        if (this.searchButton.isEnabled()) {
            panel.enableSearch(this.resultContainer);
        }
        return panel;
    }

    public static class SearchEvent
    implements Serializable {
        private static final long serialVersionUID = 2693338614198749301L;
        private final AjaxRequestTarget target;

        public SearchEvent(AjaxRequestTarget target) {
            this.target = target;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }

    private class GroupChoiceRender
    extends DefaultChoiceRender {
        private static final long serialVersionUID = -8034248752951761058L;

        private GroupChoiceRender() {
        }

        @Override
        public String getIdValue(String object, int index) {
            return object;
        }

        @Override
        public String getObject(String id, IModel<? extends List<? extends String>> choices) {
            return id;
        }

        @Override
        public Object getDisplayValue(String object) {
            return ((Map)SearchClausePanel.this.groupNames.getObject()).get(object);
        }
    }

    private class DefaultChoiceRender
    implements IChoiceRenderer<String> {
        private static final long serialVersionUID = -8034248752951761058L;

        private DefaultChoiceRender() {
        }

        public Object getDisplayValue(String object) {
            return object;
        }

        public String getIdValue(String object, int index) {
            return object;
        }

        public String getObject(String id, IModel<? extends List<? extends String>> choices) {
            return id;
        }
    }
}

