/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.client.CompleteCondition;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.AnyObjectFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.GroupFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.search.SpecialAttr;
import org.apache.syncope.common.lib.search.SyncopeFiqlParser;
import org.apache.syncope.common.lib.search.SyncopeFiqlSearchCondition;
import org.apache.syncope.common.lib.search.SyncopeProperty;
import org.apache.syncope.common.lib.search.UserFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.types.AttrSchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SearchUtils
implements Serializable {
    private static final long serialVersionUID = 398381905376547084L;
    private static final Logger LOG = LoggerFactory.getLogger(SearchUtils.class);

    private static Pattern getTypeConditionPattern(String type) {
        return Pattern.compile(String.format(";\\$type==%s|\\$type==%s;", type, type));
    }

    public static Map<String, List<SearchClause>> getSearchClauses(Map<String, String> fiql) {
        HashMap<String, List<SearchClause>> res = new HashMap<String, List<SearchClause>>();
        if (fiql != null && !fiql.isEmpty()) {
            for (Map.Entry<String, String> entry : fiql.entrySet()) {
                res.put(entry.getKey(), SearchUtils.getSearchClauses(entry.getValue().replaceAll(SearchUtils.getTypeConditionPattern(entry.getKey()).pattern(), "")));
            }
        }
        return res;
    }

    public static List<SearchClause> getSearchClauses(String fiql) {
        ArrayList<SearchClause> res = new ArrayList<SearchClause>();
        if (StringUtils.isNotBlank((CharSequence)fiql)) {
            try {
                SyncopeFiqlParser fiqlParser = new SyncopeFiqlParser(SearchBean.class, AbstractFiqlSearchConditionBuilder.CONTEXTUAL_PROPERTIES);
                res.addAll(SearchUtils.getSearchClauses((SearchCondition<SearchBean>)fiqlParser.parse(fiql)));
            }
            catch (Exception e) {
                LOG.error("Unparseable FIQL expression '{}'", (Object)fiql, (Object)e);
            }
        }
        return res;
    }

    private static List<SearchClause> getSearchClauses(SearchCondition<SearchBean> sc) {
        ArrayList<SearchClause> res = new ArrayList<SearchClause>();
        if (sc.getStatement() == null) {
            res.addAll(SearchUtils.getCompoundSearchClause(sc));
        } else {
            res.add(SearchUtils.getPrimitiveSearchClause(sc));
        }
        return res;
    }

    private static List<SearchClause> getCompoundSearchClause(SearchCondition<SearchBean> sc) {
        ArrayList<SearchClause> res = new ArrayList<SearchClause>();
        for (SearchCondition searchCondition : sc.getSearchConditions()) {
            if (searchCondition.getStatement() == null) {
                res.addAll(SearchUtils.getCompoundSearchClause((SearchCondition<SearchBean>)searchCondition));
                continue;
            }
            SearchClause clause = SearchUtils.getPrimitiveSearchClause((SearchCondition<SearchBean>)searchCondition);
            if (sc.getConditionType() == ConditionType.AND) {
                clause.setOperator(SearchClause.Operator.AND);
            }
            if (sc.getConditionType() == ConditionType.OR) {
                clause.setOperator(SearchClause.Operator.OR);
            }
            res.add(clause);
        }
        return res;
    }

    private static SearchClause getPrimitiveSearchClause(SearchCondition<SearchBean> sc) {
        SearchClause res = new SearchClause();
        String property = (String)((SearchBean)sc.getCondition()).getKeySet().iterator().next();
        res.setProperty(property);
        String value = ((SearchBean)sc.getCondition()).get(property);
        res.setValue(value);
        LOG.debug("Condition: " + sc.getCondition());
        if (SpecialAttr.ROLES.toString().equals(property)) {
            res.setType(SearchClause.Type.ROLE_MEMBERSHIP);
            res.setProperty(value);
        } else if (SpecialAttr.RELATIONSHIPS.toString().equals(property)) {
            res.setType(SearchClause.Type.RELATIONSHIP);
            res.setProperty(value);
        } else if (SpecialAttr.RELATIONSHIP_TYPES.toString().equals(property)) {
            res.setType(SearchClause.Type.RELATIONSHIP);
            res.setProperty(value);
        } else if (SpecialAttr.GROUPS.toString().equals(property)) {
            res.setType(SearchClause.Type.GROUP_MEMBERSHIP);
            res.setProperty(value);
        } else if (SpecialAttr.RESOURCES.toString().equals(property)) {
            res.setType(SearchClause.Type.RESOURCE);
            res.setProperty(value);
        } else if (SpecialAttr.MEMBER.toString().equals(property)) {
            res.setType(SearchClause.Type.GROUP_MEMBER);
            res.setProperty(value);
        } else {
            res.setType(SearchClause.Type.ATTRIBUTE);
        }
        ConditionType ct = sc.getConditionType();
        if (sc instanceof SyncopeFiqlSearchCondition && sc.getConditionType() == ConditionType.CUSTOM) {
            SyncopeFiqlSearchCondition sfsc = (SyncopeFiqlSearchCondition)sc;
            if ("=~".equals(sfsc.getOperator())) {
                ct = ConditionType.EQUALS;
            } else if ("!~".equals(sfsc.getOperator())) {
                ct = ConditionType.NOT_EQUALS;
            }
        }
        switch (ct) {
            case EQUALS: {
                if (SpecialAttr.RELATIONSHIP_TYPES.toString().equals(property)) {
                    res.setComparator(SpecialAttr.NULL.toString().equals(value) ? SearchClause.Comparator.EQUALS : SearchClause.Comparator.IS_NULL);
                    break;
                }
                res.setComparator(SpecialAttr.NULL.toString().equals(value) ? SearchClause.Comparator.IS_NULL : SearchClause.Comparator.EQUALS);
                break;
            }
            case NOT_EQUALS: {
                if (SpecialAttr.RELATIONSHIP_TYPES.toString().equals(property)) {
                    res.setComparator(SpecialAttr.NULL.toString().equals(value) ? SearchClause.Comparator.NOT_EQUALS : SearchClause.Comparator.IS_NOT_NULL);
                    break;
                }
                res.setComparator(SpecialAttr.NULL.toString().equals(value) ? SearchClause.Comparator.IS_NOT_NULL : SearchClause.Comparator.NOT_EQUALS);
                break;
            }
            case GREATER_OR_EQUALS: {
                res.setComparator(SearchClause.Comparator.GREATER_OR_EQUALS);
                break;
            }
            case GREATER_THAN: {
                res.setComparator(SearchClause.Comparator.GREATER_THAN);
                break;
            }
            case LESS_OR_EQUALS: {
                res.setComparator(SearchClause.Comparator.LESS_OR_EQUALS);
                break;
            }
            case LESS_THAN: {
                res.setComparator(SearchClause.Comparator.LESS_THAN);
                break;
            }
        }
        return res;
    }

    public static String buildFIQL(List<SearchClause> clauses, AbstractFiqlSearchConditionBuilder builder) {
        return SearchUtils.buildFIQL(clauses, builder, Collections.emptyMap());
    }

    public static String buildFIQL(List<SearchClause> clauses, AbstractFiqlSearchConditionBuilder builder, Map<String, PlainSchemaTO> availableSchemaTypes) {
        LOG.debug("Generating FIQL from List<SearchClause>: {}", clauses);
        CompleteCondition condition = null;
        boolean notTheFirst = false;
        for (SearchClause clause : clauses) {
            CompleteCondition prevCondition = condition;
            if (clause.getType() != null) {
                block0 : switch (clause.getType()) {
                    case GROUP_MEMBER: {
                        switch (clause.getComparator()) {
                            case EQUALS: {
                                condition = ((GroupFiqlSearchConditionBuilder)builder).withMembers(clause.getValue(), new String[0]);
                                break block0;
                            }
                            case NOT_EQUALS: {
                                condition = ((GroupFiqlSearchConditionBuilder)builder).withoutMembers(clause.getValue(), new String[0]);
                                break block0;
                            }
                        }
                        break;
                    }
                    case GROUP_MEMBERSHIP: {
                        if (!StringUtils.isNotBlank((CharSequence)clause.getProperty())) break;
                        String groupKey = clause.getProperty().split(" ")[0];
                        if (builder instanceof UserFiqlSearchConditionBuilder) {
                            condition = clause.getComparator() == SearchClause.Comparator.EQUALS ? ((UserFiqlSearchConditionBuilder)builder).inGroups(groupKey, new String[0]) : ((UserFiqlSearchConditionBuilder)builder).notInGroups(groupKey, new String[0]);
                            break;
                        }
                        condition = clause.getComparator() == SearchClause.Comparator.EQUALS ? ((AnyObjectFiqlSearchConditionBuilder)builder).inGroups(groupKey, new String[0]) : ((AnyObjectFiqlSearchConditionBuilder)builder).notInGroups(groupKey, new String[0]);
                        break;
                    }
                    case RESOURCE: {
                        if (!StringUtils.isNotBlank((CharSequence)clause.getProperty())) break;
                        condition = clause.getComparator() == SearchClause.Comparator.EQUALS ? builder.hasResources(clause.getProperty(), new String[0]) : builder.hasNotResources(clause.getProperty(), new String[0]);
                        break;
                    }
                    case ATTRIBUTE: {
                        if (!StringUtils.isNotBlank((CharSequence)clause.getProperty())) break;
                        boolean isLong = availableSchemaTypes.get(clause.getProperty()) != null && availableSchemaTypes.get(clause.getProperty()).getType() == AttrSchemaType.Long;
                        SyncopeProperty property = builder.is(clause.getProperty());
                        switch (clause.getComparator()) {
                            case IS_NULL: {
                                condition = builder.isNull(clause.getProperty());
                                break block0;
                            }
                            case IS_NOT_NULL: {
                                condition = builder.isNotNull(clause.getProperty());
                                break block0;
                            }
                            case LESS_THAN: {
                                condition = isLong ? property.lessThan(Long.valueOf(NumberUtils.toLong((String)clause.getValue()))) : property.lexicalBefore(clause.getValue());
                                break block0;
                            }
                            case LESS_OR_EQUALS: {
                                condition = isLong ? property.lessOrEqualTo(Long.valueOf(NumberUtils.toLong((String)clause.getValue()))) : property.lexicalNotAfter(clause.getValue());
                                break block0;
                            }
                            case GREATER_THAN: {
                                condition = isLong ? property.greaterThan(Long.valueOf(NumberUtils.toLong((String)clause.getValue()))) : property.lexicalAfter(clause.getValue());
                                break block0;
                            }
                            case GREATER_OR_EQUALS: {
                                condition = isLong ? property.greaterOrEqualTo(Long.valueOf(NumberUtils.toLong((String)clause.getValue()))) : property.lexicalNotBefore(clause.getValue());
                                break block0;
                            }
                            case NOT_EQUALS: {
                                condition = property.notEqualTolIgnoreCase(clause.getValue());
                                break block0;
                            }
                        }
                        condition = property.equalToIgnoreCase(clause.getValue(), new String[0]);
                        break;
                    }
                    case ROLE_MEMBERSHIP: {
                        if (!StringUtils.isNotBlank((CharSequence)clause.getProperty())) break;
                        switch (clause.getComparator()) {
                            case EQUALS: {
                                condition = ((UserFiqlSearchConditionBuilder)builder).inRoles(clause.getProperty(), new String[0]);
                                break block0;
                            }
                            case NOT_EQUALS: {
                                condition = ((UserFiqlSearchConditionBuilder)builder).notInRoles(clause.getProperty(), new String[0]);
                                break block0;
                            }
                        }
                        break;
                    }
                    case RELATIONSHIP: {
                        if (!StringUtils.isNotBlank((CharSequence)clause.getProperty())) break;
                        if (builder instanceof UserFiqlSearchConditionBuilder) {
                            switch (clause.getComparator()) {
                                case IS_NOT_NULL: {
                                    condition = ((UserFiqlSearchConditionBuilder)builder).inRelationshipTypes(clause.getProperty(), new String[0]);
                                    break block0;
                                }
                                case IS_NULL: {
                                    condition = ((UserFiqlSearchConditionBuilder)builder).notInRelationshipTypes(clause.getProperty(), new String[0]);
                                    break block0;
                                }
                                case EQUALS: {
                                    condition = ((UserFiqlSearchConditionBuilder)builder).inRelationships(clause.getValue(), new String[0]);
                                    break block0;
                                }
                                case NOT_EQUALS: {
                                    condition = ((UserFiqlSearchConditionBuilder)builder).notInRelationships(clause.getValue(), new String[0]);
                                    break block0;
                                }
                            }
                            break;
                        }
                        switch (clause.getComparator()) {
                            case IS_NOT_NULL: {
                                condition = ((AnyObjectFiqlSearchConditionBuilder)builder).inRelationshipTypes(clause.getProperty(), new String[0]);
                                break block0;
                            }
                            case IS_NULL: {
                                condition = ((AnyObjectFiqlSearchConditionBuilder)builder).notInRelationshipTypes(clause.getProperty(), new String[0]);
                                break block0;
                            }
                            case EQUALS: {
                                condition = ((AnyObjectFiqlSearchConditionBuilder)builder).inRelationships(clause.getValue(), new String[0]);
                                break block0;
                            }
                            case NOT_EQUALS: {
                                condition = ((AnyObjectFiqlSearchConditionBuilder)builder).notInRelationships(clause.getValue(), new String[0]);
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
            if (notTheFirst) {
                if (clause.getOperator() == SearchClause.Operator.AND) {
                    condition = builder.and(prevCondition, condition, new CompleteCondition[0]);
                }
                if (clause.getOperator() == SearchClause.Operator.OR) {
                    condition = builder.or(prevCondition, condition, new CompleteCondition[0]);
                }
            }
            notTheFirst = true;
        }
        String fiql = condition == null ? null : condition.query();
        LOG.debug("Generated FIQL: {}", (Object)fiql);
        return fiql;
    }

    private SearchUtils() {
    }
}

