/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.console.panels.search.AnyObjectSearchPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.rest.RoleRestClient;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public final class UserSearchPanel
extends AnyObjectSearchPanel {
    private static final long serialVersionUID = -1769527800450203738L;
    private final RoleRestClient roleRestClient = new RoleRestClient();

    private UserSearchPanel(String id, Builder builder) {
        super(id, AnyTypeKind.USER, builder);
    }

    @Override
    protected void populate() {
        super.populate();
        this.roleNames = new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                return (List)CollectionUtils.collect(UserSearchPanel.this.roleRestClient.list(), (Transformer)new Transformer<RoleTO, String>(){

                    public String transform(RoleTO input) {
                        return input.getKey();
                    }
                }, new ArrayList());
            }
        };
    }

    @Override
    protected List<SearchClause.Type> getAvailableTypes() {
        ArrayList<SearchClause.Type> result = new ArrayList<SearchClause.Type>();
        result.add(SearchClause.Type.ATTRIBUTE);
        result.add(SearchClause.Type.ROLE_MEMBERSHIP);
        result.add(SearchClause.Type.GROUP_MEMBERSHIP);
        result.add(SearchClause.Type.RESOURCE);
        result.add(SearchClause.Type.RELATIONSHIP);
        return result;
    }

    public static class Builder
    extends AnyObjectSearchPanel.Builder {
        private static final long serialVersionUID = 6308997285778809578L;

        public Builder(IModel<List<SearchClause>> model) {
            super(AnyTypeKind.USER.name(), model);
        }

        @Override
        public UserSearchPanel build(String id) {
            return new UserSearchPanel(id, this);
        }
    }
}

