/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.policies.PolicyRuleWizardBuilder;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.policy.AbstractPolicyTO;
import org.apache.syncope.common.lib.policy.RuleConf;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.core.util.lang.PropertyResolver;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.PropertyColumn;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class PolicyRuleDirectoryPanel<T extends AbstractPolicyTO>
extends DirectoryPanel<PolicyRuleWrapper, PolicyRuleWrapper, DirectoryDataProvider<PolicyRuleWrapper>, PolicyRestClient>
implements ModalPanel {
    private static final long serialVersionUID = 4984337552918213290L;
    private final BaseModal<T> baseModal;
    private final String policy;

    protected PolicyRuleDirectoryPanel(BaseModal<T> baseModal, String policy, PolicyType type, PageReference pageRef) {
        super("content", pageRef, false);
        this.disableCheckBoxes();
        this.baseModal = baseModal;
        this.policy = policy;
        this.restClient = new PolicyRestClient();
        this.enableExitButton();
        this.addNewItemPanelBuilder(new PolicyRuleWizardBuilder(policy, type, new PolicyRuleWrapper(), pageRef), true);
        MetaDataRoleAuthorizationStrategy.authorize((Component)this.addAjaxLink, (Action)RENDER, (String)"POLICY_UPDATE");
        this.initResultTable();
    }

    @Override
    protected List<IColumn<PolicyRuleWrapper, String>> getColumns() {
        ArrayList<IColumn<PolicyRuleWrapper, String>> columns = new ArrayList<IColumn<PolicyRuleWrapper, String>>();
        columns.add((IColumn<PolicyRuleWrapper, String>)new PropertyColumn((IModel)new StringResourceModel("ruleConf", (Component)this), (Object)"name", "name"));
        columns.add((IColumn<PolicyRuleWrapper, String>)new AbstractColumn<PolicyRuleWrapper, String>((IModel)new StringResourceModel("configuration", (Component)this)){
            private static final long serialVersionUID = -4008579357070833846L;

            public void populateItem(Item<ICellPopulator<PolicyRuleWrapper>> cellItem, String componentId, IModel<PolicyRuleWrapper> rowModel) {
                cellItem.add(new Component[]{new Label(componentId, (Serializable)((Object)((PolicyRuleWrapper)rowModel.getObject()).getConf().getClass().getName()))});
            }
        });
        return columns;
    }

    @Override
    public ActionsPanel<PolicyRuleWrapper> getActions(final IModel<PolicyRuleWrapper> model) {
        ActionsPanel<PolicyRuleWrapper> panel = super.getActions(model);
        panel.add(new ActionLink<PolicyRuleWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PolicyRuleWrapper ignore) {
                RuleConf clone = (RuleConf)SerializationUtils.clone((Serializable)((PolicyRuleWrapper)model.getObject()).getConf());
                PolicyRuleDirectoryPanel.this.getTogglePanel().close(target);
                PolicyRuleDirectoryPanel.this.send((IEventSink)PolicyRuleDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<PolicyRuleWrapper>(new PolicyRuleWrapper().setConf(clone), target));
            }
        }, ActionLink.ActionType.CLONE, "POLICY_CREATE");
        panel.add(new ActionLink<PolicyRuleWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PolicyRuleWrapper ignore) {
                PolicyRuleDirectoryPanel.this.getTogglePanel().close(target);
                PolicyRuleDirectoryPanel.this.send((IEventSink)PolicyRuleDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent<Serializable>((Serializable)model.getObject(), target));
            }
        }, ActionLink.ActionType.EDIT, "POLICY_UPDATE");
        panel.add(new ActionLink<PolicyRuleWrapper>(){
            private static final long serialVersionUID = -3722207913631435501L;

            @Override
            public void onClick(AjaxRequestTarget target, PolicyRuleWrapper ignore) {
                final RuleConf rule = ((PolicyRuleWrapper)model.getObject()).getConf();
                try {
                    Object actual = ((PolicyRestClient)PolicyRuleDirectoryPanel.this.restClient).getPolicy(PolicyRuleDirectoryPanel.this.policy);
                    CollectionUtils.filter((Iterable)PolicyRuleDirectoryPanel.this.getRuleConf(actual), (Predicate)new Predicate<RuleConf>(){

                        public boolean evaluate(RuleConf object) {
                            return !object.getName().equals(rule.getName());
                        }
                    });
                    ((PolicyRestClient)PolicyRuleDirectoryPanel.this.restClient).updatePolicy(actual);
                    SyncopeConsoleSession.get().info((Serializable)((Object)PolicyRuleDirectoryPanel.this.getString("operation_succeeded")));
                    PolicyRuleDirectoryPanel.this.customActionOnFinishCallback(target);
                }
                catch (SyncopeClientException e) {
                    LOG.error("While deleting {}", (Object)rule.getName(), (Object)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                }
                ((BasePage)PolicyRuleDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.DELETE, "POLICY_DELETE", true);
        return panel;
    }

    @Override
    public ActionsPanel<Serializable> getHeader(String componentId) {
        ActionsPanel<Serializable> panel = new ActionsPanel<Serializable>(componentId, null);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                if (target != null) {
                    PolicyRuleDirectoryPanel.this.customActionOnFinishCallback(target);
                }
            }
        }, ActionLink.ActionType.RELOAD, "TASK_LIST").hideLabel();
        return panel;
    }

    @Override
    protected Collection<ActionLink.ActionType> getBulkActions() {
        ArrayList<ActionLink.ActionType> bulkActions = new ArrayList<ActionLink.ActionType>();
        bulkActions.add(ActionLink.ActionType.DELETE);
        return bulkActions;
    }

    @Override
    protected PolicyRuleDataProvider dataProvider() {
        return new PolicyRuleDataProvider(this.rows);
    }

    @Override
    protected String paginatorRowsKey() {
        return "policy.rules.paginator.rows";
    }

    private List<RuleConf> getRuleConf(T policyTO) {
        Object res = PropertyResolver.getValue((String)"ruleConfs", policyTO);
        if (res instanceof List) {
            return (List)res;
        }
        return null;
    }

    @Override
    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent && this.modal != null) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.baseModal.show(false);
            this.baseModal.close((IPartialPageRequestHandler)target);
        }
    }

    public static class PolicyRuleWrapper
    implements Serializable {
        private static final long serialVersionUID = 2472755929742424558L;
        private String oldname;
        private String name;
        private RuleConf conf;

        public PolicyRuleWrapper() {
            this(null);
        }

        public PolicyRuleWrapper(String name) {
            this.oldname = name;
        }

        public boolean isNew() {
            return this.oldname == null;
        }

        public String getOldName() {
            return this.oldname;
        }

        public String getName() {
            return this.name;
        }

        public PolicyRuleWrapper setName(String name) {
            this.name = name;
            return this;
        }

        public RuleConf getConf() {
            return this.conf;
        }

        public PolicyRuleWrapper setConf(RuleConf conf) {
            this.conf = conf;
            return this;
        }
    }

    protected class PolicyRuleDataProvider
    extends DirectoryDataProvider<PolicyRuleWrapper> {
        private static final long serialVersionUID = 4725679400450513556L;
        private final SortableDataProviderComparator<PolicyRuleWrapper> comparator;

        public PolicyRuleDataProvider(int paginatorRows) {
            super(paginatorRows);
            this.setSort("name", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator<PolicyRuleWrapper>(this);
        }

        public Iterator<PolicyRuleWrapper> iterator(long first, long count) {
            Object actual = ((PolicyRestClient)PolicyRuleDirectoryPanel.this.restClient).getPolicy(PolicyRuleDirectoryPanel.this.policy);
            ArrayList rules = (ArrayList)CollectionUtils.collect((Iterable)PolicyRuleDirectoryPanel.this.getRuleConf(actual), (Transformer)new Transformer<RuleConf, PolicyRuleWrapper>(){

                public PolicyRuleWrapper transform(RuleConf input) {
                    return new PolicyRuleWrapper(input.getName()).setName(input.getName()).setConf(input);
                }
            }, new ArrayList());
            Collections.sort(rules, this.comparator);
            return rules.subList((int)first, (int)(first + count)).iterator();
        }

        public long size() {
            Object actual = ((PolicyRestClient)PolicyRuleDirectoryPanel.this.restClient).getPolicy(PolicyRuleDirectoryPanel.this.policy);
            return PolicyRuleDirectoryPanel.this.getRuleConf(actual).size();
        }

        public IModel<PolicyRuleWrapper> model(PolicyRuleWrapper object) {
            return new CompoundPropertyModel((Object)object);
        }
    }
}

