/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.rest.SchemaRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.MultiPanel;
import org.apache.syncope.common.lib.policy.AbstractPolicyTO;
import org.apache.syncope.common.lib.policy.PullPolicyTO;
import org.apache.syncope.common.lib.to.AbstractSchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.ConflictResolutionAction;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class PolicySpecModalPanel
extends AbstractModalPanel<PullPolicyTO> {
    private static final long serialVersionUID = 5945391813567245081L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final IModel<List<CorrelationRule>> model;
    private final PolicyRestClient restClient = new PolicyRestClient();

    public PolicySpecModalPanel(final PullPolicyTO policyTO, BaseModal<PullPolicyTO> modal, PageReference pageRef) {
        super(modal, pageRef);
        modal.setFormModel(policyTO);
        this.add(new Component[]{new AjaxDropDownChoicePanel<ConflictResolutionAction>("conflictResolutionAction", "conflictResolutionAction", (IModel<ConflictResolutionAction>)new PropertyModel((Object)policyTO.getSpecification(), "conflictResolutionAction")).setChoices(Arrays.asList(ConflictResolutionAction.values()))});
        this.model = new PropertyModel<List<CorrelationRule>>((Object)policyTO.getSpecification(), "correlationRules"){
            private static final long serialVersionUID = -8168676563540297301L;
            private List<CorrelationRule> rules;
            {
                super(x0, x1);
                this.rules = (List)CollectionUtils.collect(policyTO.getSpecification().getCorrelationRules() == null ? Collections.emptySet() : policyTO.getSpecification().getCorrelationRules().keySet(), (Transformer)new Transformer<String, CorrelationRule>(){

                    public CorrelationRule transform(String input) {
                        return new CorrelationRule(input, (String)policyTO.getSpecification().getCorrelationRules().get(input));
                    }
                }, new ArrayList());
            }

            public List<CorrelationRule> getObject() {
                return this.rules;
            }

            public void setObject(List<CorrelationRule> object) {
                policyTO.getSpecification().getCorrelationRules().clear();
                for (CorrelationRule rule : this.rules) {
                    policyTO.getSpecification().getCorrelationRules().put(rule.getAny(), rule.getRule());
                }
            }
        };
        this.add(new Component[]{new MultiPanel<CorrelationRule>("correlationRules", "correlationRules", this.model){
            private static final long serialVersionUID = -2481579077338205547L;

            @Override
            protected CorrelationRule newModelObject() {
                return new CorrelationRule();
            }

            protected CorrelationRulePanel getItemPanel(ListItem<CorrelationRule> item) {
                return new CorrelationRulePanel("panel", (IModel<CorrelationRule>)Model.of((Serializable)((Serializable)item.getModelObject())));
            }
        }});
    }

    @Override
    public void onSubmit(AjaxRequestTarget target, Form<?> form) {
        try {
            ((PullPolicyTO)this.getItem()).getSpecification().getCorrelationRules().clear();
            for (CorrelationRule rule : (List)this.model.getObject()) {
                ((PullPolicyTO)this.getItem()).getSpecification().getCorrelationRules().put(rule.getAny(), rule.getRule());
            }
            this.restClient.updatePolicy((AbstractPolicyTO)this.getItem());
            SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While creating/updating policy", (Throwable)e);
            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    protected static class CorrelationRule
    implements Serializable {
        private static final long serialVersionUID = 5250228867297353011L;
        private String any;
        private String type;
        private String rule;

        public CorrelationRule() {
            this.any = AnyTypeKind.USER.name();
            this.type = "PLAIN ATTRIBUTES";
            this.rule = "[]";
        }

        public CorrelationRule(String any, String rule) {
            this.any = any;
            this.type = StringUtils.isEmpty((CharSequence)rule) || rule.trim().startsWith("[") ? "PLAIN ATTRIBUTES" : "JAVA";
            this.rule = rule;
        }

        public String getAny() {
            return this.any;
        }

        public String getType() {
            return this.type;
        }

        public String getRule() {
            return this.rule;
        }

        public void setAny(String any) {
            this.any = any;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setRule(String rule) {
            this.rule = rule;
        }
    }

    public static class CorrelationRulePanel
    extends Panel {
        private static final long serialVersionUID = -4708008994320210839L;

        public CorrelationRulePanel(String id, final IModel<CorrelationRule> rule) {
            super(id);
            AjaxDropDownChoicePanel<String> anyType = new AjaxDropDownChoicePanel("anyType", "any.type", new PropertyModel(rule.getObject(), "any")).setNullValid(true).setChoices(new AnyTypeRestClient().list());
            this.add(new Component[]{anyType});
            final AjaxDropDownChoicePanel<String> ruleType = new AjaxDropDownChoicePanel("ruleType", "rule.type", new PropertyModel(rule.getObject(), "type"), false).setNullValid(true).setChoices(Arrays.asList("PLAIN ATTRIBUTES", "JAVA"));
            this.add(new Component[]{ruleType});
            final AjaxDropDownChoicePanel javaRule = new AjaxDropDownChoicePanel("javaRule", "rule.java", new PropertyModel(rule.getObject(), "rule")).setChoices(new ArrayList(SyncopeConsoleSession.get().getPlatformInfo().getPullCorrelationRules()));
            javaRule.setOutputMarkupPlaceholderTag(true);
            this.add(new Component[]{javaRule.setVisible("JAVA".equals(((CorrelationRule)rule.getObject()).getType()))});
            AjaxPalettePanel.Builder<String> jsonRuleBuilder = new AjaxPalettePanel.Builder().setName("rule.json");
            PropertyModel<List<String>> jsonRuleModel = new PropertyModel<List<String>>(rule.getObject(), "rule"){
                private static final long serialVersionUID = 3799387950428254072L;

                public List<String> getObject() {
                    ArrayList<String> res = new ArrayList<String>();
                    try {
                        JsonNode obj = OBJECT_MAPPER.readTree(((CorrelationRule)rule.getObject()).getRule());
                        if (obj.isArray()) {
                            for (JsonNode objNode : obj) {
                                res.add(objNode.asText());
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.warn("Error deserializing json tree", (Throwable)e);
                    }
                    return res;
                }

                public void setObject(List<String> object) {
                    StringBuilder bld = new StringBuilder();
                    bld.append("[");
                    boolean comma = false;
                    for (String obj : object) {
                        if (comma) {
                            bld.append(",");
                        } else {
                            comma = true;
                        }
                        bld.append("\"").append(obj).append("\"");
                    }
                    bld.append("]");
                    ((CorrelationRule)rule.getObject()).setRule(bld.toString());
                }
            };
            final AjaxPalettePanel<String> jsonRule = jsonRuleBuilder.build("jsonRule", (IModel<List<String>>)jsonRuleModel, new AjaxPalettePanel.Builder.Query<String>(){
                private static final long serialVersionUID = -7223078772249308813L;

                @Override
                public List<String> execute(String filter) {
                    return CorrelationRulePanel.getPlainSchemas((CorrelationRule)rule.getObject());
                }
            });
            jsonRule.hideLabel().setOutputMarkupPlaceholderTag(true);
            anyType.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    if (jsonRule.isVisibleInHierarchy()) {
                        ((CorrelationRule)rule.getObject()).setRule("[]");
                        jsonRule.reload(target);
                        target.add(new Component[]{jsonRule});
                    }
                }
            }});
            this.add(new Component[]{jsonRule.setVisible("PLAIN ATTRIBUTES".equals(((CorrelationRule)rule.getObject()).getType()))});
            ruleType.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    switch (ruleType.getModelObject() == null ? "" : (String)ruleType.getModelObject()) {
                        case "PLAIN ATTRIBUTES": {
                            jsonRule.setVisible(true);
                            javaRule.setVisible(false);
                            jsonRule.reload(target);
                            break;
                        }
                        case "JAVA": {
                            jsonRule.setVisible(false);
                            javaRule.setVisible(true);
                            break;
                        }
                        default: {
                            javaRule.setVisible(false);
                            jsonRule.setVisible(false);
                        }
                    }
                    target.add(new Component[]{jsonRule});
                    target.add(new Component[]{javaRule});
                }
            }});
        }

        private static List<String> getPlainSchemas(CorrelationRule rule) {
            ArrayList choices = StringUtils.isEmpty((CharSequence)rule.getAny()) ? new ArrayList() : (ArrayList)CollectionUtils.collect(new SchemaRestClient().getSchemas(SchemaType.PLAIN, rule.getAny().equals(AnyTypeKind.USER.name()) ? AnyTypeKind.USER : (rule.getAny().equals(AnyTypeKind.GROUP.name()) ? AnyTypeKind.GROUP : AnyTypeKind.ANY_OBJECT)), (Transformer)new Transformer<AbstractSchemaTO, String>(){

                public String transform(AbstractSchemaTO input) {
                    return input.getKey();
                }
            }, new ArrayList());
            choices.add("key");
            choices.add(rule.getAny().equals(AnyTypeKind.USER.name()) ? "username" : "name");
            Collections.sort(choices);
            return choices;
        }
    }
}

