/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.reports;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.panels.BeanPanel;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.reports.ReportletDirectoryPanel;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.report.AbstractReportletConf;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.ReportTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public class ReportletWizardBuilder
extends AjaxWizardBuilder<ReportletDirectoryPanel.ReportletWrapper> {
    private static final long serialVersionUID = 5945391813567245081L;
    private final ReportRestClient restClient = new ReportRestClient();
    private final String report;

    public ReportletWizardBuilder(String report, ReportletDirectoryPanel.ReportletWrapper reportlet, PageReference pageRef) {
        super(reportlet, pageRef);
        this.report = report;
    }

    @Override
    protected Serializable onApplyInternal(final ReportletDirectoryPanel.ReportletWrapper modelObject) {
        modelObject.getConf().setName(modelObject.getName());
        ReportTO reportTO = this.restClient.read(this.report);
        if (modelObject.isNew()) {
            reportTO.getReportletConfs().add(modelObject.getConf());
        } else {
            CollectionUtils.filter((Iterable)reportTO.getReportletConfs(), (Predicate)new Predicate<AbstractReportletConf>(){

                public boolean evaluate(AbstractReportletConf object) {
                    return !object.getName().equals(modelObject.getOldName());
                }
            });
            reportTO.getReportletConfs().add(modelObject.getConf());
        }
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)modelObject.getConf());
        for (Map.Entry<String, Pair<AbstractFiqlSearchConditionBuilder, List<SearchClause>>> entry : modelObject.getSCondWrapper().entrySet()) {
            wrapper.setPropertyValue(entry.getKey(), (Object)SearchUtils.buildFIQL((List)entry.getValue().getRight(), (AbstractFiqlSearchConditionBuilder)entry.getValue().getLeft()));
        }
        this.restClient.update(reportTO);
        return modelObject;
    }

    @Override
    protected WizardModel buildModelSteps(ReportletDirectoryPanel.ReportletWrapper modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        wizardModel.add((IWizardStep)new Configuration(modelObject));
        return wizardModel;
    }

    public class Configuration
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        public Configuration(final ReportletDirectoryPanel.ReportletWrapper reportlet) {
            LoadableDetachableModel<Serializable> bean = new LoadableDetachableModel<Serializable>(){
                private static final long serialVersionUID = 2092144708018739371L;

                protected Serializable load() {
                    return reportlet.getConf();
                }
            };
            this.add(new Component[]{new BeanPanel("bean", bean, reportlet.getSCondWrapper(), new String[]{"name", "reportletClassName"}).setRenderBodyOnly(true)});
        }
    }

    public class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;

        public Profile(final ReportletDirectoryPanel.ReportletWrapper reportlet) {
            AjaxTextFieldPanel name = new AjaxTextFieldPanel("name", "reportlet", (IModel<String>)new PropertyModel((Object)reportlet, "name"), false);
            name.addRequiredLabel();
            name.setEnabled(true);
            this.add(new Component[]{name});
            AjaxDropDownChoicePanel conf = new AjaxDropDownChoicePanel("configuration", this.getString("configuration"), new PropertyModel<String>((Object)reportlet, "conf"){
                private static final long serialVersionUID = -6427731218492117883L;

                public String getObject() {
                    return reportlet.getConf() == null ? null : reportlet.getConf().getClass().getName();
                }

                public void setObject(String object) {
                    AbstractReportletConf conf = null;
                    try {
                        conf = (AbstractReportletConf)AbstractReportletConf.class.cast(Class.forName(object).newInstance());
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        LOG.warn("Error retrieving reportlet configuration instance", (Throwable)e);
                    }
                    reportlet.setConf(conf);
                }
            });
            conf.setChoices(new ArrayList(SyncopeConsoleSession.get().getPlatformInfo().getReportletConfs()));
            conf.addRequiredLabel();
            this.add(new Component[]{conf});
        }
    }
}

