/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.commons.status.StatusUtils;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.patch.AnyPatch;
import org.apache.syncope.common.lib.patch.AssociationPatch;
import org.apache.syncope.common.lib.patch.DeassociationPatch;
import org.apache.syncope.common.lib.patch.StatusPatch;
import org.apache.syncope.common.lib.to.AnyTO;
import org.apache.syncope.common.lib.to.BulkAction;
import org.apache.syncope.common.lib.to.BulkActionResult;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.types.ResourceAssociationAction;
import org.apache.syncope.common.lib.types.ResourceDeassociationAction;
import org.apache.syncope.common.rest.api.service.AnyService;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;

public abstract class AbstractAnyRestClient<TO extends AnyTO, P extends AnyPatch>
extends BaseRestClient {
    private static final long serialVersionUID = 1962529678091410544L;

    protected abstract Class<? extends AnyService<TO, P>> getAnyServiceClass();

    public abstract int searchCount(String var1, String var2, String var3);

    public abstract List<TO> search(String var1, String var2, int var3, int var4, SortParam<String> var5, String var6);

    public TO read(String key) {
        return (TO)AbstractAnyRestClient.getService(this.getAnyServiceClass()).read(key);
    }

    public ProvisioningResult<TO> create(TO to) {
        Response response = AbstractAnyRestClient.getService(this.getAnyServiceClass()).create(to);
        return (ProvisioningResult)response.readEntity(new GenericType<ProvisioningResult<TO>>(){});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisioningResult<TO> update(String etag, P patch) {
        ProvisioningResult result;
        AbstractAnyRestClient abstractAnyRestClient = this;
        synchronized (abstractAnyRestClient) {
            result = (ProvisioningResult)AbstractAnyRestClient.getService(etag, this.getAnyServiceClass()).update(patch).readEntity(new GenericType<ProvisioningResult<TO>>(){});
            AbstractAnyRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProvisioningResult<TO> delete(String etag, String key) {
        ProvisioningResult result;
        AbstractAnyRestClient abstractAnyRestClient = this;
        synchronized (abstractAnyRestClient) {
            result = (ProvisioningResult)AbstractAnyRestClient.getService(etag, this.getAnyServiceClass()).delete(key).readEntity(new GenericType<ProvisioningResult<TO>>(){});
            AbstractAnyRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult unlink(String etag, String key, List<StatusBean> statuses) {
        BulkActionResult result;
        AbstractAnyRestClient abstractAnyRestClient = this;
        synchronized (abstractAnyRestClient) {
            AnyService<TO, P> service = AbstractAnyRestClient.getService(etag, this.getAnyServiceClass());
            DeassociationPatch deassociationPatch = new DeassociationPatch.Builder().key(key).action(ResourceDeassociationAction.UNLINK).resources((Collection)StatusUtils.buildStatusPatch(statuses).getResources()).build();
            result = (BulkActionResult)service.deassociate(deassociationPatch).readEntity(BulkActionResult.class);
            AbstractAnyRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult link(String etag, String key, List<StatusBean> statuses) {
        BulkActionResult result;
        AbstractAnyRestClient abstractAnyRestClient = this;
        synchronized (abstractAnyRestClient) {
            AnyService<TO, P> service = AbstractAnyRestClient.getService(etag, this.getAnyServiceClass());
            StatusPatch statusPatch = StatusUtils.buildStatusPatch(statuses);
            AssociationPatch associationPatch = new AssociationPatch.Builder().key(key).action(ResourceAssociationAction.LINK).onSyncope(statusPatch.isOnSyncope()).resources((Collection)statusPatch.getResources()).build();
            result = (BulkActionResult)service.associate(associationPatch).readEntity(BulkActionResult.class);
            AbstractAnyRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult deprovision(String etag, String key, List<StatusBean> statuses) {
        BulkActionResult result;
        AbstractAnyRestClient abstractAnyRestClient = this;
        synchronized (abstractAnyRestClient) {
            AnyService<TO, P> service = AbstractAnyRestClient.getService(etag, this.getAnyServiceClass());
            DeassociationPatch deassociationPatch = new DeassociationPatch.Builder().key(key).action(ResourceDeassociationAction.DEPROVISION).resources((Collection)StatusUtils.buildStatusPatch(statuses).getResources()).build();
            result = (BulkActionResult)service.deassociate(deassociationPatch).readEntity(BulkActionResult.class);
            AbstractAnyRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult provision(String etag, String key, List<StatusBean> statuses) {
        BulkActionResult result;
        AbstractAnyRestClient abstractAnyRestClient = this;
        synchronized (abstractAnyRestClient) {
            AnyService<TO, P> service = AbstractAnyRestClient.getService(etag, this.getAnyServiceClass());
            StatusPatch statusPatch = StatusUtils.buildStatusPatch(statuses);
            AssociationPatch associationPatch = new AssociationPatch.Builder().key(key).action(ResourceAssociationAction.PROVISION).onSyncope(statusPatch.isOnSyncope()).resources((Collection)statusPatch.getResources()).build();
            result = (BulkActionResult)service.associate(associationPatch).readEntity(BulkActionResult.class);
            AbstractAnyRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult unassign(String etag, String key, List<StatusBean> statuses) {
        BulkActionResult result;
        AbstractAnyRestClient abstractAnyRestClient = this;
        synchronized (abstractAnyRestClient) {
            AnyService<TO, P> service = AbstractAnyRestClient.getService(etag, this.getAnyServiceClass());
            DeassociationPatch deassociationPatch = new DeassociationPatch.Builder().key(key).action(ResourceDeassociationAction.UNASSIGN).resources((Collection)StatusUtils.buildStatusPatch(statuses).getResources()).build();
            result = (BulkActionResult)service.deassociate(deassociationPatch).readEntity(BulkActionResult.class);
            AbstractAnyRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkActionResult assign(String etag, String key, List<StatusBean> statuses) {
        BulkActionResult result;
        AbstractAnyRestClient abstractAnyRestClient = this;
        synchronized (abstractAnyRestClient) {
            AnyService<TO, P> service = AbstractAnyRestClient.getService(etag, this.getAnyServiceClass());
            StatusPatch statusPatch = StatusUtils.buildStatusPatch(statuses);
            AssociationPatch associationPatch = new AssociationPatch.Builder().key(key).action(ResourceAssociationAction.ASSIGN).onSyncope(statusPatch.isOnSyncope()).resources((Collection)statusPatch.getResources()).build();
            result = (BulkActionResult)service.associate(associationPatch).readEntity(BulkActionResult.class);
            AbstractAnyRestClient.resetClient(this.getAnyServiceClass());
        }
        return result;
    }

    public BulkActionResult bulkAction(BulkAction action) {
        return (BulkActionResult)AbstractAnyRestClient.getService(this.getAnyServiceClass()).bulk(action).readEntity(BulkActionResult.class);
    }
}

