/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ConnBundleTO;
import org.apache.syncope.common.lib.to.ConnIdObjectClassTO;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.rest.api.service.ConnectorService;
import org.springframework.beans.BeanUtils;

public class ConnectorRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -6870366819966266617L;

    public List<ConnInstanceTO> getAllConnectors() {
        List connectors = Collections.emptyList();
        try {
            connectors = ConnectorRestClient.getService(ConnectorService.class).list(SyncopeConsoleSession.get().getLocale().toString());
        }
        catch (Exception e) {
            LOG.error("While reading connectors", (Throwable)e);
        }
        return connectors;
    }

    public ConnInstanceTO create(ConnInstanceTO connectorTO) {
        List<ConnConfProperty> filteredConf = this.filterProperties(connectorTO.getConf());
        connectorTO.getConf().clear();
        connectorTO.getConf().addAll(filteredConf);
        ConnectorService service = ConnectorRestClient.getService(ConnectorService.class);
        Response response = service.create(connectorTO);
        return ConnectorRestClient.getObject(service, response.getLocation(), ConnInstanceTO.class);
    }

    public List<String> getObjectClasses(String connectorKey) {
        ArrayList<String> result = new ArrayList<String>();
        ConnectorService service = ConnectorRestClient.getService(ConnectorService.class);
        ConnInstanceTO connInstance = service.read(connectorKey, SyncopeConsoleSession.get().getLocale().getLanguage());
        if (connInstance != null) {
            CollectionUtils.collect((Iterable)service.buildObjectClassInfo(connInstance, true), (Transformer)new Transformer<ConnIdObjectClassTO, String>(){

                public String transform(ConnIdObjectClassTO input) {
                    return input.getType();
                }
            }, result);
        }
        return result;
    }

    public List<String> getExtAttrNames(final String objectClass, String connectorKey, Collection<ConnConfProperty> conf) {
        ConnInstanceTO connInstanceTO = new ConnInstanceTO();
        connInstanceTO.setKey(connectorKey);
        connInstanceTO.getConf().addAll(conf);
        ConnIdObjectClassTO connIdObjectClass = (ConnIdObjectClassTO)IterableUtils.find(this.buildObjectClassInfo(connInstanceTO, false), (Predicate)new Predicate<ConnIdObjectClassTO>(){

            public boolean evaluate(ConnIdObjectClassTO object) {
                return object.getType().equalsIgnoreCase(objectClass);
            }
        });
        return connIdObjectClass == null ? new ArrayList() : connIdObjectClass.getAttributes();
    }

    public ConnInstanceTO read(String key) {
        ConnInstanceTO connectorTO = null;
        try {
            connectorTO = ConnectorRestClient.getService(ConnectorService.class).read(key, SyncopeConsoleSession.get().getLocale().toString());
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading a connector", (Throwable)e);
        }
        return connectorTO;
    }

    public void update(ConnInstanceTO connectorTO) {
        List<ConnConfProperty> filteredConf = this.filterProperties(connectorTO.getConf());
        connectorTO.getConf().clear();
        connectorTO.getConf().addAll(filteredConf);
        ConnectorRestClient.getService(ConnectorService.class).update(connectorTO);
    }

    public ConnInstanceTO delete(String key) {
        ConnInstanceTO connectorTO = ConnectorRestClient.getService(ConnectorService.class).read(key, SyncopeConsoleSession.get().getLocale().toString());
        ConnectorRestClient.getService(ConnectorService.class).delete(key);
        return connectorTO;
    }

    public List<ConnBundleTO> getAllBundles() {
        List bundles = Collections.emptyList();
        try {
            bundles = ConnectorRestClient.getService(ConnectorService.class).getBundles(SyncopeConsoleSession.get().getLocale().toString());
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting connector bundles", (Throwable)e);
        }
        return bundles;
    }

    private List<ConnConfProperty> filterProperties(Collection<ConnConfProperty> properties) {
        ArrayList<ConnConfProperty> newProperties = new ArrayList<ConnConfProperty>();
        for (ConnConfProperty property : properties) {
            ConnConfProperty prop = new ConnConfProperty();
            prop.setSchema(property.getSchema());
            prop.setOverridable(property.isOverridable());
            ArrayList parsed = new ArrayList();
            if (property.getValues() != null) {
                for (Object obj : property.getValues()) {
                    if (obj == null || obj.toString().isEmpty()) continue;
                    parsed.add(obj);
                }
            }
            prop.getValues().addAll(parsed);
            newProperties.add(prop);
        }
        return newProperties;
    }

    public Pair<Boolean, String> check(ConnInstanceTO connectorTO) {
        ConnInstanceTO toBeChecked = new ConnInstanceTO();
        BeanUtils.copyProperties((Object)connectorTO, (Object)toBeChecked, (String[])new String[]{"configuration", "configurationMap"});
        toBeChecked.getConf().addAll(this.filterProperties(connectorTO.getConf()));
        boolean check = false;
        String errorMessage = null;
        try {
            ConnectorRestClient.getService(ConnectorService.class).check(toBeChecked);
            check = true;
        }
        catch (Exception e) {
            LOG.error("While checking {}", (Object)toBeChecked, (Object)e);
            errorMessage = e.getMessage();
        }
        return Pair.of((Object)check, (Object)errorMessage);
    }

    public List<ConnIdObjectClassTO> buildObjectClassInfo(ConnInstanceTO connInstanceTO, boolean includeSpecial) {
        List result = Collections.emptyList();
        try {
            result = ConnectorRestClient.getService(ConnectorService.class).buildObjectClassInfo(connInstanceTO, includeSpecial);
        }
        catch (Exception e) {
            LOG.error("While getting supported object classes", (Throwable)e);
        }
        return result;
    }

    public void reload() {
        ConnectorRestClient.getService(ConnectorService.class).reload();
    }
}

