/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.client.console.rest.TemplateRestClient;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.to.MailTemplateTO;
import org.apache.syncope.common.lib.to.NotificationTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.syncope.common.lib.types.MailTemplateFormat;
import org.apache.syncope.common.rest.api.service.MailTemplateService;
import org.apache.syncope.common.rest.api.service.NotificationService;

public class NotificationRestClient
extends BaseRestClient
implements TemplateRestClient<MailTemplateTO, MailTemplateFormat> {
    private static final long serialVersionUID = 6328933265096511690L;

    public List<NotificationTO> list() {
        return NotificationRestClient.getService(NotificationService.class).list();
    }

    public JobTO getJob() {
        return NotificationRestClient.getService(NotificationService.class).getJob();
    }

    public void actionJob(JobAction jobAction) {
        NotificationRestClient.getService(NotificationService.class).actionJob(jobAction);
    }

    public NotificationTO read(String key) {
        return NotificationRestClient.getService(NotificationService.class).read(key);
    }

    public void create(NotificationTO notificationTO) {
        NotificationRestClient.getService(NotificationService.class).create(notificationTO);
    }

    public void update(NotificationTO notificationTO) {
        NotificationRestClient.getService(NotificationService.class).update(notificationTO);
    }

    public void delete(String key) {
        NotificationRestClient.getService(NotificationService.class).delete(key);
    }

    @Override
    public List<MailTemplateTO> listTemplates() {
        return NotificationRestClient.getService(MailTemplateService.class).list();
    }

    @Override
    public void createTemplate(MailTemplateTO mailTemplateTO) {
        NotificationRestClient.getService(MailTemplateService.class).create(mailTemplateTO);
    }

    @Override
    public void deleteTemplate(String key) {
        NotificationRestClient.getService(MailTemplateService.class).delete(key);
    }

    @Override
    public MailTemplateTO readTemplate(String key) {
        return NotificationRestClient.getService(MailTemplateService.class).read(key);
    }

    @Override
    public String readTemplateFormat(String key, MailTemplateFormat format) {
        try {
            return IOUtils.toString((InputStream)((InputStream)InputStream.class.cast(NotificationRestClient.getService(MailTemplateService.class).getFormat(key, format).getEntity())), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.error("Error retrieving mail template {} as {}", new Object[]{key, format, e});
            return "";
        }
    }

    @Override
    public void updateTemplateFormat(String key, String content, MailTemplateFormat format) {
        NotificationRestClient.getService(MailTemplateService.class).setFormat(key, format, IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8));
    }
}

