/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.policy.AbstractPolicyTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.common.rest.api.service.PolicyService;

public class PolicyRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -1392090291817187902L;

    public <T extends AbstractPolicyTO> T getPolicy(String key) {
        AbstractPolicyTO policy = null;
        try {
            policy = PolicyRestClient.getService(PolicyService.class).read(key);
        }
        catch (Exception e) {
            LOG.warn("No policy found for id {}", (Object)key, (Object)e);
        }
        return (T)policy;
    }

    public <T extends AbstractPolicyTO> List<T> getPolicies(PolicyType type) {
        ArrayList res = new ArrayList();
        try {
            res.addAll(PolicyRestClient.getService(PolicyService.class).list(type));
            Collections.sort(res, new PolicyComparator());
        }
        catch (Exception ignore) {
            LOG.debug("No policy found", (Throwable)ignore);
        }
        return res;
    }

    public <T extends AbstractPolicyTO> void createPolicy(T policy) {
        PolicyRestClient.getService(PolicyService.class).create(policy);
    }

    public <T extends AbstractPolicyTO> void updatePolicy(T policy) {
        PolicyRestClient.getService(PolicyService.class).update(policy);
    }

    public void delete(String key) {
        PolicyRestClient.getService(PolicyService.class).delete(key);
    }

    private class PolicyComparator
    implements Comparator<AbstractPolicyTO>,
    Serializable {
        private static final long serialVersionUID = -4921433085213223115L;

        private PolicyComparator() {
        }

        @Override
        public int compare(AbstractPolicyTO left, AbstractPolicyTO right) {
            return left == null ? -1 : (right == null ? 1 : left.getDescription().compareTo(right.getDescription()));
        }
    }
}

