/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.to.RoleTO;
import org.apache.syncope.common.rest.api.service.RoleService;

public class RoleRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -3161863874876938094L;

    public void delete(String key) {
        RoleRestClient.getService(RoleService.class).delete(key);
    }

    public RoleTO read(String key) {
        return RoleRestClient.getService(RoleService.class).read(key);
    }

    public void update(RoleTO roleTO) {
        RoleRestClient.getService(RoleService.class).update(roleTO);
    }

    public void create(RoleTO roleTO) {
        RoleRestClient.getService(RoleService.class).create(roleTO);
    }

    public List<RoleTO> list() {
        return RoleRestClient.getService(RoleService.class).list();
    }

    public String readConsoleLayoutInfo(String roleKey) {
        try {
            return IOUtils.toString((InputStream)((InputStream)InputStream.class.cast(RoleRestClient.getService(RoleService.class).getConsoleLayoutInfo(roleKey).getEntity())), (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.error("Error retrieving console layout info for role {}", (Object)roleKey, (Object)e);
            return "";
        }
    }

    public void setConsoleLayoutInfo(String roleKey, String content) {
        RoleRestClient.getService(RoleService.class).setConsoleLayoutInfo(roleKey, IOUtils.toInputStream((String)content, (Charset)StandardCharsets.UTF_8));
    }

    public void removeConsoleLayoutInfo(String roleKey) {
        RoleRestClient.getService(RoleService.class).removeConsoleLayoutInfo(roleKey);
    }

    public List<String> getAllAvailableEntitlements() {
        ArrayList<String> entitlements = new ArrayList<String>(RoleRestClient.getSyncopeService().platform().getEntitlements());
        Collections.sort(entitlements);
        return entitlements;
    }
}

