/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.rest;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.BaseRestClient;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.AbstractSchemaTO;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.to.DerSchemaTO;
import org.apache.syncope.common.lib.to.PlainSchemaTO;
import org.apache.syncope.common.lib.to.VirSchemaTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.SchemaType;
import org.apache.syncope.common.rest.api.beans.SchemaQuery;
import org.apache.syncope.common.rest.api.service.AnyTypeService;
import org.apache.syncope.common.rest.api.service.SchemaService;

public class SchemaRestClient
extends BaseRestClient {
    private static final long serialVersionUID = -2479730152700312373L;

    public <T extends AbstractSchemaTO> List<T> getSchemas(SchemaType schemaType, AnyTypeKind kind) {
        AnyTypeService client = SchemaRestClient.getService(AnyTypeService.class);
        ArrayList classes = new ArrayList();
        switch (kind) {
            case USER: 
            case GROUP: {
                AnyTypeTO type = client.read(kind.name());
                if (type == null) break;
                classes.addAll(type.getClasses());
                break;
            }
            default: {
                for (AnyTypeTO anyTypeTO : new AnyTypeRestClient().listAnyTypes()) {
                    if (anyTypeTO.getKind() == AnyTypeKind.USER || anyTypeTO.getKind() == AnyTypeKind.GROUP) continue;
                    classes.addAll(anyTypeTO.getClasses());
                }
            }
        }
        return this.getSchemas(schemaType, classes.toArray(new String[0]));
    }

    public <T extends AbstractSchemaTO> List<T> getSchemas(SchemaType schemaType, String typeName) {
        AnyTypeTO type = null;
        try {
            type = SchemaRestClient.getService(AnyTypeService.class).read(typeName);
        }
        catch (SyncopeClientException e) {
            LOG.error("While reading all any types", (Throwable)e);
        }
        if (type == null) {
            return this.getSchemas(schemaType, new String[0]);
        }
        return this.getSchemas(schemaType, type.getClasses().toArray(new String[0]));
    }

    public <T extends AbstractSchemaTO> List<T> getSchemas(SchemaType schemaType, String ... kind) {
        ArrayList schemas = new ArrayList();
        try {
            if (kind == null || kind.length == 0) {
                schemas.addAll(SchemaRestClient.getService(SchemaService.class).list(new SchemaQuery.Builder().type(schemaType).build()));
            } else {
                schemas.addAll(SchemaRestClient.getService(SchemaService.class).list(new SchemaQuery.Builder().type(schemaType).anyTypeClasses(kind).build()));
            }
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all {} schemas for {}", new Object[]{schemaType, kind, e});
        }
        return schemas;
    }

    public List<String> getSchemaNames(SchemaType schemaType) {
        ArrayList<String> schemaNames = new ArrayList<String>();
        try {
            CollectionUtils.collect(this.getSchemas(schemaType, new String[0]), (Transformer)EntityTOUtils.keyTransformer(), schemaNames);
        }
        catch (SyncopeClientException e) {
            LOG.error("While getting all user schema names", (Throwable)e);
        }
        return schemaNames;
    }

    public List<String> getPlainSchemaNames() {
        return this.getSchemaNames(SchemaType.PLAIN);
    }

    public List<String> getDerSchemaNames() {
        return this.getSchemaNames(SchemaType.DERIVED);
    }

    public List<String> getVirSchemaNames() {
        return this.getSchemaNames(SchemaType.VIRTUAL);
    }

    public PlainSchemaTO read(SchemaType schemaType, String key) {
        return (PlainSchemaTO)SchemaRestClient.getService(SchemaService.class).read(schemaType, key);
    }

    public void create(SchemaType schemaType, AbstractSchemaTO modelObject) {
        SchemaRestClient.getService(SchemaService.class).create(schemaType, modelObject);
    }

    public void update(SchemaType schemaType, AbstractSchemaTO modelObject) {
        SchemaRestClient.getService(SchemaService.class).update(schemaType, modelObject);
    }

    public PlainSchemaTO deletePlainSchema(String name) {
        PlainSchemaTO response = (PlainSchemaTO)SchemaRestClient.getService(SchemaService.class).read(SchemaType.PLAIN, name);
        SchemaRestClient.getService(SchemaService.class).delete(SchemaType.PLAIN, name);
        return response;
    }

    public DerSchemaTO deleteDerSchema(String name) {
        DerSchemaTO schemaTO = (DerSchemaTO)SchemaRestClient.getService(SchemaService.class).read(SchemaType.DERIVED, name);
        SchemaRestClient.getService(SchemaService.class).delete(SchemaType.DERIVED, name);
        return schemaTO;
    }

    public VirSchemaTO deleteVirSchema(String name) {
        VirSchemaTO schemaTO = (VirSchemaTO)SchemaRestClient.getService(SchemaService.class).read(SchemaType.VIRTUAL, name);
        SchemaRestClient.getService(SchemaService.class).delete(SchemaType.VIRTUAL, name);
        return schemaTO;
    }
}

