/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.status;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SerializableTransformer;
import org.apache.syncope.client.console.commons.status.StatusBean;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.AbstractAnyRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.status.ResourceStatusDirectoryPanel;
import org.apache.syncope.client.console.status.StatusModal;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class ResourceStatusModal
extends StatusModal<ResourceTO> {
    private static final long serialVersionUID = 1066124171682570080L;
    private Model<String> typeModel = new Model();

    public ResourceStatusModal(BaseModal<?> baseModal, PageReference pageReference, ResourceTO resource) {
        super(baseModal, pageReference, resource, null, false);
        List availableAnyTypes = (List)CollectionUtils.collect((Iterable)resource.getProvisions(), (Transformer)new SerializableTransformer<ProvisionTO, String>(){

            public String transform(ProvisionTO provision) {
                return provision.getAnyType();
            }
        }, new ArrayList());
        Collections.sort(availableAnyTypes, new AnyTypeRestClient.AnyTypeKeyComparator());
        AjaxDropDownChoicePanel<String> anyTypes = new AjaxDropDownChoicePanel<String>("anyTypes", "anyTypes", (IModel<String>)this.typeModel, false);
        anyTypes.setChoices(availableAnyTypes);
        anyTypes.hideLabel();
        this.add(new Component[]{anyTypes});
        anyTypes.getField().add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = -1107858522700306810L;

            protected void onUpdate(AjaxRequestTarget target) {
                ((ResourceStatusDirectoryPanel)ResourceStatusDirectoryPanel.class.cast((Object)ResourceStatusModal.this.directoryPanel)).updateResultTable((String)((Object)ResourceStatusModal.this.typeModel.getObject()), target);
            }
        }});
    }

    @Override
    protected DirectoryPanel<StatusBean, StatusBean, DirectoryDataProvider<StatusBean>, AbstractAnyRestClient<?, ?>> getStatusDirectoryPanel(MultilevelPanel mlp, BaseModal<?> baseModal, PageReference pageReference, ResourceTO entity, String itemKeyFieldName, boolean statusOnly) {
        return new ResourceStatusDirectoryPanel(baseModal, mlp, pageReference, null, entity);
    }
}

