/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.tasks;

import org.apache.syncope.client.console.commons.DirectoryDataProvider;
import org.apache.syncope.client.console.commons.SortableDataProviderComparator;
import org.apache.syncope.client.console.commons.TaskDataProvider;
import org.apache.syncope.client.console.panels.AjaxDataTablePanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.panels.ModalPanel;
import org.apache.syncope.client.console.panels.MultilevelPanel;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.to.AbstractTaskTO;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;

public abstract class TaskDirectoryPanel<T extends AbstractTaskTO>
extends DirectoryPanel<T, T, TaskDataProvider<T>, TaskRestClient>
implements ModalPanel {
    private static final long serialVersionUID = 4984337552918213290L;
    protected final BaseModal<?> baseModal;
    private final MultilevelPanel multiLevelPanelRef;

    protected TaskDirectoryPanel(BaseModal<?> baseModal, MultilevelPanel multiLevelPanelRef, PageReference pageRef) {
        super("first", pageRef, false);
        this.baseModal = baseModal;
        this.multiLevelPanelRef = multiLevelPanelRef;
        this.restClient = new TaskRestClient();
        this.setShowResultPage(false);
    }

    @Override
    protected void resultTableCustomChanges(AjaxDataTablePanel.Builder<T, String> resultTableBuilder) {
        resultTableBuilder.setMultiLevelPanel(this.baseModal, this.multiLevelPanelRef);
    }

    protected abstract void viewTask(T var1, AjaxRequestTarget var2);

    @Override
    public void onEvent(IEvent<?> event) {
        super.onEvent(event);
        if (event.getPayload() instanceof WizardMgtPanel.ExitEvent && this.modal != null) {
            AjaxRequestTarget target = ((WizardMgtPanel.ExitEvent)WizardMgtPanel.ExitEvent.class.cast(event.getPayload())).getTarget();
            this.baseModal.show(false);
            this.baseModal.close((IPartialPageRequestHandler)target);
        }
    }

    protected abstract class TasksProvider<T extends AbstractTaskTO>
    extends DirectoryDataProvider<T> {
        private static final long serialVersionUID = -20112718133295756L;
        private final SortableDataProviderComparator<T> comparator;
        private final TaskType id;

        public TasksProvider(int paginatorRows, TaskType id) {
            super(paginatorRows);
            this.setSort("key", SortOrder.ASCENDING);
            this.comparator = new SortableDataProviderComparator(this);
            this.id = id;
        }

        public SortableDataProviderComparator<T> getComparator() {
            return this.comparator;
        }

        public long size() {
            return ((TaskRestClient)TaskDirectoryPanel.this.restClient).count(this.id);
        }

        public IModel<T> model(T object) {
            return new CompoundPropertyModel(object);
        }
    }
}

