/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.topology;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.client.console.topology.TopologyTogglePanel;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;

public class TopologyNodePanel
extends Panel
implements IAjaxIndicatorAware {
    private static final long serialVersionUID = -8775095410207013913L;
    private final Label label;
    private final TopologyNode node;

    public TopologyNodePanel(String id, TopologyNode node) {
        super(id);
        String title;
        this.node = node;
        String resourceName = node.getDisplayName().length() > 14 ? node.getDisplayName().subSequence(0, 10) + "..." : node.getDisplayName();
        this.label = new Label("label", (Serializable)((Object)resourceName));
        this.label.setOutputMarkupId(true);
        this.add(new Component[]{this.label});
        switch (node.getKind()) {
            case SYNCOPE: {
                title = "";
                this.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"topology_root"), " ")});
                break;
            }
            case CONNECTOR_SERVER: {
                title = node.getDisplayName();
                this.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"topology_cs"), " ")});
                break;
            }
            case FS_PATH: {
                title = node.getDisplayName();
                this.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"topology_cs"), " ")});
                break;
            }
            case CONNECTOR: {
                title = (StringUtils.isBlank((CharSequence)node.getConnectionDisplayName()) ? "" : node.getConnectionDisplayName() + ":") + node.getDisplayName();
                this.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"topology_conn"), " ")});
                break;
            }
            default: {
                title = node.getDisplayName().length() > 14 ? node.getDisplayName() : "";
                this.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"topology_res"), " ")});
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)title)) {
            this.add(new Behavior[]{AttributeModifier.append((String)"data-original-title", (Serializable)((Object)title))});
        }
        this.setMarkupId(node.getDisplayName());
    }

    public final MarkupContainer add(Component ... childs) {
        return super.add(childs);
    }

    public final Component add(Behavior ... behaviors) {
        return super.add(behaviors);
    }

    public final Component setMarkupId(String markupId) {
        return super.setMarkupId(markupId);
    }

    public String getAjaxIndicatorMarkupId() {
        return "veil";
    }

    public void onEvent(IEvent<?> event) {
        if (event.getPayload() instanceof TopologyTogglePanel.UpdateEvent) {
            TopologyTogglePanel.UpdateEvent updateEvent = (TopologyTogglePanel.UpdateEvent)TopologyTogglePanel.UpdateEvent.class.cast(event.getPayload());
            String key = updateEvent.getKey();
            AjaxRequestTarget target = updateEvent.getTarget();
            if (this.node.getKind() == TopologyNode.Kind.CONNECTOR && key.equalsIgnoreCase(this.node.getKey())) {
                String displayName = new ConnectorRestClient().read(key).getDisplayName();
                String resourceName = displayName.length() > 14 ? displayName.subSequence(0, 10) + "..." : displayName;
                this.label.setDefaultModelObject((Object)resourceName);
                target.add(new Component[]{this.label});
            }
        }
    }

    protected static enum Status {
        ACTIVE,
        INACTIVE;

    }
}

