/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.topology;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.topology.Topology;
import org.apache.syncope.client.console.topology.TopologyNode;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.protocol.ws.api.WebSocketBehavior;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.message.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyWebSocketBehavior
extends WebSocketBehavior {
    private static final long serialVersionUID = -1653665542635275551L;
    private static final Logger LOG = LoggerFactory.getLogger(TopologyWebSocketBehavior.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final Map<String, String> resources = new HashMap<String, String>();
    private final Set<String> runningResCheck = new HashSet<String>();
    private final Map<String, String> connectors = new HashMap<String, String>();
    private final Set<String> runningConnCheck = new HashSet<String>();
    private final ConnectorRestClient connectorRestClient = new ConnectorRestClient();
    private final ResourceRestClient resourceRestClient = new ResourceRestClient();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMessage(WebSocketRequestHandler handler, TextMessage message) {
        try {
            JsonNode obj = OBJECT_MAPPER.readTree(message.getText());
            switch (Topology.SupportedOperation.valueOf(obj.get("kind").asText())) {
                case CHECK_CONNECTOR: {
                    String ckey = obj.get("target").asText();
                    if (this.connectors.containsKey(ckey)) {
                        handler.push((CharSequence)this.connectors.get(ckey));
                    } else {
                        handler.push((CharSequence)String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.UNKNOWN, ckey}));
                    }
                    Set<String> set = this.runningConnCheck;
                    synchronized (set) {
                        if (this.runningConnCheck.contains(ckey)) {
                            LOG.debug("Running connection check for connector {}", (Object)ckey);
                        } else {
                            this.runningConnCheck.add(ckey);
                        }
                    }
                    SyncopeConsoleSession.get().execute(new ConnCheck(ckey));
                    break;
                }
                case CHECK_RESOURCE: {
                    String rkey = obj.get("target").asText();
                    if (this.resources.containsKey(rkey)) {
                        handler.push((CharSequence)this.resources.get(rkey));
                    } else {
                        handler.push((CharSequence)String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.UNKNOWN, rkey}));
                    }
                    Set<String> set = this.runningResCheck;
                    synchronized (set) {
                        if (this.runningResCheck.contains(rkey)) {
                            LOG.debug("Running connection check for resource {}", (Object)rkey);
                        } else {
                            this.runningResCheck.add(rkey);
                        }
                    }
                    SyncopeConsoleSession.get().execute(new ResCheck(rkey));
                    break;
                }
                case ADD_ENDPOINT: {
                    handler.appendJavaScript((CharSequence)String.format("addEndpoint('%s', '%s', '%s');", obj.get("source").asText(), obj.get("target").asText(), obj.get("scope").asText()));
                    break;
                }
            }
        }
        catch (IOException e) {
            LOG.error("Eror managing websocket message", (Throwable)e);
        }
    }

    class ResCheck
    implements Runnable {
        private final String key;
        private final Application application;
        private final Session session;

        ResCheck(String key) {
            this.key = key;
            this.application = Application.get();
            this.session = Session.exists() ? Session.get() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String res;
                ThreadContext.setApplication((Application)this.application);
                ThreadContext.setSession((Session)this.session);
                try {
                    ResourceTO resource = TopologyWebSocketBehavior.this.resourceRestClient.read(this.key);
                    res = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{(Boolean)TopologyWebSocketBehavior.this.resourceRestClient.check(resource).getLeft() != false ? TopologyNode.Status.REACHABLE : TopologyNode.Status.UNREACHABLE, this.key});
                }
                catch (Exception e) {
                    LOG.warn("Error checking connection for {}", (Object)this.key, (Object)e);
                    res = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.FAILURE, this.key});
                }
                Set set = TopologyWebSocketBehavior.this.runningResCheck;
                synchronized (set) {
                    TopologyWebSocketBehavior.this.resources.put(this.key, res);
                    TopologyWebSocketBehavior.this.runningResCheck.remove(this.key);
                }
            }
            finally {
                ThreadContext.detach();
            }
        }
    }

    class ConnCheck
    implements Runnable {
        private final String key;
        private final Application application;
        private final Session session;

        ConnCheck(String key) {
            this.key = key;
            this.application = Application.get();
            this.session = Session.exists() ? Session.get() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String res;
                ThreadContext.setApplication((Application)this.application);
                ThreadContext.setSession((Session)this.session);
                try {
                    ConnInstanceTO connector = TopologyWebSocketBehavior.this.connectorRestClient.read(this.key);
                    res = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{(Boolean)TopologyWebSocketBehavior.this.connectorRestClient.check(connector).getLeft() != false ? TopologyNode.Status.REACHABLE : TopologyNode.Status.UNREACHABLE, this.key});
                }
                catch (Exception e) {
                    LOG.warn("Error checking connection for {}", (Object)this.key, (Object)e);
                    res = String.format("{ \"status\": \"%s\", \"target\": \"%s\"}", new Object[]{TopologyNode.Status.FAILURE, this.key});
                }
                Set set = TopologyWebSocketBehavior.this.runningConnCheck;
                synchronized (set) {
                    TopologyWebSocketBehavior.this.connectors.put(this.key, res);
                    TopologyWebSocketBehavior.this.runningConnCheck.remove(this.key);
                }
            }
            finally {
                ThreadContext.detach();
            }
        }
    }
}

