/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.ajax.form;

import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AbstractAjaxBehavior;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.util.resource.IResourceStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAjaxDownloadBehavior
extends AbstractAjaxBehavior {
    private static final long serialVersionUID = 6833760760338614245L;
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractAjaxDownloadBehavior.class);

    public void initiate(AjaxRequestTarget target) {
        CharSequence url = this.getCallbackUrl();
        target.appendJavaScript((CharSequence)("window.location.href='" + url + "'"));
    }

    public void onRequest() {
        try {
            this.getComponent().getRequestCycle().scheduleRequestHandlerAfterCurrent((IRequestHandler)new ResourceStreamRequestHandler(this.getResourceStream(), this.getFileName()));
        }
        catch (Exception e) {
            LOG.error("Error downloading file", (Throwable)e);
        }
    }

    protected abstract String getFileName();

    protected abstract IResourceStream getResourceStream();
}

