/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.wicket.markup.html.form.AbstractFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPaletteConf;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.NonI18nPalette;
import org.apache.syncope.client.console.wicket.markup.html.form.SelectChoiceRenderer;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.extensions.markup.html.form.palette.Palette;
import org.apache.wicket.extensions.markup.html.form.palette.component.Recorder;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.util.string.Strings;

public class AjaxPalettePanel<T extends Serializable>
extends AbstractFieldPanel<List<T>> {
    private static final long serialVersionUID = 7738499668258805567L;
    protected Palette<T> palette;
    private final Model<String> queryFilter = new Model((Serializable)((Object)""));
    private final List<T> availableBefore = new ArrayList<T>();
    private final LoadableDetachableModel<List<T>> choicesModel;

    public AjaxPalettePanel(String id, IModel<List<T>> model, final Builder.Query<T> choices, Builder<T> builder) {
        super(id, ((Builder)builder).name == null ? id : ((Builder)builder).name, model);
        this.choicesModel = new PaletteLoadableDetachableModel(builder){
            private static final long serialVersionUID = -108100712154481840L;

            @Override
            protected List<T> getChoices() {
                return choices.execute(this.getFilter());
            }
        };
        this.initialize(model, builder);
    }

    public AjaxPalettePanel(String id, IModel<List<T>> model, final IModel<List<T>> choices, final Builder<T> builder) {
        super(id, ((Builder)builder).name == null ? id : ((Builder)builder).name, model);
        this.choicesModel = new PaletteLoadableDetachableModel(builder){
            private static final long serialVersionUID = -108100712154481840L;

            @Override
            protected List<T> getChoices() {
                return builder.filtered ? this.getFilteredList((Collection)choices.getObject(), this.getFilter().replaceAll("\\*", "\\.\\*")) : (List)choices.getObject();
            }
        };
        this.initialize(model, builder);
    }

    private void initialize(IModel<List<T>> model, final Builder<T> builder) {
        this.setOutputMarkupId(true);
        this.palette = new NonI18nPalette<T>("paletteField", (IModel)model, (IModel)this.choicesModel, ((Builder)builder).renderer, 8, ((Builder)builder).allowOrder, ((Builder)builder).allowMoveAll){
            private static final long serialVersionUID = -3074655279011678437L;

            @Override
            protected Component newAvailableHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("palette.available", builder.availableLabel));
            }

            @Override
            protected Component newSelectedHeader(String componentId) {
                return new Label(componentId, (IModel)new ResourceModel("palette.selected", builder.selectedLabel));
            }

            protected Recorder<T> newRecorderComponent() {
                return new Recorder<T>("recorder", this){
                    private static final long serialVersionUID = -9169109967480083523L;

                    public List<T> getUnselectedList() {
                        IChoiceRenderer renderer = this.getPalette().getChoiceRenderer();
                        Collection choices = this.getPalette().getChoices();
                        ArrayList<Serializable> unselected = new ArrayList<Serializable>(choices.size());
                        List<String> ids = Arrays.asList(this.getValue().split(","));
                        for (Serializable choice : choices) {
                            String choiceId = renderer.getIdValue((Object)choice, 0);
                            if (ids.contains(choiceId)) continue;
                            unselected.add(choice);
                        }
                        return unselected;
                    }

                    public List<T> getSelectedList() {
                        IChoiceRenderer renderer = this.getPalette().getChoiceRenderer();
                        Collection choices = this.getPalette().getChoices();
                        ArrayList<Serializable> selected = new ArrayList<Serializable>(choices.size());
                        HashMap<Serializable, String> idForChoice = new HashMap<Serializable, String>(choices.size());
                        for (Serializable choice : choices) {
                            idForChoice.put(choice, renderer.getIdValue((Object)choice, 0));
                        }
                        String value = this.getValue();
                        int start = value.indexOf(59) + 1;
                        block1: for (String id : Strings.split((String)value.substring(start), (char)',')) {
                            for (Serializable choice : choices) {
                                String idValue = (String)idForChoice.get(choice);
                                if (!id.equals(idValue)) continue;
                                selected.add(choice);
                                continue block1;
                            }
                        }
                        return selected;
                    }
                };
            }
        };
        this.add(new Component[]{this.palette.setOutputMarkupId(true)});
        Form form = new Form("form");
        this.add(new Component[]{form.setEnabled(((Builder)builder).filtered).setVisible(((Builder)builder).filtered)});
        AjaxTextFieldPanel filter = new AjaxTextFieldPanel("filter", "filter", (IModel<String>)this.queryFilter, false);
        filter.hideLabel().setOutputMarkupId(true);
        form.add(new Component[]{filter});
        form.add(new Component[]{new AjaxSubmitLink("search"){
            private static final long serialVersionUID = -1765773642975892072L;

            protected void onAfterSubmit(AjaxRequestTarget target, Form<?> form) {
                super.onAfterSubmit(target, form);
                target.add(new Component[]{AjaxPalettePanel.this.palette});
            }
        }});
    }

    public LoadableDetachableModel<List<T>> getChoicesModel() {
        return this.choicesModel;
    }

    @Override
    public AjaxPalettePanel<T> setModelObject(List<T> object) {
        this.palette.setDefaultModelObject(object);
        return this;
    }

    public Collection<T> getModelCollection() {
        return this.palette.getModelCollection();
    }

    public void reload(AjaxRequestTarget target) {
        target.add(new Component[]{this.palette});
    }

    private abstract class PaletteLoadableDetachableModel
    extends LoadableDetachableModel<List<T>> {
        private static final long serialVersionUID = -7745220313769774616L;
        private final Builder<T> builder;

        PaletteLoadableDetachableModel(Builder<T> builder) {
            this.builder = builder;
        }

        protected abstract List<T> getChoices();

        protected String getFilter() {
            return StringUtils.isBlank((CharSequence)((CharSequence)((Object)AjaxPalettePanel.this.queryFilter.getObject()))) ? this.builder.filter : (String)((Object)AjaxPalettePanel.this.queryFilter.getObject());
        }

        protected List<T> load() {
            ArrayList selected = AjaxPalettePanel.this.availableBefore.isEmpty() ? new ArrayList(AjaxPalettePanel.this.palette.getModelCollection()) : this.getSelectedList(AjaxPalettePanel.this.availableBefore, AjaxPalettePanel.this.palette.getRecorderComponent().getValue());
            AjaxPalettePanel.this.availableBefore.clear();
            AjaxPalettePanel.this.availableBefore.addAll(ListUtils.sum(selected, this.getChoices()));
            return AjaxPalettePanel.this.availableBefore;
        }

        private List<T> getSelectedList(Collection<T> choices, String selection) {
            IChoiceRenderer renderer = AjaxPalettePanel.this.palette.getChoiceRenderer();
            ArrayList<Serializable> selected = new ArrayList<Serializable>();
            HashMap<Serializable, String> idForChoice = new HashMap<Serializable, String>();
            for (Serializable choice : choices) {
                idForChoice.put(choice, renderer.getIdValue((Object)choice, 0));
            }
            for (String id : Strings.split((String)selection, (char)',')) {
                Iterator iter = choices.iterator();
                boolean found = false;
                while (!found && iter.hasNext()) {
                    Serializable choice = (Serializable)iter.next();
                    String idValue = (String)idForChoice.get(choice);
                    if (!id.equals(idValue)) continue;
                    selected.add(choice);
                    found = true;
                }
            }
            return selected;
        }

        protected List<T> getFilteredList(Collection<T> choices, String filter) {
            IChoiceRenderer renderer = AjaxPalettePanel.this.palette.getChoiceRenderer();
            ArrayList<Serializable> selected = new ArrayList<Serializable>(choices.size());
            HashMap<Serializable, String> idForChoice = new HashMap<Serializable, String>();
            for (Serializable choice : choices) {
                idForChoice.put(choice, renderer.getIdValue((Object)choice, 0));
            }
            Pattern pattern = Pattern.compile(filter, 2);
            for (Serializable choice : choices) {
                String idValue = (String)idForChoice.get(choice);
                if (!pattern.matcher(idValue).matches()) continue;
                selected.add(choice);
            }
            return selected;
        }
    }

    public static class Builder<T extends Serializable>
    implements Serializable {
        private static final long serialVersionUID = 991248996001040352L;
        private IChoiceRenderer<T> renderer;
        private boolean allowOrder = false;
        private boolean allowMoveAll = false;
        private String selectedLabel;
        private String availableLabel;
        private boolean filtered = false;
        private final AjaxPaletteConf conf = new AjaxPaletteConf();
        private String filter = this.conf.getDefaultFilter();
        private String name;

        public Builder() {
            this.renderer = new SelectChoiceRenderer();
        }

        public Builder<T> setName(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> setAllowOrder(boolean allowOrder) {
            this.allowOrder = allowOrder;
            return this;
        }

        public Builder<T> setAllowMoveAll(boolean allowMoveAll) {
            this.allowMoveAll = allowMoveAll;
            return this;
        }

        public Builder<T> setSelectedLabel(String selectedLabel) {
            this.selectedLabel = selectedLabel;
            return this;
        }

        public Builder<T> setAvailableLabel(String availableLabel) {
            this.availableLabel = availableLabel;
            return this;
        }

        public Builder<T> setRenderer(IChoiceRenderer<T> renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder<T> withFilter() {
            this.filtered = true;
            return this;
        }

        public Builder<T> withFilter(String defaultFilter) {
            this.filtered = true;
            this.filter = defaultFilter;
            return this;
        }

        public AjaxPalettePanel<T> build(String id, IModel<List<T>> model, IModel<List<T>> choices) {
            return new AjaxPalettePanel<T>(id, model, choices, this);
        }

        public AjaxPalettePanel<T> build(String id, IModel<List<T>> model, Query<T> choices) {
            return new AjaxPalettePanel<T>(id, model, choices, this);
        }

        public static abstract class Query<T extends Serializable>
        implements Serializable {
            private static final long serialVersionUID = 3582312993557742858L;

            public abstract List<T> execute(String var1);
        }
    }
}

