/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form.preview;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.syncope.client.console.annotations.BinaryPreview;
import org.apache.syncope.client.console.wicket.markup.html.form.preview.AbstractBinaryPreviewer;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.io.IOUtils;

@BinaryPreview(mimeTypes={"application/x-x509-ca-cert", "application/x-x509-user-cert", "application/pkix-cert"})
public class BinaryCertPreviewer
extends AbstractBinaryPreviewer {
    private static final long serialVersionUID = -5843835939538055110L;

    public BinaryCertPreviewer(String id, String mimeType) {
        super(id, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component preview(byte[] uploadedBytes) {
        Label commonNameLabel = new Label("certCommonName", (IModel)new Model());
        if (uploadedBytes.length == 0) {
            LOG.info("Enpty certificate");
            return commonNameLabel;
        }
        ByteArrayInputStream certificateStream = new ByteArrayInputStream(uploadedBytes);
        try {
            X509Certificate certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(certificateStream);
            StringBuilder commonNameBuilder = new StringBuilder("cn=");
            LdapName ldapName = new LdapName(certificate.getIssuerDN().getName());
            for (Rdn rdn : ldapName.getRdns()) {
                if (!"CN".equalsIgnoreCase(rdn.getType())) continue;
                commonNameBuilder.append(rdn.getValue() == null ? "" : rdn.getValue().toString());
            }
            commonNameLabel.setDefaultModelObject((Object)commonNameBuilder.toString());
        }
        catch (CertificateException | InvalidNameException e) {
            LOG.error("Error evaluating certificate file", (Throwable)e);
            commonNameLabel.setDefaultModelObject((Object)this.getString("error"));
        }
        finally {
            IOUtils.closeQuietly((Closeable)certificateStream);
        }
        return this.addOrReplace(new Component[]{commonNameLabel});
    }
}

