/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.markup.html.form.preview;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.pdmodel.DefaultResourceCache;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.syncope.client.console.annotations.BinaryPreview;
import org.apache.syncope.client.console.wicket.markup.html.form.preview.AbstractBinaryPreviewer;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.request.resource.DynamicImageResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.time.Time;

@BinaryPreview(mimeTypes={"application/pdf"})
public class BinaryPDFPreviewer
extends AbstractBinaryPreviewer {
    private static final long serialVersionUID = -6606409541566687016L;
    private static final int IMG_SIZE = 300;
    private static final float DPI = 100.0f;
    private static final ImageType IMAGE_TYPE = ImageType.RGB;
    private transient BufferedImage firstPage;

    public BinaryPDFPreviewer(String id, String mimeType) {
        super(id, mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Component preview(byte[] uploadedBytes) {
        Fragment fragment;
        PDDocument document;
        block7: {
            this.firstPage = null;
            document = null;
            try {
                document = PDDocument.load((InputStream)new ByteArrayInputStream(uploadedBytes), (MemoryUsageSetting)MemoryUsageSetting.setupTempFileOnly());
                document.setResourceCache((ResourceCache)new DefaultResourceCache(){

                    public void put(COSObject indirect, PDXObject xobject) throws IOException {
                    }
                });
                if (document.isEncrypted()) {
                    LOG.info("Document is encrypted, no preview is possible");
                    break block7;
                }
                this.firstPage = new PDFRenderer(document).renderImageWithDPI(0, 100.0f, IMAGE_TYPE);
            }
            catch (IOException e) {
                try {
                    LOG.error("While generating thumbnail from first page", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(document);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)document);
            }
        }
        IOUtils.closeQuietly((Closeable)document);
        if (this.firstPage == null) {
            fragment = new Fragment("preview", "noPreviewFragment", (MarkupContainer)this);
        } else {
            fragment = new Fragment("preview", "previewFragment", (MarkupContainer)this);
            fragment.add(new Component[]{new NonCachingImage("previewImage", (IResource)new ThumbnailImageResource(this.firstPage))});
        }
        WebMarkupContainer previewContainer = new WebMarkupContainer("previewContainer");
        previewContainer.setOutputMarkupId(true);
        previewContainer.add(new Component[]{fragment});
        return this.addOrReplace(new Component[]{previewContainer});
    }

    private static class ThumbnailImageResource
    extends DynamicImageResource
    implements Serializable {
        private static final long serialVersionUID = 923201517955737928L;
        private final transient BufferedImage image;
        private transient byte[] thumbnail;

        ThumbnailImageResource(BufferedImage image) {
            this.image = image;
        }

        protected byte[] getImageData(IResource.Attributes attributes) {
            if (this.thumbnail == null) {
                this.thumbnail = this.toImageData(this.getScaledImageInstance());
                this.setLastModifiedTime(Time.now());
            }
            return this.thumbnail;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BufferedImage getScaledImageInstance() {
            int originalWidth = this.image.getWidth();
            int originalHeight = this.image.getHeight();
            if (originalWidth > 300 || originalHeight > 300) {
                int newHeight;
                int newWidth;
                if (originalWidth > originalHeight) {
                    newWidth = 300;
                    newHeight = 300 * originalHeight / originalWidth;
                } else {
                    newWidth = 300 * originalWidth / originalHeight;
                    newHeight = 300;
                }
                BufferedImage dimg = new BufferedImage(newWidth, newHeight, this.image.getType());
                Graphics2D g = dimg.createGraphics();
                try {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g.drawImage(this.image, 0, 0, newWidth, newHeight, 0, 0, originalWidth, originalHeight, null);
                }
                finally {
                    g.dispose();
                }
                return dimg;
            }
            return this.image;
        }
    }
}

