/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import com.pingunaut.wicket.chartjs.chart.impl.Doughnut;
import com.pingunaut.wicket.chartjs.core.panel.DoughnutChartPanel;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.pages.Administration;
import org.apache.syncope.client.console.pages.Notifications;
import org.apache.syncope.client.console.pages.Policies;
import org.apache.syncope.client.console.pages.SecurityQuestions;
import org.apache.syncope.client.console.pages.Types;
import org.apache.syncope.client.console.topology.Topology;
import org.apache.syncope.client.console.widgets.BaseWidget;
import org.apache.syncope.client.console.widgets.LabeledDoughnutChartData;
import org.apache.syncope.common.lib.info.NumbersInfo;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class CompletenessWidget
extends BaseWidget {
    private static final long serialVersionUID = 7667120094526529934L;
    private Map<String, Boolean> confCompleteness;
    private final DoughnutChartPanel chart;
    private final WebMarkupContainer actions;
    private final BookmarkablePageLink<Page> topology;
    private final BookmarkablePageLink<Page> policies;
    private final BookmarkablePageLink<Page> notifications;
    private final BookmarkablePageLink<Page> types;
    private final BookmarkablePageLink<Page> securityquestions;
    private final BookmarkablePageLink<Page> roles;

    public CompletenessWidget(String id, Map<String, Boolean> confCompleteness) {
        super(id);
        this.confCompleteness = confCompleteness;
        this.setOutputMarkupId(true);
        Pair<Doughnut, Integer> built = this.build(confCompleteness);
        this.chart = new DoughnutChartPanel("chart", (IModel)Model.of((Serializable)((Serializable)built.getLeft())));
        this.add(new Component[]{this.chart});
        this.actions = new WebMarkupContainer("actions");
        this.actions.setOutputMarkupPlaceholderTag(true);
        this.actions.setVisible((Integer)built.getRight() > 0);
        this.add(new Component[]{this.actions});
        this.topology = BookmarkablePageLinkBuilder.build("topology", Topology.class);
        this.topology.setOutputMarkupPlaceholderTag(true);
        this.actions.add(new Component[]{this.topology});
        MetaDataRoleAuthorizationStrategy.authorize(this.topology, (Action)WebPage.ENABLE, (String)String.format("%s,%s", "CONNECTOR_LIST", "RESOURCE_LIST"));
        this.topology.setVisible(confCompleteness.get(NumbersInfo.ConfItem.RESOURCE.name()) == false || confCompleteness.get(NumbersInfo.ConfItem.PULL_TASK.name()) == false);
        this.policies = BookmarkablePageLinkBuilder.build("policies", Policies.class);
        this.policies.setOutputMarkupPlaceholderTag(true);
        MetaDataRoleAuthorizationStrategy.authorize(this.policies, (Action)WebPage.ENABLE, (String)"POLICY_LIST");
        this.actions.add(new Component[]{this.policies});
        this.policies.setVisible(confCompleteness.get(NumbersInfo.ConfItem.ACCOUNT_POLICY.name()) == false || confCompleteness.get(NumbersInfo.ConfItem.PASSWORD_POLICY.name()) == false);
        this.notifications = BookmarkablePageLinkBuilder.build("notifications", Notifications.class);
        this.notifications.setOutputMarkupPlaceholderTag(true);
        MetaDataRoleAuthorizationStrategy.authorize(this.notifications, (Action)WebPage.ENABLE, (String)"NOTIFICATION_LIST");
        this.actions.add(new Component[]{this.notifications});
        this.notifications.setVisible(confCompleteness.get(NumbersInfo.ConfItem.NOTIFICATION.name()) == false);
        this.types = BookmarkablePageLinkBuilder.build("types", Types.class);
        this.types.setOutputMarkupPlaceholderTag(true);
        MetaDataRoleAuthorizationStrategy.authorize(this.types, (Action)WebPage.ENABLE, (String)"SCHEMA_LIST");
        this.actions.add(new Component[]{this.types});
        this.types.setVisible(confCompleteness.get(NumbersInfo.ConfItem.VIR_SCHEMA.name()) == false || confCompleteness.get(NumbersInfo.ConfItem.ANY_TYPE.name()) == false);
        this.securityquestions = BookmarkablePageLinkBuilder.build("securityquestions", SecurityQuestions.class);
        this.securityquestions.setOutputMarkupPlaceholderTag(true);
        this.actions.add(new Component[]{this.securityquestions});
        this.securityquestions.setVisible(confCompleteness.get(NumbersInfo.ConfItem.SECURITY_QUESTION.name()) == false);
        this.roles = BookmarkablePageLinkBuilder.build("roles", Administration.class);
        this.roles.setOutputMarkupPlaceholderTag(true);
        MetaDataRoleAuthorizationStrategy.authorize(this.roles, (Action)WebPage.ENABLE, (String)"ROLE_LIST");
        this.actions.add(new Component[]{this.roles});
        this.roles.setVisible(confCompleteness.get(NumbersInfo.ConfItem.ROLE.name()) == false);
    }

    private Pair<Doughnut, Integer> build(Map<String, Boolean> confCompleteness) {
        Doughnut doughnut = new Doughnut();
        doughnut.getOptions().setResponsive(true);
        doughnut.getOptions().setMaintainAspectRatio(Boolean.valueOf(true));
        doughnut.getOptions().setTooltipTemplate("<%= label %>");
        int done = 0;
        int todo = 0;
        for (Map.Entry<String, Boolean> entry : confCompleteness.entrySet()) {
            if (BooleanUtils.isTrue((Boolean)entry.getValue())) {
                done += NumbersInfo.ConfItem.getScore((String)entry.getKey());
                continue;
            }
            ++todo;
        }
        doughnut.getData().add(new LabeledDoughnutChartData(done, "blue", this.getString("done")));
        doughnut.getData().add(new LabeledDoughnutChartData(100 - done, "red", this.getString("todo") + ": " + todo));
        return Pair.of((Object)doughnut, (Object)todo);
    }

    public boolean refresh(Map<String, Boolean> confCompleteness) {
        if (!this.confCompleteness.equals(confCompleteness)) {
            this.confCompleteness = confCompleteness;
            Pair<Doughnut, Integer> built = this.build(confCompleteness);
            this.chart.setDefaultModelObject(built.getLeft());
            this.actions.setVisible((Integer)built.getRight() > 0);
            this.topology.setVisible(confCompleteness.get(NumbersInfo.ConfItem.RESOURCE.name()) == false || confCompleteness.get(NumbersInfo.ConfItem.PULL_TASK.name()) == false);
            this.policies.setVisible(confCompleteness.get(NumbersInfo.ConfItem.ACCOUNT_POLICY.name()) == false || confCompleteness.get(NumbersInfo.ConfItem.PASSWORD_POLICY.name()) == false);
            this.notifications.setVisible(confCompleteness.get(NumbersInfo.ConfItem.NOTIFICATION.name()) == false);
            this.types.setVisible(confCompleteness.get(NumbersInfo.ConfItem.VIR_SCHEMA.name()) == false || confCompleteness.get(NumbersInfo.ConfItem.ANY_TYPE.name()) == false);
            this.securityquestions.setVisible(confCompleteness.get(NumbersInfo.ConfItem.SECURITY_QUESTION.name()) == false);
            this.roles.setVisible(confCompleteness.get(NumbersInfo.ConfItem.ROLE.name()) == false);
            return true;
        }
        return false;
    }
}

