/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.rest.NotificationRestClient;
import org.apache.syncope.client.console.rest.ReportRestClient;
import org.apache.syncope.client.console.rest.TaskRestClient;
import org.apache.syncope.client.console.wicket.ajax.markup.html.IndicatorAjaxLink;
import org.apache.syncope.client.console.widgets.JobWidget;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.to.JobTO;
import org.apache.syncope.common.lib.types.JobAction;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobActionPanel
extends WizardMgtPanel<Serializable> {
    private static final long serialVersionUID = 6645135178773151224L;
    private static final Logger LOG = LoggerFactory.getLogger(JobActionPanel.class);
    private final NotificationRestClient notificationRestClient = new NotificationRestClient();
    private final ReportRestClient reportRestClient = new ReportRestClient();
    private final TaskRestClient taskRestClient = new TaskRestClient();

    public JobActionPanel(String id, final JobTO jobTO, final JobWidget widget, PageReference pageRef) {
        super(id, true);
        Fragment controls;
        this.setOutputMarkupId(true);
        if (jobTO.isRunning()) {
            controls = new Fragment("controls", "runningFragment", (MarkupContainer)this);
            controls.add(new Component[]{new IndicatorAjaxLink<Void>("stop"){
                private static final long serialVersionUID = -7978723352517770644L;

                public void onClick(AjaxRequestTarget target) {
                    try {
                        switch (jobTO.getType()) {
                            case NOTIFICATION: {
                                JobActionPanel.this.notificationRestClient.actionJob(JobAction.STOP);
                                break;
                            }
                            case REPORT: {
                                JobActionPanel.this.reportRestClient.actionJob(jobTO.getRefKey(), JobAction.STOP);
                                break;
                            }
                            case TASK: {
                                JobActionPanel.this.taskRestClient.actionJob(jobTO.getRefKey(), JobAction.STOP);
                                break;
                            }
                        }
                        SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                        this.send((IEventSink)widget, Broadcast.EXACT, new JobActionPayload(target));
                    }
                    catch (Exception e) {
                        LOG.error("While stopping {}", (Object)jobTO.getRefDesc(), (Object)e);
                        SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
                    }
                    ((BasePage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }});
        } else {
            controls = new Fragment("controls", "notRunningFragment", (MarkupContainer)this);
            controls.add(new Component[]{new IndicatorAjaxLink<Void>("start"){
                private static final long serialVersionUID = -7978723352517770644L;

                public void onClick(AjaxRequestTarget target) {
                    try {
                        switch (jobTO.getType()) {
                            case NOTIFICATION: {
                                JobActionPanel.this.notificationRestClient.actionJob(JobAction.START);
                                break;
                            }
                            case REPORT: {
                                JobActionPanel.this.reportRestClient.actionJob(jobTO.getRefKey(), JobAction.START);
                                break;
                            }
                            case TASK: {
                                JobActionPanel.this.taskRestClient.actionJob(jobTO.getRefKey(), JobAction.START);
                                break;
                            }
                        }
                        SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
                        this.send((IEventSink)widget, Broadcast.EXACT, new JobActionPayload(target));
                    }
                    catch (Exception e) {
                        LOG.error("While starting {}", (Object)jobTO.getRefDesc(), (Object)e);
                        SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
                    }
                    ((BasePage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }});
        }
        this.addInnerObject(new Component[]{controls});
    }

    public static class JobActionPayload
    implements Serializable {
        private static final long serialVersionUID = -6798174303329212126L;
        private final AjaxRequestTarget target;

        public JobActionPayload(AjaxRequestTarget target) {
            this.target = target;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }
    }
}

