/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import com.pingunaut.wicket.chartjs.chart.impl.Line;
import com.pingunaut.wicket.chartjs.core.panel.LineChartPanel;
import com.pingunaut.wicket.chartjs.data.sets.LineDataSet;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.syncope.client.console.widgets.BaseWidget;
import org.apache.syncope.common.lib.info.SystemInfo;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class LoadWidget
extends BaseWidget {
    private static final long serialVersionUID = -816175678514035085L;
    private final LineChartPanel chart;

    public LoadWidget(String id, SystemInfo systeminfo) {
        super(id);
        this.setOutputMarkupId(true);
        this.chart = new LineChartPanel("chart", (IModel)Model.of((Serializable)this.build(systeminfo)));
        this.add(new Component[]{this.chart});
    }

    private Line build(SystemInfo systeminfo) {
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Double> cpuValues = new ArrayList<Double>();
        ArrayList<Long> memValues = new ArrayList<Long>();
        for (SystemInfo.LoadInstant instant : systeminfo.getLoad()) {
            labels.add(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(systeminfo.getStartTime() + instant.getUptime()));
            cpuValues.add(instant.getSystemLoadAverage() * 1000.0);
            memValues.add(instant.getTotalMemory());
        }
        Line line = new Line();
        line.getOptions().setPointDot(Boolean.valueOf(false));
        line.getOptions().setDatasetFill(Boolean.valueOf(false));
        line.getOptions().setResponsive(true);
        line.getOptions().setMaintainAspectRatio(Boolean.valueOf(true));
        line.getOptions().setShowScale(Boolean.valueOf(false));
        line.getOptions().setMultiTooltipTemplate("<%= datasetLabel %>");
        line.getData().setLabels(labels);
        ArrayList<LineDataSet> datasets = new ArrayList<LineDataSet>();
        LineDataSet cpuDataSet = new LineDataSet(cpuValues);
        cpuDataSet.setLabel("CPU");
        cpuDataSet.setPointColor("purple");
        cpuDataSet.setStrokeColor("purple");
        datasets.add(cpuDataSet);
        LineDataSet memDataSet = new LineDataSet(memValues);
        memDataSet.setLabel("MEM");
        memDataSet.setPointColor("grey");
        memDataSet.setStrokeColor("grey");
        datasets.add(memDataSet);
        line.getData().setDatasets(datasets);
        return line;
    }

    public void refresh(SystemInfo systeminfo) {
        this.chart.setDefaultModelObject((Object)this.build(systeminfo));
    }
}

