/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import java.io.Serializable;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.Administration;
import org.apache.syncope.client.console.pages.Realms;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.topology.Topology;
import org.apache.syncope.client.console.widgets.BaseWidget;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public class NumberWidget
extends BaseWidget {
    private static final long serialVersionUID = -816175678514035085L;
    private int number;
    private final Label numberLabel;

    public NumberWidget(String id, String bg, int number, String label, String icon) {
        super(id);
        Class responsePage;
        this.number = number;
        this.setOutputMarkupId(true);
        WebMarkupContainer box = new WebMarkupContainer("box");
        box.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)(" " + bg)))});
        boolean isAuthorized = true;
        final PageParameters pageParameters = new PageParameters();
        List<String> anyTypes = new AnyTypeRestClient().list();
        switch (id) {
            case "totalUsers": {
                pageParameters.add("selectedIndex", (Object)1);
                responsePage = Realms.class;
                isAuthorized = SyncopeConsoleSession.get().owns("USER_SEARCH");
                break;
            }
            case "totalGroups": {
                pageParameters.add("selectedIndex", (Object)2);
                responsePage = Realms.class;
                isAuthorized = SyncopeConsoleSession.get().owns("GROUP_SEARCH");
                break;
            }
            case "totalAny1OrRoles": {
                if (icon.equals("ion ion-gear-a")) {
                    Integer selectedIndex = null;
                    for (int i = 0; i < anyTypes.size() && selectedIndex == null; ++i) {
                        if (!anyTypes.get(i).equals(label)) continue;
                        selectedIndex = i + 1;
                        pageParameters.add("selectedIndex", (Object)selectedIndex);
                    }
                    responsePage = Realms.class;
                    isAuthorized = SyncopeConsoleSession.get().owns(label + "_SEARCH");
                    break;
                }
                responsePage = Administration.class;
                isAuthorized = SyncopeConsoleSession.get().owns("ROLE_LIST");
                break;
            }
            case "totalAny2OrResources": {
                if (icon.equals("ion ion-gear-a")) {
                    Integer selectedIndex = null;
                    for (int i = 0; i < anyTypes.size() && selectedIndex == null; ++i) {
                        if (!anyTypes.get(i).equals(label)) continue;
                        selectedIndex = i + 1;
                        pageParameters.add("selectedIndex", (Object)selectedIndex);
                    }
                    responsePage = Realms.class;
                    isAuthorized = SyncopeConsoleSession.get().owns(label + "_SEARCH");
                    break;
                }
                responsePage = Topology.class;
                isAuthorized = SyncopeConsoleSession.get().owns("CONNECTOR_LIST") && SyncopeConsoleSession.get().owns("RESOURCE_LIST");
                break;
            }
            default: {
                pageParameters.add("selectedIndex", (Object)0);
                responsePage = Realms.class;
            }
        }
        AjaxEventBehavior clickToRealms = new AjaxEventBehavior("onmousedown"){
            private static final long serialVersionUID = -7133385027739964990L;

            protected void onEvent(AjaxRequestTarget target) {
                NumberWidget.this.setResponsePage(responsePage, pageParameters);
            }
        };
        if (isAuthorized) {
            box.add(new Behavior[]{clickToRealms});
        }
        this.add(new Component[]{box});
        this.numberLabel = new Label("number", (Serializable)Integer.valueOf(number));
        this.numberLabel.setOutputMarkupId(true);
        box.add(new Component[]{this.numberLabel});
        box.add(new Component[]{new Label("label", (Serializable)((Object)label))});
        Label iconLabel = new Label("icon");
        iconLabel.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)icon))});
        box.add(new Component[]{iconLabel});
    }

    public boolean refresh(int number) {
        if (this.number != number) {
            this.number = number;
            this.numberLabel.setDefaultModelObject((Object)number);
            return true;
        }
        return false;
    }
}

