/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.widgets;

import com.pingunaut.wicket.chartjs.chart.impl.Doughnut;
import com.pingunaut.wicket.chartjs.core.panel.DoughnutChartPanel;
import java.io.Serializable;
import java.util.Map;
import org.apache.syncope.client.console.widgets.BaseWidget;
import org.apache.syncope.client.console.widgets.LabeledDoughnutChartData;
import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class UsersByStatusWidget
extends BaseWidget {
    private static final long serialVersionUID = -816175678514035085L;
    private static final String[] COLORS = new String[]{"green", "orange", "aqua", "red", "gray"};
    private Map<String, Integer> usersByStatus;
    private final DoughnutChartPanel chart;

    public UsersByStatusWidget(String id, Map<String, Integer> usersByStatus) {
        super(id);
        this.usersByStatus = usersByStatus;
        this.setOutputMarkupId(true);
        this.chart = new DoughnutChartPanel("chart", (IModel)Model.of((Serializable)this.build(usersByStatus)));
        this.add(new Component[]{this.chart});
    }

    private Doughnut build(Map<String, Integer> usersByStatus) {
        Doughnut doughnut = new Doughnut();
        doughnut.getOptions().setResponsive(true);
        doughnut.getOptions().setMaintainAspectRatio(Boolean.valueOf(true));
        int i = 0;
        for (Map.Entry<String, Integer> entry : usersByStatus.entrySet()) {
            doughnut.getData().add(new LabeledDoughnutChartData(entry.getValue(), COLORS[i % 5], entry.getKey()));
            ++i;
        }
        return doughnut;
    }

    public boolean refresh(Map<String, Integer> usersByStatus) {
        if (!this.usersByStatus.equals(usersByStatus)) {
            this.usersByStatus = usersByStatus;
            this.chart.setDefaultModelObject((Object)this.build(usersByStatus));
            return true;
        }
        return false;
    }
}

