/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.SubmitableModalPanel;
import org.apache.syncope.client.console.panels.WizardModalPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardMgtButtonBar;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.extensions.wizard.IWizardModel;
import org.apache.wicket.extensions.wizard.Wizard;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AjaxWizard<T extends Serializable>
extends Wizard
implements SubmitableModalPanel,
WizardModalPanel<T> {
    private static final long serialVersionUID = -1272120742876833520L;
    private final List<Component> outerObjects = new ArrayList<Component>();
    protected static final Logger LOG = LoggerFactory.getLogger(AjaxWizard.class);
    private T item;
    private final Mode mode;
    private IEventSink eventSink;
    private final PageReference pageRef;

    public AjaxWizard(String id, T item, WizardModel model, Mode mode, PageReference pageRef) {
        super(id);
        this.item = item;
        this.mode = mode;
        this.pageRef = pageRef;
        if (mode == Mode.READONLY) {
            model.setCancelVisible(false);
        }
        this.add(new Component[]{new ListView<Component>("outerObjectsRepeater", this.outerObjects){
            private static final long serialVersionUID = -9180479401817023838L;

            protected void populateItem(ListItem<Component> item) {
                item.add(new Component[]{(Component)item.getModelObject()});
            }
        }});
        this.setOutputMarkupId(true);
        this.setDefaultModel((IModel)new CompoundPropertyModel((Object)this));
        this.init((IWizardModel)model);
    }

    public final AjaxWizard<T> addOuterObject(List<Component> childs) {
        this.outerObjects.addAll(childs);
        return this;
    }

    protected AjaxWizard<T> setEventSink(IEventSink eventSink) {
        this.eventSink = eventSink;
        return this;
    }

    protected void init(IWizardModel wizardModel) {
        super.init(wizardModel);
        this.getForm().remove("feedback");
        if (this.mode == Mode.READONLY) {
            Iterator iter = wizardModel.stepIterator();
            while (iter.hasNext()) {
                ((WizardStep)WizardStep.class.cast(iter.next())).setEnabled(false);
            }
        }
    }

    protected Component newButtonBar(String id) {
        return new AjaxWizardMgtButtonBar(id, this, this.mode);
    }

    protected abstract void onCancelInternal();

    protected abstract Serializable onApplyInternal(AjaxRequestTarget var1);

    public final void onCancel() {
        AjaxRequestTarget target = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
        try {
            this.onCancelInternal();
            if (this.eventSink == null) {
                this.send((IEventSink)this, Broadcast.BUBBLE, new NewItemCancelEvent<T>(this.item, target));
            } else {
                this.send(this.eventSink, Broadcast.EXACT, new NewItemCancelEvent<T>(this.item, target));
            }
        }
        catch (Exception e) {
            LOG.warn("Wizard error on cancel", (Throwable)e);
            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
            ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }

    public final void onFinish() {
        AjaxRequestTarget target = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
        try {
            Serializable res = this.onApplyInternal(target);
            if (this.eventSink == null) {
                this.send((IEventSink)this, Broadcast.BUBBLE, new NewItemFinishEvent<T>(this.item, target).setResult(res));
            } else {
                this.send(this.eventSink, Broadcast.EXACT, new NewItemFinishEvent<T>(this.item, target).setResult(res));
            }
        }
        catch (Exception e) {
            LOG.error("Wizard error on finish", (Throwable)e);
            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
            ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
        }
    }

    @Override
    public T getItem() {
        return this.item;
    }

    public AjaxWizard<T> setItem(T item) {
        this.item = item;
        return this;
    }

    @Override
    public void onSubmit(AjaxRequestTarget target, Form<?> form) {
        this.onApplyInternal(target);
    }

    @Override
    public void onError(AjaxRequestTarget target, Form<?> form) {
        ((BasePage)this.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    public static class NewItemFinishEvent<T extends Serializable>
    extends NewItemEvent<T> {
        private static final String EVENT_DESCRIPTION = "finish";
        private Serializable result;

        public NewItemFinishEvent(T item, AjaxRequestTarget target) {
            super(item, target);
        }

        @Override
        public String getEventDescription() {
            return EVENT_DESCRIPTION;
        }

        public NewItemFinishEvent<T> setResult(Serializable result) {
            this.result = result;
            return this;
        }

        public Serializable getResult() {
            return this.result;
        }
    }

    public static class NewItemCancelEvent<T extends Serializable>
    extends NewItemEvent<T> {
        private static final String EVENT_DESCRIPTION = "cancel";

        public NewItemCancelEvent(T item, AjaxRequestTarget target) {
            super(item, target);
        }

        @Override
        public String getEventDescription() {
            return EVENT_DESCRIPTION;
        }
    }

    public static class EditItemActionEvent<T extends Serializable>
    extends NewItemActionEvent<T> {
        private static final String EVENT_DESCRIPTION = "edit";

        public EditItemActionEvent(T item, AjaxRequestTarget target) {
            super(item, target);
        }

        public EditItemActionEvent(T item, int index, AjaxRequestTarget target) {
            super(item, index, target);
        }

        @Override
        public String getEventDescription() {
            return EVENT_DESCRIPTION;
        }
    }

    public static class NewItemActionEvent<T extends Serializable>
    extends NewItemEvent<T> {
        private static final String EVENT_DESCRIPTION = "new";
        private int index;

        public NewItemActionEvent(T item, AjaxRequestTarget target) {
            super(item, target);
        }

        public NewItemActionEvent(T item, int index, AjaxRequestTarget target) {
            super(item, target);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public String getEventDescription() {
            return EVENT_DESCRIPTION;
        }
    }

    public static abstract class NewItemEvent<T extends Serializable> {
        private final T item;
        private IModel<String> resourceModel;
        private final AjaxRequestTarget target;
        private WizardModalPanel<?> modalPanel;

        public NewItemEvent(T item, AjaxRequestTarget target) {
            this.item = item;
            this.target = target;
        }

        public T getItem() {
            return this.item;
        }

        public AjaxRequestTarget getTarget() {
            return this.target;
        }

        public WizardModalPanel<?> getModalPanel() {
            return this.modalPanel;
        }

        public NewItemEvent<T> forceModalPanel(WizardModalPanel<?> modalPanel) {
            this.modalPanel = modalPanel;
            return this;
        }

        public IModel<String> getResourceModel() {
            return this.resourceModel;
        }

        public NewItemEvent<T> setResourceModel(IModel<String> resourceModel) {
            this.resourceModel = resourceModel;
            return this;
        }

        public abstract String getEventDescription();
    }

    public static enum Mode {
        CREATE,
        EDIT,
        TEMPLATE,
        READONLY;

    }
}

