/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.console.wizards.any.AnyWrapper;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.GroupTO;

public class GroupWrapper
extends AnyWrapper<GroupTO> {
    private static final long serialVersionUID = 8058288034211558376L;
    private List<SearchClause> uDynClauses;
    private Map<String, List<SearchClause>> aDynClauses;

    public GroupWrapper(GroupTO groupTO) {
        super(groupTO);
        this.getUDynClauses();
        this.getADynClauses();
    }

    public final List<SearchClause> getUDynClauses() {
        if (this.uDynClauses == null) {
            this.uDynClauses = SearchUtils.getSearchClauses(((GroupTO)this.anyTO).getUDynMembershipCond());
        }
        return this.uDynClauses;
    }

    public void setUDynClauses(List<SearchClause> uDynClauses) {
        this.uDynClauses = uDynClauses;
    }

    public final Map<String, List<SearchClause>> getADynClauses() {
        if (this.aDynClauses == null) {
            this.aDynClauses = SearchUtils.getSearchClauses(((GroupTO)this.anyTO).getADynMembershipConds());
        }
        return this.aDynClauses;
    }

    public void setADynClauses(Map<String, List<SearchClause>> aDynClauses) {
        this.aDynClauses = aDynClauses;
    }

    public String getUDynMembershipCond() {
        if (CollectionUtils.isEmpty(this.uDynClauses)) {
            return null;
        }
        return SearchUtils.buildFIQL(this.uDynClauses, (AbstractFiqlSearchConditionBuilder)SyncopeClient.getUserSearchConditionBuilder());
    }

    public Map<String, String> getADynMembershipConds() {
        HashMap<String, String> res = new HashMap<String, String>();
        if (this.aDynClauses != null && !this.aDynClauses.isEmpty()) {
            for (Map.Entry<String, List<SearchClause>> entry : this.aDynClauses.entrySet()) {
                String fiql;
                if (!CollectionUtils.isNotEmpty((Collection)entry.getValue()) || (fiql = SearchUtils.buildFIQL(entry.getValue(), (AbstractFiqlSearchConditionBuilder)SyncopeClient.getAnyObjectSearchConditionBuilder((String)entry.getKey()))) == null) continue;
                res.put(entry.getKey(), fiql);
            }
        }
        return res;
    }

    public GroupTO fillDynamicConditions() {
        ((GroupTO)this.anyTO).setUDynMembershipCond(this.getUDynMembershipCond());
        ((GroupTO)this.anyTO).getADynMembershipConds().clear();
        ((GroupTO)this.anyTO).getADynMembershipConds().putAll(this.getADynMembershipConds());
        return (GroupTO)this.anyTO;
    }
}

