/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.any;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.Transformer;
import org.apache.syncope.client.console.rest.AnyTypeClassRestClient;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxPalettePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.common.lib.EntityTOUtils;
import org.apache.syncope.common.lib.to.GroupTO;
import org.apache.syncope.common.lib.to.TypeExtensionTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.util.ListModel;

public class TypeExtensionWizardBuilder
extends AjaxWizardBuilder<TypeExtensionTO> {
    private static final long serialVersionUID = -7185214439144835423L;
    private final GroupTO groupTO;
    private final String anyTypeLabel;
    private final String auxClassesLabel;

    public TypeExtensionWizardBuilder(GroupTO groupTO, TypeExtensionTO defaultItem, String anyTypeLabel, String auxClassesLabel, PageReference pageRef) {
        super(defaultItem, pageRef);
        this.groupTO = groupTO;
        this.anyTypeLabel = anyTypeLabel;
        this.auxClassesLabel = auxClassesLabel;
    }

    @Override
    protected WizardModel buildModelSteps(TypeExtensionTO modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Details(modelObject));
        return wizardModel;
    }

    @Override
    protected Serializable onApplyInternal(final TypeExtensionTO modelObject) {
        List typeExtensions = ListUtils.select((Collection)this.groupTO.getTypeExtensions(), (Predicate)new Predicate<TypeExtensionTO>(){

            public boolean evaluate(TypeExtensionTO object) {
                return !object.getAnyType().equals(modelObject.getAnyType());
            }
        });
        typeExtensions.add(modelObject);
        this.groupTO.getTypeExtensions().clear();
        this.groupTO.getTypeExtensions().addAll(typeExtensions);
        return this.groupTO;
    }

    public class Details
    extends WizardStep {
        private static final long serialVersionUID = 6472869166547883903L;

        public Details(TypeExtensionTO typeExtensionTO) {
            this.setOutputMarkupId(true);
            this.add(new Component[]{new Label("anyType.label", (Serializable)((Object)TypeExtensionWizardBuilder.this.anyTypeLabel))});
            if (typeExtensionTO.getAnyType() == null) {
                List<String> anyTypes = new AnyTypeRestClient().list();
                anyTypes.remove(AnyTypeKind.GROUP.name());
                CollectionUtils.filter(anyTypes, (Predicate)new Predicate<String>(){

                    public boolean evaluate(String anyType) {
                        return TypeExtensionWizardBuilder.this.groupTO.getTypeExtension(anyType) == null;
                    }
                });
                AjaxDropDownChoicePanel<String> anyTypeComponent = new AjaxDropDownChoicePanel<String>("anyType.component", "anyType", (IModel<String>)new PropertyModel((Object)typeExtensionTO, "anyType"));
                anyTypeComponent.setChoices(anyTypes);
                anyTypeComponent.addRequiredLabel();
                this.add(new Component[]{anyTypeComponent.hideLabel().setOutputMarkupId(true)});
            } else {
                AjaxTextFieldPanel anyTypeComponent = new AjaxTextFieldPanel("anyType.component", "anyType", (IModel<String>)new PropertyModel((Object)typeExtensionTO, "anyType"));
                anyTypeComponent.setEnabled(false);
                this.add(new Component[]{anyTypeComponent.hideLabel()});
            }
            this.add(new Component[]{new Label("auxClasses.label", (Serializable)((Object)TypeExtensionWizardBuilder.this.auxClassesLabel))});
            List anyTypeClasses = (List)CollectionUtils.collect(new AnyTypeClassRestClient().list(), (Transformer)EntityTOUtils.keyTransformer(), new ArrayList());
            AjaxPalettePanel auxClassesPalette = new AjaxPalettePanel.Builder().build("auxClasses.palette", new PropertyModel((Object)typeExtensionTO, "auxClasses"), new ListModel(anyTypeClasses));
            this.add(new Component[]{auxClassesPalette.hideLabel().setOutputMarkupId(true)});
        }
    }
}

