/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.panels.ProvisionAuxClassesPanel;
import org.apache.syncope.client.console.rest.ConnectorRestClient;
import org.apache.syncope.client.console.wicket.ajax.form.IndicatorAjaxFormComponentUpdatingBehavior;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxCheckBoxPanel;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxTextFieldPanel;
import org.apache.syncope.client.console.wizards.AjaxWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ItemTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.resources.JEXLTransformersTogglePanel;
import org.apache.syncope.client.console.wizards.resources.ResourceMappingPanel;
import org.apache.syncope.client.console.wizards.resources.ResourceProvision;
import org.apache.syncope.common.lib.to.MappingTO;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class ProvisionWizardBuilder
extends AjaxWizardBuilder<ResourceProvision> {
    private static final long serialVersionUID = 3739399543837732640L;
    private final ConnectorRestClient connectorRestClient = new ConnectorRestClient();
    private final ResourceTO resourceTO;
    protected AjaxTextFieldPanel clazz;

    protected void setObjectClassModelObject(String type) {
        if (this.clazz != null) {
            if (AnyTypeKind.USER.name().equals(type)) {
                this.clazz.setModelObject("__ACCOUNT__");
            } else if (AnyTypeKind.GROUP.name().equals(type)) {
                this.clazz.setModelObject("__GROUP__");
            } else {
                this.clazz.setModelObject("");
            }
        }
    }

    public ProvisionWizardBuilder(ResourceTO resourceTO, PageReference pageRef) {
        super(new ResourceProvision(), pageRef);
        this.resourceTO = resourceTO;
    }

    @Override
    protected WizardModel buildModelSteps(ResourceProvision modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new ObjectType(modelObject));
        wizardModel.add((IWizardStep)new AuxClasses(modelObject));
        Mapping mapping = new Mapping(modelObject);
        mapping.setOutputMarkupId(true);
        ItemTransformersTogglePanel itemTransformers = new ItemTransformersTogglePanel((WebMarkupContainer)mapping, this.pageRef);
        this.addOuterObject(new Component[]{itemTransformers});
        JEXLTransformersTogglePanel jexlTransformers = new JEXLTransformersTogglePanel((WebMarkupContainer)mapping, this.pageRef);
        this.addOuterObject(new Component[]{jexlTransformers});
        if (modelObject.getProvisionTO() != null && modelObject.getProvisionTO().getMapping() == null) {
            modelObject.getProvisionTO().setMapping(new MappingTO());
        }
        mapping.add(new Component[]{new ResourceMappingPanel("mapping", this.resourceTO, modelObject, itemTransformers, jexlTransformers)});
        wizardModel.add((IWizardStep)mapping);
        wizardModel.add((IWizardStep)new ConnObjectLink(modelObject));
        return wizardModel;
    }

    @Override
    protected Serializable onApplyInternal(final ResourceProvision modelObject) {
        if (modelObject.getOrgUnitTO() != null) {
            this.resourceTO.setOrgUnit(modelObject.getOrgUnitTO());
            this.resourceTO.getOrgUnit().getItems().clear();
            this.resourceTO.getOrgUnit().getItems().addAll(modelObject.getItems());
        } else if (modelObject.getProvisionTO() != null) {
            List provisions = modelObject.getKey() == null ? ListUtils.select((Collection)this.resourceTO.getProvisions(), (Predicate)new Predicate<ProvisionTO>(){

                public boolean evaluate(ProvisionTO object) {
                    return !modelObject.getAnyType().equals(object.getAnyType());
                }
            }) : ListUtils.select((Collection)this.resourceTO.getProvisions(), (Predicate)new Predicate<ProvisionTO>(){

                public boolean evaluate(ProvisionTO object) {
                    return !modelObject.getKey().equals(object.getKey());
                }
            });
            ProvisionTO provisionTO = modelObject.getProvisionTO();
            provisionTO.getMapping().getItems().clear();
            provisionTO.getMapping().getItems().addAll(modelObject.getItems());
            provisions.add(provisionTO);
            this.resourceTO.getProvisions().clear();
            this.resourceTO.getProvisions().addAll(provisions);
        }
        return modelObject;
    }

    private final class ConnObjectLink
    extends WizardStep {
        private static final long serialVersionUID = 2359955465172450478L;

        ConnObjectLink(ResourceProvision item) {
            super((IModel)new ResourceModel("link.title", ""), (IModel)new ResourceModel("link.summary", ""));
            WebMarkupContainer connObjectLinkContainer = new WebMarkupContainer("connObjectLinkContainer");
            connObjectLinkContainer.setOutputMarkupId(true);
            this.add(new Component[]{connObjectLinkContainer});
            boolean connObjectLinkEnabled = false;
            if (StringUtils.isNotBlank((CharSequence)item.getConnObjectLink())) {
                connObjectLinkEnabled = true;
            }
            final AjaxCheckBoxPanel connObjectLinkCheckbox = new AjaxCheckBoxPanel("connObjectLinkCheckbox", new ResourceModel("connObjectLinkCheckbox", "connObjectLinkCheckbox").getObject(), (IModel<Boolean>)new Model((Serializable)Boolean.valueOf(connObjectLinkEnabled)), false);
            connObjectLinkCheckbox.setEnabled(true);
            connObjectLinkContainer.add(new Component[]{connObjectLinkCheckbox});
            final AjaxTextFieldPanel connObjectLink = new AjaxTextFieldPanel("connObjectLink", new ResourceModel("connObjectLink", "connObjectLink").getObject(), (IModel<String>)new PropertyModel((Object)item, "connObjectLink"), false);
            connObjectLink.enableJexlHelp();
            connObjectLink.setEnabled(connObjectLinkEnabled);
            connObjectLinkContainer.add(new Component[]{connObjectLink});
            connObjectLinkCheckbox.getField().add(new Behavior[]{new IndicatorAjaxFormComponentUpdatingBehavior("change"){
                private static final long serialVersionUID = -1107858522700306810L;

                protected void onUpdate(AjaxRequestTarget target) {
                    connObjectLink.setEnabled((Boolean)connObjectLinkCheckbox.getModelObject());
                    connObjectLink.setModelObject("");
                    target.add(new Component[]{connObjectLink});
                }
            }});
        }
    }

    private static final class Mapping
    extends WizardStep {
        private static final long serialVersionUID = 3454904947720856253L;

        Mapping(ResourceProvision item) {
            this.setTitleModel((IModel)Model.of((Serializable)((Object)"Mapping")));
            this.setSummaryModel((IModel)Model.of((Serializable)((Object)"")));
        }
    }

    private static final class AuxClasses
    extends WizardStep
    implements WizardModel.ICondition {
        private static final long serialVersionUID = 5315236191866427500L;
        private final ResourceProvision provision;

        AuxClasses(ResourceProvision item) {
            this.provision = item;
            this.setTitleModel((IModel)new ResourceModel("auxClasses.title"));
            this.setSummaryModel((IModel)new StringResourceModel("auxClasses.summary", (Component)this, (IModel)new Model((Serializable)item)));
            this.add(new Component[]{new ProvisionAuxClassesPanel("auxClasses", item.getProvisionTO())});
        }

        public boolean evaluate() {
            return this.provision.getProvisionTO() != null;
        }
    }

    private final class ObjectType
    extends WizardStep {
        private static final long serialVersionUID = -1657800545799468278L;

        ObjectType(ResourceProvision item) {
            super((IModel)new ResourceModel("clazz.title", ""), (IModel)new ResourceModel("clazz.summary", ""), (IModel)new Model((Serializable)item));
            WebMarkupContainer container = new WebMarkupContainer("container");
            container.setOutputMarkupId(true);
            this.add(new Component[]{container});
            ProvisionWizardBuilder.this.clazz = new AjaxTextFieldPanel("clazz", "clazz", (IModel<String>)new PropertyModel((Object)item, "objectClass"));
            ProvisionWizardBuilder.this.clazz.setRequired(true);
            ProvisionWizardBuilder.this.clazz.setChoices(ProvisionWizardBuilder.this.connectorRestClient.getObjectClasses(ProvisionWizardBuilder.this.resourceTO.getConnector()));
            container.add(new Component[]{ProvisionWizardBuilder.this.clazz});
        }
    }
}

