/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AbstractModalPanel;
import org.apache.syncope.client.console.panels.ListViewPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.ResourceRestClient;
import org.apache.syncope.client.console.wicket.markup.html.bootstrap.dialog.BaseModal;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLinksTogglePanel;
import org.apache.syncope.client.console.wizards.AjaxWizard;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.resources.ObjectTypeTogglePanel;
import org.apache.syncope.client.console.wizards.resources.ProvisionWizardBuilder;
import org.apache.syncope.client.console.wizards.resources.ResourceProvision;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.to.ItemTO;
import org.apache.syncope.common.lib.to.ProvisionTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;

public class ResourceProvisionPanel
extends AbstractModalPanel<Serializable> {
    private static final long serialVersionUID = -7982691107029848579L;
    private final ResourceRestClient resourceRestClient = new ResourceRestClient();
    private final ResourceTO resourceTO;
    private final List<ResourceProvision> provisions;
    private final ObjectTypeTogglePanel objectTypeTogglePanel;
    private final WizardMgtPanel<ResourceProvision> list;
    private final ProvisionWizardBuilder wizard;
    private final AjaxLink<ResourceProvision> addAjaxLink;
    protected ActionLinksTogglePanel<ResourceProvision> actionTogglePanel;

    public ResourceProvisionPanel(BaseModal<Serializable> modal, final ResourceTO resourceTO, final String adminRealm, final PageReference pageRef) {
        super(modal, pageRef);
        this.resourceTO = resourceTO;
        this.setOutputMarkupId(true);
        this.actionTogglePanel = new ActionLinksTogglePanel("toggle", pageRef);
        this.add(new Component[]{this.actionTogglePanel});
        this.wizard = new ProvisionWizardBuilder(resourceTO, pageRef);
        ListViewPanel.Builder<ResourceProvision> builder = new ListViewPanel.Builder<ResourceProvision>(ResourceProvision.class, pageRef){
            private static final long serialVersionUID = 4907732721283972943L;

            @Override
            protected ResourceProvision getActualItem(final ResourceProvision item, List<ResourceProvision> list) {
                return item == null ? null : (ResourceProvision)IteratorUtils.find(list.iterator(), (Predicate)new Predicate<ResourceProvision>(){

                    public boolean evaluate(ResourceProvision in) {
                        return (item.getKey() == null && in.getKey() == null || in.getKey() != null && in.getKey().equals(item.getKey())) && (item.getAnyType() == null && in.getAnyType() == null || in.getAnyType() != null && in.getAnyType().equals(item.getAnyType()));
                    }
                });
            }

            @Override
            protected void customActionCallback(AjaxRequestTarget target) {
                ResourceProvisionPanel.this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
            }

            @Override
            protected void customActionOnCancelCallback(AjaxRequestTarget target) {
                ResourceProvisionPanel.this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
            }

            @Override
            protected void customActionOnFinishCallback(AjaxRequestTarget target) {
                ResourceProvisionPanel.this.checkAddButton(adminRealm);
                ResourceProvisionPanel.this.sortProvisions();
                ResourceProvisionPanel.this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.BUBBLE, new BaseModal.ChangeFooterVisibilityEvent(target));
            }

            @Override
            protected ActionLinksTogglePanel<ResourceProvision> getTogglePanel() {
                return ResourceProvisionPanel.this.actionTogglePanel;
            }
        };
        this.provisions = new ArrayList<ResourceProvision>();
        if (resourceTO.getOrgUnit() != null) {
            this.provisions.add(new ResourceProvision(resourceTO.getOrgUnit()));
        }
        for (ProvisionTO provision : resourceTO.getProvisions()) {
            this.provisions.add(new ResourceProvision(provision));
        }
        this.sortProvisions();
        builder.setItems(this.provisions);
        builder.includes("anyType", "objectClass", "auxClasses");
        builder.setReuseItem(false);
        builder.addAction(new ActionLink<ResourceProvision>(){
            private static final long serialVersionUID = -3722207913631435504L;

            @Override
            public void onClick(AjaxRequestTarget target, ResourceProvision provision) {
                try {
                    ResourceProvisionPanel.this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.DEPTH, new AjaxWizard.NewItemActionEvent<ResourceProvision>(provision, 1, target).setResourceModel((IModel<String>)new StringResourceModel("inner.provision.mapping", (Component)ResourceProvisionPanel.this, (IModel)Model.of((Serializable)provision))));
                }
                catch (SyncopeClientException e) {
                    LOG.error("While contacting resource", (Throwable)e);
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? ((Object)((Object)e)).getClass().getName() : e.getMessage())));
                    ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                }
            }
        }, ActionLink.ActionType.MAPPING, "RESOURCE_READ").addAction(new ActionLink<ResourceProvision>(){
            private static final long serialVersionUID = -7780999687733432439L;

            @Override
            public void onClick(AjaxRequestTarget target, ResourceProvision provision) {
                try {
                    ResourceProvisionPanel.this.resourceRestClient.setLatestSyncToken(resourceTO.getKey(), provision.getAnyType());
                    SyncopeConsoleSession.get().info((Serializable)((Object)ResourceProvisionPanel.this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While setting latest sync token for {}/{}", new Object[]{resourceTO.getKey(), provision.getAnyType(), e});
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.SET_LATEST_SYNC_TOKEN, "RESOURCE_UPDATE").addAction(new ActionLink<ResourceProvision>(){
            private static final long serialVersionUID = -7780999687733432439L;

            @Override
            public void onClick(AjaxRequestTarget target, ResourceProvision provision) {
                try {
                    ResourceProvisionPanel.this.resourceRestClient.removeSyncToken(resourceTO.getKey(), provision.getAnyType());
                    SyncopeConsoleSession.get().info((Serializable)((Object)ResourceProvisionPanel.this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While removing sync token for {}/{}", new Object[]{resourceTO.getKey(), provision.getAnyType(), e});
                    SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        }, ActionLink.ActionType.REMOVE_SYNC_TOKEN, "RESOURCE_UPDATE").addAction(new ActionLink<ResourceProvision>(){
            private static final long serialVersionUID = -3722207913631435544L;

            @Override
            public void onClick(AjaxRequestTarget target, ResourceProvision provision) {
                if (provision.getOrgUnitTO() != null) {
                    resourceTO.setOrgUnit(null);
                } else if (provision.getProvisionTO() != null) {
                    resourceTO.getProvisions().remove(provision.getProvisionTO());
                }
                ResourceProvisionPanel.this.provisions.remove(provision);
                ResourceProvisionPanel.this.checkAddButton(adminRealm);
                ResourceProvisionPanel.this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.DEPTH, new ListViewPanel.ListViewReload(target));
            }
        }, ActionLink.ActionType.DELETE, "RESOURCE_UPDATE", true);
        builder.addNewItemPanelBuilder(this.wizard);
        this.list = builder.build("provision");
        this.list.setReadOnly(!SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", adminRealm));
        this.addAjaxLink = new AjaxLink<ResourceProvision>("add"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                this.send((IEventSink)ResourceProvisionPanel.this, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
                ResourceProvisionPanel.this.objectTypeTogglePanel.setHeaderLabel(target);
                ResourceProvisionPanel.this.objectTypeTogglePanel.toggle(target, true);
            }
        };
        this.list.addOrReplaceInnerObject(new Component[]{this.addAjaxLink});
        this.add(new Component[]{this.list});
        final ResourceProvision provision = new ResourceProvision();
        provision.setAnyType("");
        this.objectTypeTogglePanel = new ObjectTypeTogglePanel("objectTypeToggle", provision, this.getAnyTypes(), pageRef){
            private static final long serialVersionUID = 7878063325027015067L;

            @Override
            protected void onSubmit(String type, AjaxRequestTarget target) {
                provision.setAnyType(type);
                this.send((IEventSink)ResourceProvisionPanel.this.list, Broadcast.BREADTH, new ActionLinksTogglePanel.ActionLinkToggleCloseEventPayload(target));
                this.send((IEventSink)ResourceProvisionPanel.this.list, Broadcast.DEPTH, new AjaxWizard.NewItemActionEvent<ResourceProvision>(provision, target));
                ResourceProvisionPanel.this.wizard.setObjectClassModelObject(type);
            }
        };
        this.checkAddButton(adminRealm);
        this.add(new Component[]{this.objectTypeTogglePanel});
    }

    private void checkConnObjectKeyCount(String anyType, List<ItemTO> items) {
        long connObjectKeyCount = IterableUtils.countMatches(items, (Predicate)new Predicate<ItemTO>(){

            public boolean evaluate(ItemTO item) {
                return item.isConnObjectKey();
            }
        });
        if (connObjectKeyCount != 1L) {
            throw new IllegalArgumentException(anyType + ": " + new StringResourceModel("connObjectKeyValidation", (Component)this).getString());
        }
    }

    @Override
    public void onSubmit(AjaxRequestTarget target, Form<?> form) {
        try {
            if (this.resourceTO.getOrgUnit() != null) {
                this.checkConnObjectKeyCount("REALM", this.resourceTO.getOrgUnit().getItems());
            }
            for (ProvisionTO provision : new ArrayList(this.resourceTO.getProvisions())) {
                if (provision == null) continue;
                if (provision.getMapping() == null || provision.getMapping().getItems().isEmpty()) {
                    this.resourceTO.getProvisions().remove(provision);
                    continue;
                }
                this.checkConnObjectKeyCount(provision.getAnyType(), provision.getMapping().getItems());
            }
            this.resourceRestClient.update(this.resourceTO);
            SyncopeConsoleSession.get().info((Serializable)((Object)this.getString("operation_succeeded")));
            this.modal.close((IPartialPageRequestHandler)target);
        }
        catch (Exception e) {
            LOG.error("While creating or updating {}", (Object)this.resourceTO, (Object)e);
            SyncopeConsoleSession.get().error((Serializable)((Object)(StringUtils.isBlank((CharSequence)e.getMessage()) ? e.getClass().getName() : e.getMessage())));
        }
        ((BasePage)this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
    }

    private void sortProvisions() {
        Collections.sort(this.provisions, new Comparator<ResourceProvision>(){

            @Override
            public int compare(ResourceProvision o1, ResourceProvision o2) {
                return new AnyTypeRestClient.AnyTypeKeyComparator().compare(o1.getAnyType(), o2.getAnyType());
            }
        });
    }

    private LoadableDetachableModel<List<String>> getAnyTypes() {
        return new LoadableDetachableModel<List<String>>(){
            private static final long serialVersionUID = 5275935387613157437L;

            protected List<String> load() {
                List anyTypes = ListUtils.select(new AnyTypeRestClient().list(), (Predicate)new Predicate<String>(){

                    public boolean evaluate(String key) {
                        return ResourceProvisionPanel.this.resourceTO.getProvision(key) == null;
                    }
                });
                if (ResourceProvisionPanel.this.resourceTO.getOrgUnit() == null) {
                    anyTypes.add("REALM");
                }
                Collections.sort(anyTypes, new AnyTypeRestClient.AnyTypeKeyComparator());
                return anyTypes;
            }
        };
    }

    private void checkAddButton(String adminRealm) {
        boolean enabled = SyncopeConsoleSession.get().owns("RESOURCE_UPDATE", adminRealm) && !((List)this.getAnyTypes().getObject()).isEmpty();
        this.addAjaxLink.setVisible(enabled);
        this.objectTypeTogglePanel.setEnabled(enabled);
    }
}

