/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wicket.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.client.console.wicket.markup.html.form.PolicyRenderer;
import org.apache.syncope.common.lib.policy.AbstractPolicyTO;
import org.apache.syncope.common.lib.to.ResourceTO;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;

public class ResourceSecurityPanel
extends WizardStep {
    private static final long serialVersionUID = -7982691107029848579L;
    private final PolicyRestClient policyRestClient = new PolicyRestClient();
    private final IModel<Map<String, String>> passwordPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = 5275935387613157437L;

        protected Map<String, String> load() {
            HashMap<String, String> res = new HashMap<String, String>();
            for (AbstractPolicyTO policyTO : ResourceSecurityPanel.this.policyRestClient.getPolicies(PolicyType.PASSWORD)) {
                res.put(policyTO.getKey(), policyTO.getDescription());
            }
            return res;
        }
    };
    private final IModel<Map<String, String>> accountPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            HashMap<String, String> res = new HashMap<String, String>();
            for (AbstractPolicyTO policyTO : ResourceSecurityPanel.this.policyRestClient.getPolicies(PolicyType.ACCOUNT)) {
                res.put(policyTO.getKey(), policyTO.getDescription());
            }
            return res;
        }
    };
    private final IModel<Map<String, String>> pullPolicies = new LoadableDetachableModel<Map<String, String>>(){
        private static final long serialVersionUID = -2012833443695917883L;

        protected Map<String, String> load() {
            HashMap<String, String> res = new HashMap<String, String>();
            for (AbstractPolicyTO policyTO : ResourceSecurityPanel.this.policyRestClient.getPolicies(PolicyType.PULL)) {
                res.put(policyTO.getKey(), policyTO.getDescription());
            }
            return res;
        }
    };

    public ResourceSecurityPanel(ResourceTO resourceTO) {
        this.setOutputMarkupId(true);
        WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        container.setRenderBodyOnly(true);
        this.add(new Component[]{container});
        AjaxDropDownChoicePanel passwordPolicy = new AjaxDropDownChoicePanel("passwordPolicy", new ResourceModel("passwordPolicy", "passwordPolicy").getObject(), new PropertyModel((Object)resourceTO, "passwordPolicy"), false);
        passwordPolicy.setChoiceRenderer(new PolicyRenderer(this.passwordPolicies));
        passwordPolicy.setChoices(new ArrayList(((Map)this.passwordPolicies.getObject()).keySet()));
        ((DropDownChoice)passwordPolicy.getField()).setNullValid(true);
        container.add(new Component[]{passwordPolicy});
        AjaxDropDownChoicePanel accountPolicy = new AjaxDropDownChoicePanel("accountPolicy", new ResourceModel("accountPolicy", "accountPolicy").getObject(), new PropertyModel((Object)resourceTO, "accountPolicy"), false);
        accountPolicy.setChoiceRenderer(new PolicyRenderer(this.accountPolicies));
        accountPolicy.setChoices(new ArrayList(((Map)this.accountPolicies.getObject()).keySet()));
        ((DropDownChoice)accountPolicy.getField()).setNullValid(true);
        container.add(new Component[]{accountPolicy});
        AjaxDropDownChoicePanel pullPolicy = new AjaxDropDownChoicePanel("pullPolicy", new ResourceModel("pullPolicy", "pullPolicy").getObject(), new PropertyModel((Object)resourceTO, "pullPolicy"), false);
        pullPolicy.setChoiceRenderer(new PolicyRenderer(this.pullPolicies));
        pullPolicy.setChoices(new ArrayList(((Map)this.pullPolicies.getObject()).keySet()));
        ((DropDownChoice)pullPolicy.getField()).setNullValid(true);
        container.add(new Component[]{pullPolicy});
    }
}

