/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wizards.role;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.syncope.client.console.panels.search.SearchClause;
import org.apache.syncope.client.console.panels.search.SearchUtils;
import org.apache.syncope.client.lib.SyncopeClient;
import org.apache.syncope.common.lib.search.AbstractFiqlSearchConditionBuilder;
import org.apache.syncope.common.lib.to.RoleTO;

public class RoleWrapper
implements Serializable {
    private static final long serialVersionUID = 8058288034211558376L;
    private final RoleTO roleTO;
    private List<SearchClause> dynClauses;

    public RoleWrapper(RoleTO roleTO) {
        this.roleTO = roleTO;
        this.getDynClauses();
    }

    public final List<SearchClause> getDynClauses() {
        if (this.dynClauses == null) {
            this.dynClauses = SearchUtils.getSearchClauses(this.roleTO.getDynMembershipCond());
        }
        return this.dynClauses;
    }

    public void setDynClauses(List<SearchClause> dynClauses) {
        this.dynClauses = dynClauses;
    }

    public String getDynMembershipCond() {
        if (CollectionUtils.isEmpty(this.dynClauses)) {
            return null;
        }
        return SearchUtils.buildFIQL(this.dynClauses, (AbstractFiqlSearchConditionBuilder)SyncopeClient.getUserSearchConditionBuilder());
    }

    public RoleTO fillDynamicConditions() {
        this.roleTO.setDynMembershipCond(this.getDynMembershipCond());
        return this.roleTO;
    }

    public RoleTO getInnerObject() {
        return this.roleTO;
    }
}

