/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.LinkedList;

public class GenericsUtils {
    public static Class<?> extractGenericReturnType(Class<?> containingClass, Method method) {
        return GenericsUtils.asClass(GenericsUtils.resolve(method.getGenericReturnType(), containingClass));
    }

    public static Class extractGenericFieldType(Class containingClass, Field field) {
        return GenericsUtils.asClass(GenericsUtils.resolve(field.getGenericType(), (Type)containingClass));
    }

    public static Type extractActualType(Type containingType, Method method) {
        return GenericsUtils.resolve(method.getGenericReturnType(), containingType);
    }

    public static Type extractActualType(Type containingType, Field field) {
        return GenericsUtils.resolve(field.getGenericType(), containingType);
    }

    public static Type resolve(Type type, Type containingType) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof ParameterizedType) {
            return GenericsUtils.resolve((ParameterizedType)type, containingType);
        }
        if (type instanceof GenericArrayType) {
            return GenericsUtils.resolve((GenericArrayType)type, containingType);
        }
        if (type instanceof WildcardType) {
            return GenericsUtils.resolve((WildcardType)type, containingType);
        }
        if (type instanceof TypeVariable) {
            return GenericsUtils.resolve((TypeVariable)type, containingType);
        }
        return type;
    }

    public static boolean isAssignableFrom(Type suspectedSuperType, Type suspectedSubType) {
        Class suspectedSubClass;
        Class suspectedSuperClass = GenericsUtils.asClass(suspectedSuperType);
        if (!suspectedSuperClass.isAssignableFrom(suspectedSubClass = GenericsUtils.asClass(suspectedSubType))) {
            return false;
        }
        if (suspectedSuperType instanceof WildcardType) {
            for (Type t : ((WildcardType)suspectedSuperType).getUpperBounds()) {
                if (GenericsUtils.isAssignableFrom(t, suspectedSubType)) continue;
                return false;
            }
            for (Type t : ((WildcardType)suspectedSuperType).getLowerBounds()) {
                if (GenericsUtils.isAssignableFrom(suspectedSubType, t)) continue;
                return false;
            }
            return true;
        }
        Type curType = suspectedSubType;
        while (curType != null && !curType.equals(Object.class)) {
            Type[] types;
            Class curClass = GenericsUtils.asClass(curType);
            if (curClass.equals(suspectedSuperClass)) {
                Type resolved = GenericsUtils.resolve(curType, suspectedSubType);
                if (suspectedSuperType instanceof Class) {
                    if (resolved instanceof Class) {
                        return suspectedSuperType.equals(resolved);
                    }
                    return true;
                }
                if (suspectedSuperType instanceof ParameterizedType) {
                    if (resolved instanceof ParameterizedType) {
                        Type[] type2Arguments;
                        Type[] type1Arguments = ((ParameterizedType)suspectedSuperType).getActualTypeArguments();
                        if (type1Arguments.length != (type2Arguments = ((ParameterizedType)resolved).getActualTypeArguments()).length) {
                            return false;
                        }
                        for (int i = 0; i < type1Arguments.length; ++i) {
                            if (GenericsUtils.isAssignableFrom(type1Arguments[i], type2Arguments[i])) continue;
                            return false;
                        }
                        return true;
                    }
                } else if (suspectedSuperType instanceof GenericArrayType && resolved instanceof GenericArrayType) {
                    return GenericsUtils.isAssignableFrom(((GenericArrayType)suspectedSuperType).getGenericComponentType(), ((GenericArrayType)resolved).getGenericComponentType());
                }
                return false;
            }
            for (Type t : types = curClass.getGenericInterfaces()) {
                Type resolved = GenericsUtils.resolve(t, suspectedSubType);
                if (!GenericsUtils.isAssignableFrom(suspectedSuperType, resolved)) continue;
                return true;
            }
            curType = curClass.getGenericSuperclass();
        }
        return false;
    }

    public static Class asClass(Type actualType) {
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (actualType instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)actualType).getRawType();
            return (Class)rawType;
        }
        if (actualType instanceof GenericArrayType) {
            Type type = ((GenericArrayType)actualType).getGenericComponentType();
            return Array.newInstance(GenericsUtils.asClass(type), 0).getClass();
        }
        if (actualType instanceof TypeVariable) {
            return GenericsUtils.asClass(((TypeVariable)actualType).getBounds()[0]);
        }
        if (actualType instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)actualType;
            Type[] bounds = wildcardType.getLowerBounds();
            if (bounds != null && bounds.length > 0) {
                return GenericsUtils.asClass(bounds[0]);
            }
            return Object.class;
        }
        throw new RuntimeException(String.format("Unable to convert %s to Class.", actualType));
    }

    public static String toString(Type type) {
        if (type instanceof ParameterizedType) {
            return GenericsUtils.toString((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            return GenericsUtils.toString((WildcardType)type);
        }
        if (type instanceof GenericArrayType) {
            return GenericsUtils.toString((GenericArrayType)type);
        }
        if (type instanceof Class) {
            Class theClass = (Class)type;
            return theClass.isArray() ? theClass.getName() + "[]" : theClass.getName();
        }
        return type.toString();
    }

    private static Type resolve(TypeVariable typeVariable, Type containingType) {
        Object genericDeclaration = typeVariable.getGenericDeclaration();
        if (!(genericDeclaration instanceof Class)) {
            Type bounds0 = typeVariable.getBounds()[0];
            return GenericsUtils.resolve(bounds0, containingType);
        }
        Class typeVariableOwner = (Class)genericDeclaration;
        LinkedList<Type> stack = new LinkedList<Type>();
        if (containingType instanceof ParameterizedType) {
            stack.add(containingType);
        }
        Class theClass = GenericsUtils.asClass(containingType);
        Type genericSuperclass = theClass.getGenericSuperclass();
        while (genericSuperclass != null && !theClass.equals(Object.class) && !theClass.equals(typeVariableOwner)) {
            stack.addFirst(genericSuperclass);
            theClass = GenericsUtils.asClass(genericSuperclass);
            genericSuperclass = theClass.getGenericSuperclass();
        }
        int i = GenericsUtils.getTypeVariableIndex(typeVariable);
        Type resolved = typeVariable;
        for (Type t : stack) {
            if (!(t instanceof ParameterizedType)) continue;
            resolved = ((ParameterizedType)t).getActualTypeArguments()[i];
            if (resolved instanceof Class) {
                return resolved;
            }
            if (resolved instanceof TypeVariable) {
                i = GenericsUtils.getTypeVariableIndex(resolved);
                continue;
            }
            return GenericsUtils.resolve(resolved, containingType);
        }
        return resolved.getBounds()[0];
    }

    private static GenericArrayType resolve(GenericArrayType type, Type containingType) {
        Type componentType = type.getGenericComponentType();
        if (!(componentType instanceof Class)) {
            Type resolved = GenericsUtils.resolve(componentType, containingType);
            return GenericsUtils.create(resolved);
        }
        return type;
    }

    private static ParameterizedType resolve(ParameterizedType type, Type containingType) {
        Type[] types = (Type[])type.getActualTypeArguments().clone();
        boolean modified = GenericsUtils.resolve(types, containingType);
        return modified ? GenericsUtils.create(type.getRawType(), type.getOwnerType(), types) : type;
    }

    private static WildcardType resolve(WildcardType type, Type containingType) {
        Type[] upper = (Type[])type.getUpperBounds().clone();
        Type[] lower = (Type[])type.getLowerBounds().clone();
        boolean modified = GenericsUtils.resolve(upper, containingType);
        modified = modified || GenericsUtils.resolve(lower, containingType);
        return modified ? GenericsUtils.create(upper, lower) : type;
    }

    private static boolean resolve(Type[] types, Type containingType) {
        boolean modified = false;
        for (int i = 0; i < types.length; ++i) {
            Type t = types[i];
            if (t instanceof Class) continue;
            modified = true;
            Type resolved = GenericsUtils.resolve(t, containingType);
            if (resolved.equals(t)) continue;
            types[i] = resolved;
            modified = true;
        }
        return modified;
    }

    static ParameterizedType create(final Type rawType, final Type ownerType, final Type[] typeArguments) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return typeArguments;
            }

            @Override
            public Type getRawType() {
                return rawType;
            }

            @Override
            public Type getOwnerType() {
                return ownerType;
            }

            public String toString() {
                return GenericsUtils.toString(this);
            }
        };
    }

    static GenericArrayType create(final Type componentType) {
        return new GenericArrayType(){

            @Override
            public Type getGenericComponentType() {
                return componentType;
            }

            public String toString() {
                return GenericsUtils.toString(this);
            }
        };
    }

    static WildcardType create(final Type[] upperBounds, final Type[] lowerBounds) {
        return new WildcardType(){

            @Override
            public Type[] getUpperBounds() {
                return upperBounds;
            }

            @Override
            public Type[] getLowerBounds() {
                return lowerBounds;
            }

            public String toString() {
                return GenericsUtils.toString(this);
            }
        };
    }

    static String toString(ParameterizedType pt) {
        String s = GenericsUtils.toString(pt.getActualTypeArguments());
        return String.format("%s<%s>", GenericsUtils.toString(pt.getRawType()), s);
    }

    static String toString(GenericArrayType gat) {
        return String.format("%s[]", GenericsUtils.toString(gat.getGenericComponentType()));
    }

    static String toString(WildcardType wt) {
        boolean isSuper = wt.getLowerBounds().length > 0;
        return String.format("? %s %s", isSuper ? "super" : "extends", isSuper ? GenericsUtils.toString(wt.getLowerBounds()) : GenericsUtils.toString(wt.getLowerBounds()));
    }

    static String toString(Type[] types) {
        StringBuilder sb = new StringBuilder();
        for (Type t : types) {
            sb.append(GenericsUtils.toString(t)).append(", ");
        }
        return sb.substring(0, sb.length() - 2);
    }

    private static int getTypeVariableIndex(TypeVariable typeVariable) {
        String typeVarName = typeVariable.getName();
        TypeVariable<?>[] typeParameters = typeVariable.getGenericDeclaration().getTypeParameters();
        for (int typeArgumentIndex = 0; typeArgumentIndex < typeParameters.length; ++typeArgumentIndex) {
            if (!typeParameters[typeArgumentIndex].getName().equals(typeVarName)) continue;
            return typeArgumentIndex;
        }
        throw new RuntimeException(String.format("%s does not have a TypeVariable matching %s", typeVariable.getGenericDeclaration(), typeVariable));
    }
}

