/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.poi.xdgf.usermodel.XDGFRelation;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.iwork.IWorkPackageParser;
import org.apache.tika.parser.pkg.ZipContainerDetectorBase;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class StreamingZipContainerDetector
extends ZipContainerDetectorBase
implements Detector {
    static Map<String, MediaType> OOXML_CONTENT_TYPES = new ConcurrentHashMap<String, MediaType>();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MediaType detect(InputStream is, Metadata metadata) {
        String s;
        HashSet<String> fileNames = new HashSet<String>();
        HashSet<String> directoryNames = new HashSet<String>();
        try (ZipArchiveInputStream zipArchiveInputStream = new ZipArchiveInputStream((InputStream)new CloseShieldInputStream(is));){
            ZipArchiveEntry zae = zipArchiveInputStream.getNextZipEntry();
            while (zae != null) {
                IWorkPackageParser.IWORKDocumentType type;
                String name = zae.getName();
                if (zae.isDirectory()) {
                    directoryNames.add(name);
                    zae = zipArchiveInputStream.getNextZipEntry();
                    continue;
                }
                fileNames.add(name);
                if (name.equals("[Content_Types].xml")) {
                    MediaType mt = StreamingZipContainerDetector.parseOOXMLContentTypes((InputStream)zipArchiveInputStream);
                    if (mt != null) {
                        MediaType mediaType = mt;
                        return mediaType;
                    }
                    MediaType mediaType = TIKA_OOXML;
                    return mediaType;
                }
                if (IWorkPackageParser.IWORK_CONTENT_ENTRIES.contains(name)) {
                    type = IWorkPackageParser.IWORKDocumentType.detectType((InputStream)zipArchiveInputStream);
                    if (type != null) {
                        MediaType mediaType = type.getType();
                        return mediaType;
                    }
                } else if (name.equals("mimetype")) {
                    type = MediaType.parse((String)IOUtils.toString((InputStream)zipArchiveInputStream, (Charset)StandardCharsets.UTF_8));
                    return type;
                }
                zae = zipArchiveInputStream.getNextZipEntry();
            }
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            // empty catch block
        }
        HashSet<String> entryNames = new HashSet<String>(fileNames);
        entryNames.addAll(directoryNames);
        MediaType mt = StreamingZipContainerDetector.detectKmz(fileNames);
        if (mt != null) {
            return mt;
        }
        mt = StreamingZipContainerDetector.detectJar(entryNames);
        if (mt != null) {
            return mt;
        }
        mt = StreamingZipContainerDetector.detectIpa(entryNames);
        if (mt != null) {
            return mt;
        }
        mt = StreamingZipContainerDetector.detectIWorks(entryNames);
        if (mt != null) {
            return mt;
        }
        int hits = 0;
        Iterator iterator = OOXML_HINTS.iterator();
        do {
            if (!iterator.hasNext()) return MediaType.APPLICATION_ZIP;
        } while (!entryNames.contains(s = (String)iterator.next()) || ++hits <= 2);
        return TIKA_OOXML;
    }

    private static MediaType detectIWorks(Set<String> entryNames) {
        if (entryNames.contains("buildVersionHistory.plist")) {
            return MediaType.application((String)"vnd.apple.iwork");
        }
        return null;
    }

    public static Set<String> parseOOXMLRels(InputStream is) {
        RelsHandler relsHandler = new RelsHandler();
        try {
            XMLReaderUtils.parseSAX((InputStream)is, (DefaultHandler)relsHandler, (ParseContext)new ParseContext());
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return relsHandler.rels;
    }

    public static MediaType parseOOXMLContentTypes(InputStream is) {
        ContentTypeHandler contentTypeHandler = new ContentTypeHandler();
        try {
            XMLReaderUtils.parseSAX((InputStream)is, (DefaultHandler)new OfflineContentHandler((ContentHandler)contentTypeHandler), (ParseContext)new ParseContext());
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return contentTypeHandler.mediaType;
    }

    static {
        OOXML_CONTENT_TYPES.put(XWPFRelation.DOCUMENT.getContentType(), DOCX);
        OOXML_CONTENT_TYPES.put(XWPFRelation.MACRO_DOCUMENT.getContentType(), DOCM);
        OOXML_CONTENT_TYPES.put(XWPFRelation.MACRO_TEMPLATE_DOCUMENT.getContentType(), DOTM);
        OOXML_CONTENT_TYPES.put(XWPFRelation.TEMPLATE.getContentType(), DOTX);
        OOXML_CONTENT_TYPES.put(XSSFRelation.WORKBOOK.getContentType(), XLSX);
        OOXML_CONTENT_TYPES.put(XSSFRelation.MACROS_WORKBOOK.getContentType(), XLSM);
        OOXML_CONTENT_TYPES.put(XSSFRelation.XLSB_BINARY_WORKBOOK.getContentType(), XLSB);
        OOXML_CONTENT_TYPES.put(XSSFRelation.TEMPLATE_WORKBOOK.getContentType(), XLTX);
        OOXML_CONTENT_TYPES.put(XSSFRelation.MACRO_TEMPLATE_WORKBOOK.getContentType(), XLTM);
        OOXML_CONTENT_TYPES.put(XSLFRelation.MAIN.getContentType(), PPTX);
        OOXML_CONTENT_TYPES.put(XSLFRelation.MACRO.getContentType(), PPSM);
        OOXML_CONTENT_TYPES.put(XSLFRelation.MACRO_TEMPLATE.getContentType(), POTM);
        OOXML_CONTENT_TYPES.put(XSLFRelation.PRESENTATIONML_TEMPLATE.getContentType(), PPTM);
        OOXML_CONTENT_TYPES.put(XSLFRelation.PRESENTATIONML.getContentType(), PPSX);
        OOXML_CONTENT_TYPES.put(XSLFRelation.PRESENTATION_MACRO.getContentType(), PPTM);
        OOXML_CONTENT_TYPES.put(XSLFRelation.PRESENTATIONML_TEMPLATE.getContentType(), POTX);
        OOXML_CONTENT_TYPES.put(XSLFRelation.THEME_MANAGER.getContentType(), THMX);
        OOXML_CONTENT_TYPES.put("application/vnd.ms-visio.drawing.macroEnabled.main+xml", MediaType.application((String)"vnd.ms-visio.drawing.macroEnabled.12"));
        OOXML_CONTENT_TYPES.put(XDGFRelation.DOCUMENT.getContentType(), MediaType.application((String)"vnd.ms-visio.drawing"));
        OOXML_CONTENT_TYPES.put("application/vnd.ms-visio.stencil.macroEnabled.main+xml", MediaType.application((String)"vnd.ms-visio.stencil.macroenabled.12"));
        OOXML_CONTENT_TYPES.put("application/vnd.ms-visio.stencil.main+xml", MediaType.application((String)"vnd.ms-visio.stencil"));
        OOXML_CONTENT_TYPES.put("application/vnd.ms-visio.template.macroEnabled.main+xml", MediaType.application((String)"vnd.ms-visio.template.macroenabled.12"));
        OOXML_CONTENT_TYPES.put("application/vnd.ms-visio.template.main+xml", MediaType.application((String)"vnd.ms-visio.template"));
        OOXML_CONTENT_TYPES.put("application/vnd.ms-package.xps-fixeddocumentsequence+xml", XPS);
    }

    private static class StoppingEarlyException
    extends SAXException {
        private StoppingEarlyException() {
        }
    }

    private static class ContentTypeHandler
    extends DefaultHandler {
        private MediaType mediaType = null;

        private ContentTypeHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String contentType;
                String attrName = attrs.getLocalName(i);
                if (!attrName.equals("ContentType") || !OOXML_CONTENT_TYPES.containsKey(contentType = attrs.getValue(i))) continue;
                this.mediaType = OOXML_CONTENT_TYPES.get(contentType);
                throw new StoppingEarlyException();
            }
        }
    }

    private static class RelsHandler
    extends DefaultHandler {
        Set<String> rels = new HashSet<String>();
        private MediaType mediaType = null;

        private RelsHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attrs) throws SAXException {
            for (int i = 0; i < attrs.getLength(); ++i) {
                String attrName = attrs.getLocalName(i);
                if (!attrName.equals("Type")) continue;
                String contentType = attrs.getValue(i);
                this.rels.add(contentType);
                if (!OOXML_CONTENT_TYPES.containsKey(contentType)) continue;
                this.mediaType = OOXML_CONTENT_TYPES.get(contentType);
            }
        }
    }
}

