/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.time.Year;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class SingleTypeSerializer<T>
extends SimpleTypeSerializer<T> {
    public static final SingleTypeSerializer<Integer> IntSerializer = new SingleTypeSerializer<Integer>(DataType.INT, ByteBuf::readInt, (v, b) -> b.writeInt(v.intValue()));
    public static final SingleTypeSerializer<Long> LongSerializer = new SingleTypeSerializer<Long>(DataType.LONG, ByteBuf::readLong, (v, b) -> b.writeLong(v.longValue()));
    public static final SingleTypeSerializer<Double> DoubleSerializer = new SingleTypeSerializer<Double>(DataType.DOUBLE, ByteBuf::readDouble, (v, b) -> b.writeDouble(v.doubleValue()));
    public static final SingleTypeSerializer<Float> FloatSerializer = new SingleTypeSerializer<Float>(DataType.FLOAT, ByteBuf::readFloat, (v, b) -> b.writeFloat(v.floatValue()));
    public static final SingleTypeSerializer<Short> ShortSerializer = new SingleTypeSerializer<Short>(DataType.SHORT, ByteBuf::readShort, (v, b) -> b.writeShort((int)v.shortValue()));
    public static final SingleTypeSerializer<Boolean> BooleanSerializer = new SingleTypeSerializer<Boolean>(DataType.BOOLEAN, ByteBuf::readBoolean, (v, b) -> b.writeBoolean(v.booleanValue()));
    public static final SingleTypeSerializer<Byte> ByteSerializer = new SingleTypeSerializer<Byte>(DataType.BYTE, ByteBuf::readByte, (v, b) -> b.writeByte((int)v.byteValue()));
    public static final SingleTypeSerializer<Year> YearSerializer = new SingleTypeSerializer<Year>(DataType.YEAR, bb -> Year.of(bb.readInt()), (v, b) -> b.writeInt(v.getValue()));
    private final Function<ByteBuf, T> readFunc;
    private final BiConsumer<T, ByteBuf> writeFunc;

    private SingleTypeSerializer(DataType dataType, Function<ByteBuf, T> readFunc, BiConsumer<T, ByteBuf> writeFunc) {
        super(dataType);
        this.readFunc = readFunc;
        this.writeFunc = writeFunc;
    }

    @Override
    public T readValue(ByteBuf buffer, GraphBinaryReader context) {
        return this.readFunc.apply(buffer);
    }

    @Override
    protected void writeValue(T value, ByteBuf buffer, GraphBinaryWriter context) {
        this.writeFunc.accept(value, buffer);
    }
}

