/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor;

import java.util.HashMap;
import org.apache.tomcat.util.descriptor.LocalResolver;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.xml.sax.EntityResolver;

public class DigesterFactory {
    public static final LocalResolver SERVLET_RESOLVER;

    public static Digester newDigester(boolean xmlValidation, boolean xmlNamespaceAware, RuleSet rule) {
        Digester digester = new Digester();
        digester.setNamespaceAware(xmlNamespaceAware);
        digester.setValidating(xmlValidation);
        digester.setUseContextClassLoader(true);
        digester.setEntityResolver((EntityResolver)SERVLET_RESOLVER);
        if (rule != null) {
            digester.addRuleSet(rule);
        }
        return digester;
    }

    static {
        HashMap<String, String> publicIds = new HashMap<String, String>();
        HashMap<String, String> systemIds = new HashMap<String, String>();
        publicIds.put("-//W3C//DTD XMLSCHEMA 200102//EN", "/javax/servlet/resources/XMLSchema.dtd");
        publicIds.put("datatypes", "/javax/servlet/resources/datatypes.dtd");
        systemIds.put("http://www.w3.org/2001/xml.xsd", "/javax/servlet/resources/xml.xsd");
        publicIds.put("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "/javax/servlet/resources/web-app_2_2.dtd");
        publicIds.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", "/javax/servlet/resources/web-jsptaglibrary_1_1.dtd");
        publicIds.put("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "/javax/servlet/resources/web-app_2_3.dtd");
        publicIds.put("-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN", "/javax/servlet/resources/web-jsptaglibrary_1_2.dtd");
        systemIds.put("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", "/javax/servlet/resources/j2ee_web_services_client_1_1.xsd");
        systemIds.put("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", "/javax/servlet/resources/web-app_2_4.xsd");
        systemIds.put("http://java.sun.com/xml/ns/j2ee/web-jsptaglibrary_2_0.xsd", "/javax/servlet/resources/web-jsptaglibrary_2_0.xsd");
        systemIds.put("http://java.sun.com/xml/ns/javaee/web-app_2_5.xsd", "/javax/servlet/resources/web-app_2_5.xsd");
        systemIds.put("http://java.sun.com/xml/ns/javaee/web-jsptaglibrary_2_1.xsd", "/javax/servlet/resources/web-jsptaglibrary_2_1.xsd");
        systemIds.put("http://java.sun.com/xml/ns/javaee/web-app_3_0.xsd", "/javax/servlet/resources/web-app_3_0.xsd");
        systemIds.put("http://java.sun.com/xml/ns/javaee/web-fragment_3_0.xsd", "/javax/servlet/resources/web-fragment_3_0.xsd");
        systemIds.put("http://xmlns.jcp.org/xml/ns/javaee/web-app_3_1.xsd", "/javax/servlet/resources/web-app_3_1.xsd");
        systemIds.put("http://xmlns.jcp.org/xml/ns/javaee/web-fragment_3_1.xsd", "/javax/servlet/resources/web-fragment_3_1.xsd");
        SERVLET_RESOLVER = new LocalResolver(DigesterFactory.class, publicIds, systemIds);
    }
}

