/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class LocalResolver
implements EntityResolver2 {
    private final Class<?> base;
    private final Map<String, String> publicIds;
    private final Map<String, String> systemIds;

    public LocalResolver(Class<?> base, Map<String, String> publicIds, Map<String, String> systemIds) {
        this.base = base;
        this.publicIds = publicIds;
        this.systemIds = systemIds;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        String resolved = this.resolve(publicId, systemId, baseURI);
        if (resolved == null) {
            return null;
        }
        URL url = this.base.getResource(resolved);
        if (url != null) {
            resolved = url.toExternalForm();
        }
        InputSource is = new InputSource(resolved);
        is.setPublicId(publicId);
        return is;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    private String resolve(String publicId, String systemId, String baseURI) {
        String resolved = this.publicIds.get(publicId);
        if (resolved != null) {
            return resolved;
        }
        if (systemId == null) {
            return null;
        }
        resolved = this.systemIds.get(systemId = LocalResolver.resolve(baseURI, systemId));
        if (resolved != null) {
            return resolved;
        }
        return systemId;
    }

    private static String resolve(String baseURI, String systemId) {
        try {
            if (baseURI == null) {
                return systemId;
            }
            URI systemUri = new URI(systemId);
            if (systemUri.isAbsolute()) {
                return systemId;
            }
            return new URI(baseURI).resolve(systemUri).toString();
        }
        catch (URISyntaxException e) {
            return systemId;
        }
    }
}

