/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.swizzle.rss;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.codehaus.swizzle.rss.RssItem;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class RssFeed {
    private String feed;
    private Collection rssItems;

    public RssFeed(String feed) throws Exception {
        this.feed = feed;
        this.rssItems = this.downloadItems();
    }

    public Collection getItems() throws Exception {
        return this.rssItems;
    }

    public void refresh() throws Exception {
        this.downloadItems();
    }

    private Collection downloadItems() throws Exception {
        Vector items = new Vector();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.marshal(db.parse(this.feed), items);
        }
        catch (Exception e) {
            throw new Exception("Unable to process feed " + this.feed, e);
        }
        return items;
    }

    private void marshal(Node node, List items) throws Exception {
        Node parent = node.getParentNode();
        String name = node.getNodeName();
        if ("link".equals(name) && parent.getNodeName().matches("channel|item")) {
            String type = parent.getNodeName();
            String title = this.valueOf(node.getPreviousSibling().getPreviousSibling());
            String link = this.valueOf(node);
            String desc = this.valueOf(node.getNextSibling().getNextSibling());
            items.add(new RssItem(type, title, link, desc));
        }
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            this.marshal(nodes.item(i), items);
        }
    }

    private String valueOf(Node node) throws Exception {
        return ((Text)node.getFirstChild()).getData();
    }
}

