/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;

public class JweCompactConsumer {
    protected static final Logger LOG = LogUtils.getL7dLogger(JweCompactConsumer.class);
    private JweDecryptionInput jweDecryptionInput;

    public JweCompactConsumer(String jweContent) {
        String[] parts = JoseUtils.getCompactParts(jweContent);
        if (parts.length != 5) {
            LOG.warning("5 JWE parts are expected");
            throw new JweException(JweException.Error.INVALID_COMPACT_JWE);
        }
        try {
            String headersJson = new String(Base64UrlUtility.decode((String)parts[0]));
            byte[] encryptedCEK = Base64UrlUtility.decode((String)parts[1]);
            byte[] initVector = Base64UrlUtility.decode((String)parts[2]);
            byte[] encryptedContent = Base64UrlUtility.decode((String)parts[3]);
            byte[] authTag = Base64UrlUtility.decode((String)parts[4]);
            JsonMapObjectReaderWriter reader = new JsonMapObjectReaderWriter();
            JsonMapObject joseHeaders = reader.fromJsonToJsonObject(headersJson);
            if (joseHeaders.getUpdateCount() != null) {
                LOG.warning("Duplicate headers have been detected");
                throw new JweException(JweException.Error.INVALID_COMPACT_JWE);
            }
            JweHeaders jweHeaders = new JweHeaders(joseHeaders.asMap());
            this.jweDecryptionInput = new JweDecryptionInput(encryptedCEK, initVector, encryptedContent, authTag, null, headersJson, jweHeaders);
        }
        catch (Base64Exception ex) {
            LOG.warning("Incorrect Base64 URL encoding");
            throw new JweException(JweException.Error.INVALID_COMPACT_JWE);
        }
    }

    public String getDecodedJsonHeaders() {
        return this.jweDecryptionInput.getDecodedJsonHeaders();
    }

    public JweHeaders getJweHeaders() {
        return this.jweDecryptionInput.getJweHeaders();
    }

    public byte[] getEncryptedContentEncryptionKey() {
        return this.jweDecryptionInput.getEncryptedCEK();
    }

    public byte[] getContentDecryptionCipherInitVector() {
        return this.jweDecryptionInput.getInitVector();
    }

    public byte[] getContentEncryptionCipherAAD() {
        return JweHeaders.toCipherAdditionalAuthData(this.jweDecryptionInput.getDecodedJsonHeaders());
    }

    public byte[] getEncryptionAuthenticationTag() {
        return this.jweDecryptionInput.getAuthTag();
    }

    public byte[] getEncryptedContent() {
        return this.jweDecryptionInput.getEncryptedContent();
    }

    public byte[] getEncryptedContentWithAuthTag() {
        return JweCompactConsumer.getCipherWithAuthTag(this.getEncryptedContent(), this.getEncryptionAuthenticationTag());
    }

    public JweDecryptionInput getJweDecryptionInput() {
        return this.jweDecryptionInput;
    }

    public static byte[] getCipherWithAuthTag(byte[] cipher, byte[] authTag) {
        byte[] encryptedContentWithTag = new byte[cipher.length + authTag.length];
        System.arraycopy(cipher, 0, encryptedContentWithTag, 0, cipher.length);
        System.arraycopy(authTag, 0, encryptedContentWithTag, cipher.length, authTag.length);
        return encryptedContentWithTag;
    }

    public byte[] getDecryptedContent(JweDecryptionProvider decryption) {
        return decryption.decrypt(this.jweDecryptionInput);
    }

    public String getDecryptedContentText(JweDecryptionProvider decryption) {
        return new String(this.getDecryptedContent(decryption), StandardCharsets.UTF_8);
    }

    public boolean validateCriticalHeaders() {
        return JweUtils.validateCriticalHeaders(this.getJweHeaders());
    }
}

