/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.util.LinkedHashMap;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.json.basic.JsonObject;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public class JweJsonEncryptionEntry
implements JsonObject {
    private JweHeaders unprotectedHeader;
    private String encodedEncryptedKey;

    public JweJsonEncryptionEntry(String encodedEncryptedKey) {
        this(null, encodedEncryptedKey);
    }

    public JweJsonEncryptionEntry(JweHeaders unprotectedHeader, String encodedEncryptedKey) {
        this.unprotectedHeader = unprotectedHeader;
        this.encodedEncryptedKey = encodedEncryptedKey;
    }

    public JweHeaders getUnprotectedHeader() {
        return this.unprotectedHeader;
    }

    public String getEncodedEncryptedKey() {
        return this.encodedEncryptedKey;
    }

    public byte[] getEncryptedKey() {
        return this.encodedEncryptedKey == null ? null : JoseUtils.decode(this.encodedEncryptedKey);
    }

    public String toJson() {
        JsonMapObjectReaderWriter jsonWriter = new JsonMapObjectReaderWriter();
        LinkedHashMap<String, Object> recipientsEntry = new LinkedHashMap<String, Object>();
        if (this.unprotectedHeader != null && !this.unprotectedHeader.asMap().isEmpty()) {
            recipientsEntry.put("header", (Object)this.unprotectedHeader);
        }
        if (this.encodedEncryptedKey != null) {
            recipientsEntry.put("encrypted_key", this.encodedEncryptedKey);
        }
        return jsonWriter.toJson(recipientsEntry);
    }

    public String toString() {
        return this.toJson();
    }
}

