/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import org.apache.openejb.client.EJBHomeProxy;
import org.apache.openejb.client.InterfaceType;
import org.apache.openejb.client.ProtocolMetaData;

public class EJBMetaDataImpl
implements EJBMetaData,
Externalizable {
    private static final long serialVersionUID = -858340852654709679L;
    public static final byte STATEFUL = 6;
    public static final byte STATELESS = 7;
    public static final byte BMP_ENTITY = 8;
    public static final byte CMP_ENTITY = 9;
    public static final byte SINGLETON = 10;
    protected transient byte type;
    protected transient String deploymentID;
    protected transient int deploymentCode;
    protected transient Class homeClass;
    protected transient Class remoteClass;
    protected final transient List<Class> businessClasses = new ArrayList<Class>();
    protected transient Class mainInterface;
    protected final transient Set<String> asynchronousMethods = new HashSet<String>();
    protected final transient Properties properties = new Properties();
    protected transient Class keyClass;
    protected transient EJBHome ejbHomeProxy;
    protected transient InterfaceType interfaceType;
    protected transient Object primaryKey;
    private transient ProtocolMetaData metaData;

    public EJBMetaDataImpl() {
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, String typeOfBean, InterfaceType interfaceType, List<Class> businessInterfaces, Set<String> asynchronousMethodSignatures) {
        this.interfaceType = interfaceType;
        if ("STATEFUL".equalsIgnoreCase(typeOfBean)) {
            this.type = (byte)6;
        } else if ("STATELESS".equalsIgnoreCase(typeOfBean)) {
            this.type = (byte)7;
        } else if ("SINGLETON".equalsIgnoreCase(typeOfBean)) {
            this.type = (byte)10;
        } else if ("BMP_ENTITY".equalsIgnoreCase(typeOfBean)) {
            this.type = (byte)8;
        } else if ("CMP_ENTITY".equalsIgnoreCase(typeOfBean)) {
            this.type = (byte)9;
        }
        this.homeClass = homeInterface;
        this.remoteClass = remoteInterface;
        if (businessInterfaces != null) {
            this.businessClasses.addAll(businessInterfaces);
        }
        if (asynchronousMethodSignatures != null) {
            this.asynchronousMethods.addAll(asynchronousMethodSignatures);
        }
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, Class primaryKeyClass, String typeOfBean, InterfaceType interfaceType, List<Class> businessInterfaces, Set<String> asynchronousMethodSignatures) {
        this(homeInterface, remoteInterface, typeOfBean, interfaceType, businessInterfaces, asynchronousMethodSignatures);
        if (this.type == 9 || this.type == 8) {
            this.keyClass = primaryKeyClass;
        }
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, Class primaryKeyClass, String typeOfBean, String deploymentID, InterfaceType interfaceType, List<Class> businessInterfaces, Set<String> asynchronousMethodSignatures) {
        this(homeInterface, remoteInterface, primaryKeyClass, typeOfBean, interfaceType, businessInterfaces, asynchronousMethodSignatures);
        this.deploymentID = deploymentID;
    }

    public EJBMetaDataImpl(Class homeInterface, Class remoteInterface, Class primaryKeyClass, String typeOfBean, String deploymentID, int deploymentCode, InterfaceType interfaceType, List<Class> businessInterfaces, Set<String> asynchronousMethodSignatures) {
        this(homeInterface, remoteInterface, primaryKeyClass, typeOfBean, deploymentID, interfaceType, businessInterfaces, asynchronousMethodSignatures);
        this.deploymentCode = deploymentCode;
    }

    public void setMetaData(ProtocolMetaData metaData) {
        this.metaData = metaData;
    }

    public Class getPrimaryKeyClass() {
        if (this.type != 8 && this.type != 9) {
            throw new UnsupportedOperationException();
        }
        return this.keyClass;
    }

    public EJBHome getEJBHome() {
        return this.ejbHomeProxy;
    }

    public Class getHomeInterfaceClass() {
        return this.homeClass;
    }

    public boolean isStatelessSession() {
        return this.type == 7;
    }

    public boolean isStatefulSession() {
        return this.type == 6;
    }

    public boolean isSingletonSession() {
        return this.type == 10;
    }

    public Class getRemoteInterfaceClass() {
        return this.remoteClass;
    }

    public boolean isSession() {
        return this.type == 6 || this.type == 7 || this.type == 10;
    }

    public boolean isAsynchronousMethod(Method method) {
        if (this.asynchronousMethods.size() == 0) {
            return false;
        }
        return this.asynchronousMethods.contains(this.generateMethodSignature(method));
    }

    public void addAsynchronousMethod(Method method) {
        this.asynchronousMethods.add(this.generateMethodSignature(method));
    }

    protected void setEJBHomeProxy(EJBHomeProxy home) {
        this.ejbHomeProxy = home;
    }

    public String getDeploymentID() {
        return this.deploymentID;
    }

    public Class getHomeClass() {
        return this.homeClass;
    }

    public List<Class> getBusinessClasses() {
        return this.businessClasses;
    }

    public Class getMainInterface() {
        return this.mainInterface;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(Object primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(3);
        out.writeObject(this.homeClass);
        out.writeObject(this.remoteClass);
        out.writeObject(this.keyClass);
        out.writeObject(this.ejbHomeProxy);
        out.writeByte(this.type);
        out.writeUTF(this.deploymentID);
        out.writeShort((short)this.deploymentCode);
        out.writeShort((short)this.businessClasses.size());
        for (Class clazz : this.businessClasses) {
            out.writeObject(clazz);
        }
        if (this.businessClasses.size() > 0) {
            out.writeObject(this.primaryKey);
        }
        out.writeObject(this.mainInterface);
        out.writeByte(this.interfaceType.ordinal());
        out.writeInt(this.asynchronousMethods.size());
        for (String asynchronousMethod : this.asynchronousMethods) {
            out.writeObject(asynchronousMethod);
        }
        if (this.properties.size() == 0) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            ByteArrayOutputStream tmp = new ByteArrayOutputStream();
            this.properties.store(tmp, "");
            tmp.close();
            byte[] bytes = tmp.toByteArray();
            int length = bytes.length;
            out.writeInt(length);
            out.write(bytes);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        byte version = in.readByte();
        this.homeClass = (Class)in.readObject();
        this.remoteClass = (Class)in.readObject();
        this.keyClass = (Class)in.readObject();
        this.ejbHomeProxy = (EJBHome)in.readObject();
        this.type = in.readByte();
        this.deploymentID = in.readUTF();
        this.deploymentCode = in.readShort();
        for (i = in.readShort(); i > 0; --i) {
            this.businessClasses.add((Class)in.readObject());
        }
        if (this.businessClasses.size() > 0) {
            this.primaryKey = in.readObject();
        }
        if (version > 2) {
            this.mainInterface = (Class)in.readObject();
        }
        if (version > 1) {
            byte typeIndex = in.readByte();
            this.interfaceType = InterfaceType.values()[typeIndex];
        }
        for (i = in.readInt(); i > 0; --i) {
            this.asynchronousMethods.add((String)in.readObject());
        }
        boolean hasProperties = in.readBoolean();
        if (hasProperties) {
            int bufferLength = in.readInt();
            byte[] buffer = new byte[bufferLength];
            in.read(buffer);
            ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
            this.properties.load(bais);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        switch (this.type) {
            case 6: {
                sb.append("STATEFUL:");
                break;
            }
            case 7: {
                sb.append("STATELESS:");
                break;
            }
            case 10: {
                sb.append("SINGLETON:");
                break;
            }
            case 9: {
                sb.append("CMP_ENTITY:");
                break;
            }
            case 8: {
                sb.append("BMP_ENTITY:");
            }
        }
        sb.append(this.deploymentID).append(":");
        if (this.homeClass != null) {
            sb.append(this.homeClass.getName());
        } else if (this.businessClasses.size() != 0) {
            for (Class clazz : this.businessClasses) {
                sb.append(clazz.getName()).append(',');
            }
            sb.deleteCharAt(sb.length() - 1);
            if (this.type == 6) {
                sb.append(":").append(this.primaryKey);
            }
        }
        return sb.toString();
    }

    public void loadProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key;
            if (!(entry.getKey() instanceof String) || !(key = (String)entry.getKey()).startsWith("openejb.client.")) continue;
            this.properties.put(key, entry.getValue());
        }
    }

    private String generateMethodSignature(Method method) {
        StringBuilder buffer = new StringBuilder(method.getName());
        for (Class<?> parameterType : method.getParameterTypes()) {
            buffer.append(parameterType.getName());
        }
        return buffer.toString();
    }
}

