/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.WriterInterceptor;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ReaderInterceptorMBR;
import org.apache.cxf.jaxrs.impl.WriterInterceptorMBW;
import org.apache.cxf.jaxrs.impl.tl.ThreadLocalProxy;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.FilterProviderInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.BinaryDataProvider;
import org.apache.cxf.jaxrs.provider.DataSourceProvider;
import org.apache.cxf.jaxrs.provider.FormEncodingProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementTypedProvider;
import org.apache.cxf.jaxrs.provider.MultipartProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.provider.ProviderCache;
import org.apache.cxf.jaxrs.provider.SourceProvider;
import org.apache.cxf.jaxrs.provider.StringTextProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public abstract class ProviderFactory {
    public static final String DEFAULT_FILTER_NAME_BINDING = "org.apache.cxf.filter.binding";
    public static final String PROVIDER_SELECTION_PROPERTY_CHANGED = "provider.selection.property.changed";
    public static final String ACTIVE_JAXRS_PROVIDER_KEY = "active.jaxrs.provider";
    protected static final String SERVER_FACTORY_NAME = "org.apache.cxf.jaxrs.provider.ServerProviderFactory";
    protected static final String CLIENT_FACTORY_NAME = "org.apache.cxf.jaxrs.client.ClientProviderFactory";
    protected static final String IGNORE_TYPE_VARIABLES = "org.apache.cxf.jaxrs.providers.ignore.typevars";
    private static final Logger LOG = LogUtils.getL7dLogger(ProviderFactory.class);
    private static final String JAXB_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.JAXBElementProvider";
    private static final String JSON_PROVIDER_NAME = "org.apache.cxf.jaxrs.provider.json.JSONProvider";
    private static final String BUS_PROVIDERS_ALL = "org.apache.cxf.jaxrs.bus.providers";
    private static final String PROVIDER_CACHE_ALLOWED = "org.apache.cxf.jaxrs.provider.cache.allowed";
    private static final String PROVIDER_CACHE_CHECK_ALL = "org.apache.cxf.jaxrs.provider.cache.checkAllCandidates";
    protected Map<NameKey, ProviderInfo<ReaderInterceptor>> readerInterceptors = new NameKeyMap<ProviderInfo<ReaderInterceptor>>(true);
    protected Map<NameKey, ProviderInfo<WriterInterceptor>> writerInterceptors = new NameKeyMap<ProviderInfo<WriterInterceptor>>(true);
    private List<ProviderInfo<MessageBodyReader<?>>> messageReaders = new ArrayList();
    private List<ProviderInfo<MessageBodyWriter<?>>> messageWriters = new ArrayList();
    private List<ProviderInfo<ContextResolver<?>>> contextResolvers = new ArrayList(1);
    private List<ProviderInfo<ContextProvider<?>>> contextProviders = new ArrayList(1);
    private List<ProviderInfo<ParamConverterProvider>> paramConverters = new ArrayList<ProviderInfo<ParamConverterProvider>>(1);
    private boolean paramConverterContextsAvailable;
    private Collection<ProviderInfo<?>> injectedProviders = new HashSet();
    private Bus bus;
    private Comparator<?> providerComparator;
    private ProviderCache providerCache;

    protected ProviderFactory(Bus bus) {
        this.bus = bus;
        this.providerCache = ProviderFactory.initCache(bus);
    }

    public Bus getBus() {
        return this.bus;
    }

    protected static ProviderCache initCache(Bus theBus) {
        boolean allowed;
        Object allowProp = theBus.getProperty(PROVIDER_CACHE_ALLOWED);
        boolean bl = allowed = allowProp == null || PropertyUtils.isTrue((Object)allowProp);
        if (!allowed) {
            return null;
        }
        boolean checkAll = PropertyUtils.isTrue((Object)theBus.getProperty(PROVIDER_CACHE_CHECK_ALL));
        return new ProviderCache(checkAll);
    }

    protected static void initFactory(ProviderFactory factory) {
        factory.setProviders(false, false, new BinaryDataProvider(), new SourceProvider(), new DataSourceProvider(), new FormEncodingProvider(), new StringTextProvider(), new PrimitiveTextProvider(), new JAXBElementProvider(), new JAXBElementTypedProvider(), new MultipartProvider());
        Object prop = factory.getBus().getProperty("skip.default.json.provider.registration");
        if (!PropertyUtils.isTrue((Object)prop)) {
            factory.setProviders(false, false, ProviderFactory.createProvider(JSON_PROVIDER_NAME, factory.getBus()));
        }
    }

    protected static Object createProvider(String className, Bus bus) {
        try {
            Class cls = ClassLoaderUtils.loadClass((String)className, ProviderFactory.class);
            for (Constructor<?> c : cls.getConstructors()) {
                if (c.getParameterTypes().length != 1 || c.getParameterTypes()[0] != Bus.class) continue;
                return c.newInstance(bus);
            }
            return cls.newInstance();
        }
        catch (Throwable ex) {
            String message = "Problem with creating the default provider " + className;
            message = ex.getMessage() != null ? message + ": " + ex.getMessage() : message + ", exception class : " + ex.getClass().getName();
            LOG.fine(message);
            return null;
        }
    }

    public abstract Configuration getConfiguration(Message var1);

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m) {
        boolean isRequestor = MessageUtils.isRequestor((Message)m);
        Message requestMessage = isRequestor ? m.getExchange().getOutMessage() : m.getExchange().getInMessage();
        Message responseMessage = isRequestor ? m.getExchange().getInMessage() : m.getExchange().getOutMessage();
        Object ctProperty = null;
        ctProperty = responseMessage != null ? responseMessage.get((Object)"Content-Type") : requestMessage.get((Object)"Content-Type");
        MediaType mt = ctProperty != null ? JAXRSUtils.toMediaType(ctProperty.toString()) : MediaType.WILDCARD_TYPE;
        return this.createContextResolver(contextType, m, mt);
    }

    public <T> ContextResolver<T> createContextResolver(Type contextType, Message m, MediaType type) {
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            return null;
        }
        LinkedList candidates = new LinkedList();
        for (ProviderInfo<ContextResolver<?>> cr : this.contextResolvers) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                List<MediaType> mTypes;
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls) || !JAXRSUtils.doMimeTypesIntersect(mTypes = JAXRSUtils.getProduceTypes(cr.getProvider().getClass().getAnnotation(Produces.class)), type)) continue;
                this.injectContextValues(cr, m);
                candidates.add(cr.getProvider());
            }
        }
        if (candidates.size() == 0) {
            return null;
        }
        if (candidates.size() == 1) {
            return (ContextResolver)candidates.get(0);
        }
        Collections.sort(candidates, new ClassComparator());
        return new ContextResolverProxy(candidates);
    }

    public <T> ContextProvider<T> createContextProvider(Type contextType, Message m) {
        Class<?> contextCls = InjectionUtils.getActualType(contextType);
        if (contextCls == null) {
            return null;
        }
        for (ProviderInfo<ContextProvider<?>> cr : this.contextProviders) {
            Type[] types;
            for (Type t : types = cr.getProvider().getClass().getGenericInterfaces()) {
                Class<?> argCls;
                ParameterizedType pt;
                Type[] args;
                if (!(t instanceof ParameterizedType) || (args = (pt = (ParameterizedType)t).getActualTypeArguments()).length <= 0 || (argCls = InjectionUtils.getActualType(args[0])) == null || !argCls.isAssignableFrom(contextCls)) continue;
                return cr.getProvider();
            }
        }
        return null;
    }

    public <T> ParamConverter<T> createParameterHandler(Class<T> paramType, Type genericType, Annotation[] anns, Message m) {
        anns = anns != null ? anns : new Annotation[]{};
        for (ProviderInfo<ParamConverterProvider> pi : this.paramConverters) {
            this.injectContextValues(pi, m);
            ParamConverter converter = pi.getProvider().getConverter(paramType, genericType, anns);
            if (converter != null) {
                return converter;
            }
            pi.clearThreadLocalProxies();
        }
        return null;
    }

    protected <T> boolean handleMapper(ProviderInfo<T> em, Class<?> expectedType, Message m, Class<?> providerClass, boolean injectContext) {
        return this.handleMapper(em, expectedType, m, providerClass, null, injectContext);
    }

    protected <T> boolean handleMapper(ProviderInfo<T> em, Class<?> expectedType, Message m, Class<?> providerClass, Class<?> commonBaseClass, boolean injectContext) {
        Class mapperClass = ClassHelper.getRealClass((Bus)this.bus, em.getProvider());
        Type[] types = null;
        types = m != null && MessageUtils.isTrue((Object)m.getContextualProperty(IGNORE_TYPE_VARIABLES)) ? new Type[]{mapperClass} : ProviderFactory.getGenericInterfaces(mapperClass, expectedType, commonBaseClass);
        for (Type t : types) {
            if (t instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)t;
                Type[] args = pt.getActualTypeArguments();
                for (int i = 0; i < args.length; ++i) {
                    Type arg = args[i];
                    if (arg instanceof TypeVariable) {
                        TypeVariable var = (TypeVariable)arg;
                        Type[] bounds = var.getBounds();
                        boolean isResolved = false;
                        for (int j = 0; j < bounds.length; ++j) {
                            Class<?> cls = InjectionUtils.getRawType(bounds[j]);
                            if (cls == null || cls != Object.class && !cls.isAssignableFrom(expectedType)) continue;
                            isResolved = true;
                            break;
                        }
                        if (!isResolved) {
                            return false;
                        }
                        if (injectContext) {
                            this.injectContextValues(em, m);
                        }
                        return true;
                    }
                    Class<?> actualClass = InjectionUtils.getRawType(arg);
                    if (actualClass == null) continue;
                    if (expectedType.isArray() && !actualClass.isArray()) {
                        expectedType = expectedType.getComponentType();
                    }
                    if (!actualClass.isAssignableFrom(expectedType) && actualClass != Object.class) continue;
                    if (injectContext) {
                        this.injectContextValues(em, m);
                    }
                    return true;
                }
                continue;
            }
            if (!(t instanceof Class) || !providerClass.isAssignableFrom((Class)t)) continue;
            if (injectContext) {
                this.injectContextValues(em, m);
            }
            return true;
        }
        return false;
    }

    public <T> List<ReaderInterceptor> createMessageBodyReaderInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, boolean checkMbrNow, Set<String> names) {
        MessageBodyReader<T> mr = !checkMbrNow ? null : this.createMessageBodyReader(bodyType, parameterType, parameterAnnotations, mediaType, m);
        int size = this.readerInterceptors.size();
        if (mr != null || size > 0) {
            ReaderInterceptorMBR mbrReader = new ReaderInterceptorMBR(mr, m.getExchange().getInMessage());
            List<ReaderInterceptor> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<ReaderInterceptor>(size + 1);
                List<ProviderInfo<T>> readers = ProviderFactory.getBoundFilters(this.readerInterceptors, names);
                for (ProviderInfo<T> p : readers) {
                    this.injectContextValues(p, m);
                    interceptors.add((ReaderInterceptor)p.getProvider());
                }
                interceptors.add(mbrReader);
            } else {
                interceptors = Collections.singletonList(mbrReader);
            }
            return interceptors;
        }
        return null;
    }

    public <T> List<WriterInterceptor> createMessageBodyWriterInterceptor(Class<T> bodyType, Type parameterType, Annotation[] parameterAnnotations, MediaType mediaType, Message m, Set<String> names) {
        MessageBodyWriter<T> mw = this.createMessageBodyWriter(bodyType, parameterType, parameterAnnotations, mediaType, m);
        int size = this.writerInterceptors.size();
        if (mw != null || size > 0) {
            WriterInterceptorMBW mbwWriter = new WriterInterceptorMBW(mw, m);
            List<WriterInterceptor> interceptors = null;
            if (size > 0) {
                interceptors = new ArrayList<WriterInterceptor>(size + 1);
                List<ProviderInfo<T>> writers = ProviderFactory.getBoundFilters(this.writerInterceptors, names);
                for (ProviderInfo<T> p : writers) {
                    this.injectContextValues(p, m);
                    interceptors.add((WriterInterceptor)p.getProvider());
                }
                interceptors.add(mbwWriter);
            } else {
                interceptors = Collections.singletonList(mbwWriter);
            }
            return interceptors;
        }
        return null;
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        if (this.providerCache != null) {
            for (ProviderInfo<MessageBodyReader<?>> ep : this.providerCache.getReaders(type, mediaType)) {
                if (!this.isReadable(ep, type, genericType, annotations, mediaType, m)) continue;
                return ep.getProvider();
            }
        }
        boolean checkAll = this.providerCache != null && this.providerCache.isCheckAllCandidates();
        LinkedList allCandidates = checkAll ? new LinkedList() : null;
        MessageBodyReader<?> selectedReader = null;
        for (ProviderInfo<MessageBodyReader<?>> ep : this.messageReaders) {
            if (!this.matchesReaderMediaTypes(ep, mediaType) || !this.handleMapper(ep, type, m, MessageBodyReader.class, false)) continue;
            if (checkAll) {
                allCandidates.add(ep);
            } else if (this.providerCache != null && this.providerCache.getReaders(type, mediaType).isEmpty()) {
                this.providerCache.putReaders(type, mediaType, Collections.singletonList(ep));
            }
            if (selectedReader != null || !this.isReadable(ep, type, genericType, annotations, mediaType, m)) continue;
            selectedReader = ep.getProvider();
            if (checkAll) continue;
            return selectedReader;
        }
        if (checkAll) {
            this.providerCache.putReaders(type, mediaType, allCandidates);
        }
        return selectedReader;
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        if (this.providerCache != null) {
            for (ProviderInfo<MessageBodyWriter<?>> ep : this.providerCache.getWriters(type, mediaType)) {
                if (!this.isWriteable(ep, type, genericType, annotations, mediaType, m)) continue;
                return ep.getProvider();
            }
        }
        boolean checkAll = this.providerCache != null && this.providerCache.isCheckAllCandidates();
        LinkedList allCandidates = checkAll ? new LinkedList() : null;
        MessageBodyWriter<?> selectedWriter = null;
        for (ProviderInfo<MessageBodyWriter<?>> ep : this.messageWriters) {
            if (!this.matchesWriterMediaTypes(ep, mediaType) || !this.handleMapper(ep, type, m, MessageBodyWriter.class, false)) continue;
            if (checkAll) {
                allCandidates.add(ep);
            } else if (this.providerCache != null && this.providerCache.getWriters(type, mediaType).isEmpty()) {
                this.providerCache.putWriters(type, mediaType, Collections.singletonList(ep));
            }
            if (selectedWriter != null || !this.isWriteable(ep, type, genericType, annotations, mediaType, m)) continue;
            selectedWriter = ep.getProvider();
            if (checkAll) continue;
            return selectedWriter;
        }
        if (checkAll) {
            this.providerCache.putWriters(type, mediaType, allCandidates);
        }
        return selectedWriter;
    }

    protected void setBusProviders() {
        LinkedList<Object> extensions = new LinkedList<Object>();
        this.addBusExtension(extensions, MessageBodyReader.class, MessageBodyWriter.class, ExceptionMapper.class);
        if (!extensions.isEmpty()) {
            this.setProviders(true, true, extensions.toArray());
        }
    }

    private void addBusExtension(List<Object> extensions, Class<?> ... extClasses) {
        for (Class<?> extClass : extClasses) {
            Object ext = this.bus.getProperty(extClass.getName());
            if (!extClass.isInstance(ext)) continue;
            extensions.add(ext);
        }
        Object allProp = this.bus.getProperty(BUS_PROVIDERS_ALL);
        if (allProp instanceof List) {
            List all = (List)allProp;
            extensions.addAll(all);
        }
    }

    protected abstract void setProviders(boolean var1, boolean var2, Object ... var3);

    protected void setCommonProviders(List<ProviderInfo<? extends Object>> theProviders) {
        LinkedList readInts = new LinkedList();
        LinkedList writeInts = new LinkedList();
        for (ProviderInfo<? extends Object> provider : theProviders) {
            Class providerCls;
            if (ProviderFactory.filterContractSupported(provider, providerCls = ClassHelper.getRealClass((Bus)this.bus, (Object)provider.getProvider()), MessageBodyReader.class)) {
                this.addProviderToList(this.messageReaders, provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, MessageBodyWriter.class)) {
                this.addProviderToList(this.messageWriters, provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, ContextResolver.class)) {
                this.addProviderToList(this.contextResolvers, provider);
            }
            if (ContextProvider.class.isAssignableFrom(providerCls)) {
                this.addProviderToList(this.contextProviders, provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, ReaderInterceptor.class)) {
                readInts.add(provider);
            }
            if (ProviderFactory.filterContractSupported(provider, providerCls, WriterInterceptor.class)) {
                writeInts.add(provider);
            }
            if (!ProviderFactory.filterContractSupported(provider, providerCls, ParamConverterProvider.class)) continue;
            this.paramConverters.add(provider);
        }
        this.sortReaders();
        this.sortWriters();
        this.sortContextResolvers();
        ProviderFactory.mapInterceptorFilters(this.readerInterceptors, readInts, ReaderInterceptor.class, true);
        ProviderFactory.mapInterceptorFilters(this.writerInterceptors, writeInts, WriterInterceptor.class, true);
        this.injectContextProxies(this.messageReaders, this.messageWriters, this.contextResolvers, this.paramConverters, this.readerInterceptors.values(), this.writerInterceptors.values());
        this.checkParamConverterContexts();
    }

    private void checkParamConverterContexts() {
        for (ProviderInfo<ParamConverterProvider> pi : this.paramConverters) {
            if (!pi.contextsAvailable()) continue;
            this.paramConverterContextsAvailable = true;
        }
    }

    public boolean isParamConverterContextsAvailable() {
        return this.paramConverterContextsAvailable;
    }

    protected void injectContextValues(ProviderInfo<?> pi, Message m) {
        if (m != null) {
            InjectionUtils.injectContexts(pi.getProvider(), pi, m);
        }
    }

    protected void addProviderToList(List<?> list, ProviderInfo<?> provider) {
        List list2 = CastUtils.cast(list);
        for (ProviderInfo pi : list2) {
            if (pi.getProvider() != provider.getProvider()) continue;
            return;
        }
        list2.add(provider);
    }

    protected void injectContextProxies(Collection<?> ... providerLists) {
        for (Collection<?> list : providerLists) {
            Collection l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                this.injectContextProxiesIntoProvider(pi);
            }
        }
    }

    protected void injectContextProxiesIntoProvider(ProviderInfo<?> pi) {
        this.injectContextProxiesIntoProvider(pi, null);
    }

    void injectContextProxiesIntoProvider(ProviderInfo<?> pi, Application app) {
        if (pi.contextsAvailable()) {
            InjectionUtils.injectContextProxiesAndApplication(pi, pi.getProvider(), app);
            this.injectedProviders.add(pi);
        }
    }

    private void sortReaders() {
        if (!this.customComparatorAvailable(MessageBodyReader.class)) {
            Collections.sort(this.messageReaders, new MessageBodyReaderComparator());
        } else {
            this.doCustomSort(this.messageReaders);
        }
    }

    private <T> void sortWriters() {
        if (!this.customComparatorAvailable(MessageBodyWriter.class)) {
            Collections.sort(this.messageWriters, new MessageBodyWriterComparator());
        } else {
            this.doCustomSort(this.messageWriters);
        }
    }

    private boolean customComparatorAvailable(Class<?> providerClass) {
        Type type2;
        ParameterizedType pt;
        Type type;
        return this.providerComparator != null && ((type = ((ParameterizedType)this.providerComparator.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0]) instanceof ParameterizedType ? (pt = (ParameterizedType)type).getRawType() == ProviderInfo.class && ((type2 = pt.getActualTypeArguments()[0]) == providerClass || type2 instanceof WildcardType || type2 instanceof ParameterizedType && ((ParameterizedType)type2).getRawType() == providerClass) : type == Object.class);
    }

    private <T> void doCustomSort(List<?> listOfProviders) {
        ProviderInfoClassComparator theProviderComparator = this.providerComparator;
        Type type = ((ParameterizedType)this.providerComparator.getClass().getGenericInterfaces()[0]).getActualTypeArguments()[0];
        if (type == Object.class) {
            theProviderComparator = new ProviderInfoClassComparator(theProviderComparator);
        }
        List<?> theProviders = listOfProviders;
        ProviderInfoClassComparator theComparator = theProviderComparator;
        Collections.sort(theProviders, theComparator);
    }

    private void sortContextResolvers() {
        Collections.sort(this.contextResolvers, new ContextResolverComparator());
    }

    private <T> boolean matchesReaderMediaTypes(ProviderInfo<MessageBodyReader<?>> pi, MediaType mediaType) {
        MessageBodyReader<?> ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderConsumeTypes(ep);
        return JAXRSUtils.doMimeTypesIntersect(Collections.singletonList(mediaType), supportedMediaTypes);
    }

    private boolean isReadable(ProviderInfo<MessageBodyReader<?>> pi, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        MessageBodyReader<?> ep = pi.getProvider();
        if (m.get((Object)ACTIVE_JAXRS_PROVIDER_KEY) != ep) {
            this.injectContextValues(pi, m);
        }
        return ep.isReadable(type, genericType, annotations, mediaType);
    }

    private <T> boolean matchesWriterMediaTypes(ProviderInfo<MessageBodyWriter<?>> pi, MediaType mediaType) {
        MessageBodyWriter<?> ep = pi.getProvider();
        List<MediaType> supportedMediaTypes = JAXRSUtils.getProviderProduceTypes(ep);
        return JAXRSUtils.doMimeTypesIntersect(Collections.singletonList(mediaType), supportedMediaTypes);
    }

    private boolean isWriteable(ProviderInfo<MessageBodyWriter<?>> pi, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, Message m) {
        MessageBodyWriter<?> ep = pi.getProvider();
        if (m.get((Object)ACTIVE_JAXRS_PROVIDER_KEY) != ep) {
            this.injectContextValues(pi, m);
        }
        return ep.isWriteable(type, genericType, annotations, mediaType);
    }

    List<ProviderInfo<MessageBodyReader<?>>> getMessageReaders() {
        return Collections.unmodifiableList(this.messageReaders);
    }

    List<ProviderInfo<MessageBodyWriter<?>>> getMessageWriters() {
        return Collections.unmodifiableList(this.messageWriters);
    }

    List<ProviderInfo<ContextResolver<?>>> getContextResolvers() {
        return Collections.unmodifiableList(this.contextResolvers);
    }

    public void registerUserProvider(Object provider) {
        this.setUserProviders(Collections.singletonList(provider));
    }

    public void setUserProviders(List<?> userProviders) {
        this.setProviders(true, false, userProviders.toArray());
    }

    private static int compareCustomStatus(ProviderInfo<?> p1, ProviderInfo<?> p2) {
        Boolean custom2;
        Boolean custom1 = p1.isCustom();
        int result = custom1.compareTo(custom2 = Boolean.valueOf(p2.isCustom())) * -1;
        if (result == 0 && custom1.booleanValue()) {
            Boolean busGlobal1 = p1.isBusGlobal();
            Boolean busGlobal2 = p2.isBusGlobal();
            result = busGlobal1.compareTo(busGlobal2);
        }
        return result;
    }

    public void clearThreadLocalProxies() {
        this.clearProxies(this.injectedProviders);
    }

    void clearProxies(Collection<?> ... lists) {
        for (Collection<?> list : lists) {
            Collection l2 = CastUtils.cast(list);
            for (ProviderInfo pi : l2) {
                pi.clearThreadLocalProxies();
            }
        }
    }

    public void clearProviders() {
        this.messageReaders.clear();
        this.messageWriters.clear();
        this.contextResolvers.clear();
        this.contextProviders.clear();
        this.readerInterceptors.clear();
        this.writerInterceptors.clear();
        this.paramConverters.clear();
    }

    public void setBus(Bus bus) {
        if (bus == null) {
            return;
        }
        for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
            this.injectProviderProperty(r.getProvider(), "setBus", Bus.class, bus);
        }
    }

    private boolean injectProviderProperty(Object provider, String mName, Class<?> pClass, Object pValue) {
        try {
            Method m = provider.getClass().getMethod(mName, pClass);
            m.invoke(provider, pValue);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setSchemaLocations(List<String> schemas) {
        for (ProviderInfo<MessageBodyReader<?>> r : this.messageReaders) {
            this.injectProviderProperty(r.getProvider(), "setSchemaLocations", List.class, schemas);
        }
    }

    protected static <T> List<ProviderInfo<T>> getBoundFilters(Map<NameKey, ProviderInfo<T>> boundFilters, Set<String> names) {
        if (boundFilters.isEmpty()) {
            return Collections.emptyList();
        }
        names = names == null ? Collections.emptySet() : names;
        MetadataMap map = new MetadataMap();
        for (Map.Entry<NameKey, ProviderInfo<T>> entry : boundFilters.entrySet()) {
            FilterProviderInfo fpi;
            String entryName = entry.getKey().getName();
            ProviderInfo<T> provider = entry.getValue();
            if (entryName.equals(DEFAULT_FILTER_NAME_BINDING)) {
                map.put(provider, Collections.emptyList());
                continue;
            }
            if (provider instanceof FilterProviderInfo && (fpi = (FilterProviderInfo)provider).isDynamic() && !names.containsAll(fpi.getNameBindings())) continue;
            map.add(provider, entryName);
        }
        LinkedList<ProviderInfo<T>> list = new LinkedList<ProviderInfo<T>>();
        for (Map.Entry entry : map.entrySet()) {
            List values = (List)entry.getValue();
            if (!names.containsAll(values)) continue;
            ProviderInfo provider = (ProviderInfo)entry.getKey();
            list.add(provider);
        }
        return list;
    }

    public void initProviders(List<ClassResourceInfo> cris) {
        Set<Object> set = this.getReadersWriters();
        for (Object o : set) {
            Object provider = ((ProviderInfo)o).getProvider();
            if (!(provider instanceof AbstractConfigurableProvider)) continue;
            ((AbstractConfigurableProvider)provider).init(cris);
        }
    }

    Set<Object> getReadersWriters() {
        HashSet<Object> set = new HashSet<Object>();
        set.addAll(this.messageReaders);
        set.addAll(this.messageWriters);
        return set;
    }

    public static ProviderFactory getInstance(Message m) {
        Endpoint e = m.getExchange().getEndpoint();
        Message outM = m.getExchange().getOutMessage();
        boolean isClient = outM != null && MessageUtils.isRequestor((Message)outM);
        String name = isClient ? CLIENT_FACTORY_NAME : SERVER_FACTORY_NAME;
        return (ProviderFactory)e.get((Object)name);
    }

    protected static int compareClasses(Object o1, Object o2) {
        return ProviderFactory.compareClasses(null, o1, o2);
    }

    protected static int compareClasses(Class<?> expectedCls, Object o1, Object o2) {
        Class<?> realClass2;
        Class cl1 = ClassHelper.getRealClass((Object)o1);
        Class cl2 = ClassHelper.getRealClass((Object)o2);
        Type[] types1 = ProviderFactory.getGenericInterfaces(cl1, expectedCls);
        Type[] types2 = ProviderFactory.getGenericInterfaces(cl2, expectedCls);
        if (types1.length == 0 && types2.length == 0) {
            return 0;
        }
        if (types1.length == 0 && types2.length > 0) {
            return 1;
        }
        if (types1.length > 0 && types2.length == 0) {
            return -1;
        }
        Class<?> realClass1 = InjectionUtils.getActualType(types1[0]);
        if (realClass1 == (realClass2 = InjectionUtils.getActualType(types2[0]))) {
            return 0;
        }
        if (realClass1.isAssignableFrom(realClass2)) {
            return 1;
        }
        return -1;
    }

    private static Type[] getGenericInterfaces(Class<?> cls, Class<?> expectedClass) {
        return ProviderFactory.getGenericInterfaces(cls, expectedClass, Object.class);
    }

    private static Type[] getGenericInterfaces(Class<?> cls, Class<?> expectedClass, Class<?> commonBaseCls) {
        Type[] types;
        Type genericSuperType;
        if (Object.class == cls) {
            return new Type[0];
        }
        if (expectedClass != null && (genericSuperType = cls.getGenericSuperclass()) instanceof ParameterizedType) {
            Class<?> actualType = InjectionUtils.getActualType(genericSuperType);
            if (actualType != null && actualType.isAssignableFrom(expectedClass)) {
                return new Type[]{genericSuperType};
            }
            if (commonBaseCls != null && commonBaseCls != Object.class && commonBaseCls.isAssignableFrom(expectedClass) && commonBaseCls.isAssignableFrom(actualType) || expectedClass.isAssignableFrom(actualType)) {
                return new Type[0];
            }
        }
        if ((types = cls.getGenericInterfaces()).length > 0) {
            return types;
        }
        return ProviderFactory.getGenericInterfaces(cls.getSuperclass(), expectedClass, commonBaseCls);
    }

    public static ProviderInfo<? extends Object> createProviderFromConstructor(Constructor<?> c, Map<Class<?>, Object> values, Bus theBus, boolean checkContexts, boolean custom) {
        Map proxiesMap = CastUtils.cast((Map)((Map)theBus.getProperty("jaxrs-constructor-proxy-map")));
        Map existingProxies = null;
        if (proxiesMap != null) {
            existingProxies = (Map)proxiesMap.get(c.getDeclaringClass());
        }
        Class<?>[] paramTypes = c.getParameterTypes();
        Object[] cArgs = ResourceUtils.createConstructorArguments(c, null, false, values);
        if (existingProxies != null && existingProxies.size() <= paramTypes.length) {
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!(cArgs[i] instanceof ThreadLocalProxy)) continue;
                cArgs[i] = existingProxies.get(paramTypes[i]);
            }
        }
        Object instance = null;
        try {
            instance = c.newInstance(cArgs);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Resource or provider class " + c.getDeclaringClass().getName() + " can not be instantiated");
        }
        LinkedHashMap proxies = new LinkedHashMap();
        for (int i = 0; i < paramTypes.length; ++i) {
            if (!(cArgs[i] instanceof ThreadLocalProxy)) continue;
            ThreadLocalProxy proxy = (ThreadLocalProxy)cArgs[i];
            proxies.put(paramTypes[i], proxy);
        }
        boolean isApplication = Application.class.isAssignableFrom(c.getDeclaringClass());
        if (isApplication) {
            return new ApplicationInfo((Application)instance, proxies, theBus);
        }
        return new ProviderInfo<Object>(instance, proxies, theBus, checkContexts, custom);
    }

    protected static <T> void mapInterceptorFilters(Map<NameKey, ProviderInfo<T>> map, List<ProviderInfo<T>> filters, Class<?> providerCls, boolean ascending) {
        for (ProviderInfo<T> p : filters) {
            Set<String> names = ProviderFactory.getFilterNameBindings(p);
            int priority = ProviderFactory.getFilterPriority(p, providerCls);
            for (String name : names) {
                map.put(new NameKey(name, priority, p.getClass()), p);
            }
        }
    }

    protected static Set<String> getFilterNameBindings(ProviderInfo<?> p) {
        if (p instanceof FilterProviderInfo) {
            return ((FilterProviderInfo)p).getNameBindings();
        }
        return ProviderFactory.getFilterNameBindings(p.getBus(), p.getProvider());
    }

    protected static Set<String> getFilterNameBindings(Bus bus, Object provider) {
        Class pClass = ClassHelper.getRealClass((Bus)bus, (Object)provider);
        Set<String> names = AnnotationUtils.getNameBindings(pClass.getAnnotations());
        if (names.isEmpty()) {
            names = Collections.singleton(DEFAULT_FILTER_NAME_BINDING);
        }
        return names;
    }

    protected static int getFilterPriority(ProviderInfo<?> p, Class<?> providerCls) {
        return p instanceof FilterProviderInfo ? ((FilterProviderInfo)p).getPriority(providerCls) : AnnotationUtils.getBindingPriority(p.getProvider().getClass());
    }

    protected static boolean filterContractSupported(ProviderInfo<?> provider, Class<?> providerCls, Class<?> contract) {
        boolean result = false;
        if (contract.isAssignableFrom(providerCls)) {
            Set<Class<?>> actualContracts = null;
            if (provider instanceof FilterProviderInfo) {
                actualContracts = ((FilterProviderInfo)provider).getSupportedContracts();
            }
            result = actualContracts != null ? actualContracts.contains(contract) : true;
        }
        return result;
    }

    protected List<ProviderInfo<? extends Object>> prepareProviders(boolean custom, boolean busGlobal, Object[] providers, ProviderInfo<Application> application) {
        ArrayList<ProviderInfo<? extends Object>> theProviders = new ArrayList<ProviderInfo<? extends Object>>(providers.length);
        for (Object o : providers) {
            if (o == null) continue;
            Object provider = o;
            if (provider.getClass() == Class.class) {
                provider = ResourceUtils.createProviderInstance((Class)provider);
            }
            if (provider instanceof Constructor) {
                Map values = CastUtils.cast(application == null ? null : Collections.singletonMap(Application.class, application.getProvider()));
                theProviders.add(ProviderFactory.createProviderFromConstructor((Constructor)provider, values, this.getBus(), true, custom));
                continue;
            }
            if (provider instanceof ProviderInfo) {
                theProviders.add((ProviderInfo)provider);
                continue;
            }
            ProviderInfo<Object> theProvider = new ProviderInfo<Object>(provider, this.getBus(), custom);
            theProvider.setBusGlobal(busGlobal);
            theProviders.add(theProvider);
        }
        return theProviders;
    }

    public MessageBodyWriter<?> getDefaultJaxbWriter() {
        for (ProviderInfo<MessageBodyWriter<?>> pi : this.messageWriters) {
            Class<?> cls = pi.getProvider().getClass();
            if (!cls.getName().equals(JAXB_PROVIDER_NAME)) continue;
            return pi.getProvider();
        }
        return null;
    }

    public void setProviderComparator(Comparator<?> providerComparator) {
        this.providerComparator = providerComparator;
        this.sortReaders();
        this.sortWriters();
    }

    protected static class NameKeyMap<T>
    extends TreeMap<NameKey, T> {
        private static final long serialVersionUID = -4352258671270502204L;

        public NameKeyMap(boolean ascending) {
            super(new NameKeyComparator(ascending));
        }
    }

    protected static class NameKeyComparator
    extends AbstractPriorityComparator
    implements Comparator<NameKey> {
        public NameKeyComparator(boolean ascending) {
            super(ascending);
        }

        @Override
        public int compare(NameKey key1, NameKey key2) {
            int result = this.compare(key1.getPriority(), key2.getPriority());
            if (result != 0) {
                return result;
            }
            return this.compare(key1.hashCode(), key2.hashCode());
        }
    }

    protected static class NameKey {
        private String name;
        private Integer priority;
        private Class<?> providerCls;

        public NameKey(String name, int priority, Class<?> providerCls) {
            this.name = name;
            this.priority = priority;
            this.providerCls = providerCls;
        }

        public String getName() {
            return this.name;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public boolean equals(Object o) {
            if (!(o instanceof NameKey)) {
                return false;
            }
            NameKey other = (NameKey)o;
            return this.name.equals(other.name) && this.priority.equals(other.priority) && this.providerCls == other.providerCls;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public String toString() {
            return this.name + ":" + this.priority;
        }
    }

    static class ContextResolverProxy<T>
    implements ContextResolver<T> {
        private List<ContextResolver<T>> candidates;

        ContextResolverProxy(List<ContextResolver<T>> candidates) {
            this.candidates = candidates;
        }

        public T getContext(Class<?> cls) {
            for (ContextResolver<T> resolver : this.candidates) {
                Object context = resolver.getContext(cls);
                if (context == null) continue;
                return (T)context;
            }
            return null;
        }

        public List<ContextResolver<T>> getResolvers() {
            return this.candidates;
        }
    }

    protected static class BindingPriorityComparator
    extends AbstractPriorityComparator
    implements Comparator<ProviderInfo<?>> {
        private Class<?> providerCls;

        public BindingPriorityComparator(Class<?> providerCls, boolean ascending) {
            super(ascending);
            this.providerCls = providerCls;
        }

        @Override
        public int compare(ProviderInfo<?> p1, ProviderInfo<?> p2) {
            return this.compare(ProviderFactory.getFilterPriority(p1, this.providerCls), ProviderFactory.getFilterPriority(p2, this.providerCls));
        }
    }

    protected static class AbstractPriorityComparator {
        private boolean ascending;

        protected AbstractPriorityComparator(boolean ascending) {
            this.ascending = ascending;
        }

        protected int compare(Integer b1Value, Integer b2Value) {
            int result = b1Value.compareTo(b2Value);
            return this.ascending ? result : result * -1;
        }
    }

    public static class ProviderInfoClassComparator
    implements Comparator<ProviderInfo<?>> {
        private Comparator<Object> comp;
        private boolean defaultComp;

        public ProviderInfoClassComparator(Class<?> expectedCls) {
            this.comp = new ClassComparator(expectedCls);
            this.defaultComp = true;
        }

        public ProviderInfoClassComparator(Comparator<Object> comp) {
            this.comp = comp;
        }

        @Override
        public int compare(ProviderInfo<?> p1, ProviderInfo<?> p2) {
            int result = this.comp.compare(p1.getProvider(), p2.getProvider());
            if (result == 0 && this.defaultComp) {
                result = ProviderFactory.compareCustomStatus(p1, p2);
            }
            return result;
        }
    }

    public static class ClassComparator
    implements Comparator<Object> {
        private Class<?> expectedCls;

        public ClassComparator() {
        }

        public ClassComparator(Class<?> expectedCls) {
            this.expectedCls = expectedCls;
        }

        @Override
        public int compare(Object em1, Object em2) {
            return ProviderFactory.compareClasses(this.expectedCls, em1, em2);
        }
    }

    private static class ContextResolverComparator
    implements Comparator<ProviderInfo<ContextResolver<?>>> {
        private ContextResolverComparator() {
        }

        @Override
        public int compare(ProviderInfo<ContextResolver<?>> p1, ProviderInfo<ContextResolver<?>> p2) {
            ContextResolver<?> e1 = p1.getProvider();
            ContextResolver<?> e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e1.getClass().getAnnotation(Produces.class)), "qs");
            List<MediaType> types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProduceTypes(e2.getClass().getAnnotation(Produces.class)), "qs");
            return JAXRSUtils.compareSortedMediaTypes(types1, types2, "qs");
        }
    }

    private static class MessageBodyWriterComparator
    implements Comparator<ProviderInfo<MessageBodyWriter<?>>> {
        private MessageBodyWriterComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyWriter<?>> p1, ProviderInfo<MessageBodyWriter<?>> p2) {
            List<MediaType> types2;
            MessageBodyWriter<?> e2;
            MessageBodyWriter<?> e1 = p1.getProvider();
            int result = ProviderFactory.compareClasses(e1, e2 = p2.getProvider());
            if (result != 0) {
                return result;
            }
            List<MediaType> types1 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e1), "qs");
            result = JAXRSUtils.compareSortedMediaTypes(types1, types2 = JAXRSUtils.sortMediaTypes(JAXRSUtils.getProviderProduceTypes(e2), "qs"), "qs");
            if (result != 0) {
                return result;
            }
            return ProviderFactory.compareCustomStatus(p1, p2);
        }
    }

    private static class MessageBodyReaderComparator
    implements Comparator<ProviderInfo<MessageBodyReader<?>>> {
        private MessageBodyReaderComparator() {
        }

        @Override
        public int compare(ProviderInfo<MessageBodyReader<?>> p1, ProviderInfo<MessageBodyReader<?>> p2) {
            MessageBodyReader<?> e1 = p1.getProvider();
            MessageBodyReader<?> e2 = p2.getProvider();
            List<MediaType> types1 = JAXRSUtils.getProviderConsumeTypes(e1);
            types1 = JAXRSUtils.sortMediaTypes(types1, null);
            List<MediaType> types2 = JAXRSUtils.getProviderConsumeTypes(e2);
            int result = JAXRSUtils.compareSortedMediaTypes(types1, types2 = JAXRSUtils.sortMediaTypes(types2, null), null);
            if (result != 0) {
                return result;
            }
            result = ProviderFactory.compareClasses(e1, e2);
            if (result != 0) {
                return result;
            }
            return ProviderFactory.compareCustomStatus(p1, p2);
        }
    }
}

