/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.openejb.config.ConfigurableClasspathArchive;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.ScanConstants;
import org.apache.openejb.config.ScanUtil;
import org.apache.openejb.loader.JarLocation;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.filter.Filter;

public class WebappAggregatedArchive
implements Archive,
ScanConstants {
    private final Map<URL, List<String>> map = new HashMap<URL, List<String>>();
    private ScanUtil.ScanHandler handler;
    private boolean scanXmlExists;
    private Archive archive;

    public WebappAggregatedArchive(Module module, Iterable<URL> urls, Filter filter) {
        URL scanXml = (URL)module.getAltDDs().get("scan.xml");
        if (scanXml != null) {
            try {
                this.handler = ScanUtil.read(scanXml);
                this.scanXmlExists = true;
                if ((this.handler.getPackages() == null || this.handler.getPackages().isEmpty()) && this.handler.getClasses() != null && !this.handler.getClasses().isEmpty() && this.handler.isOptimized()) {
                    ArrayList loaded = new ArrayList(this.handler.getClasses().size());
                    for (String clazz : this.handler.getClasses()) {
                        try {
                            Class<?> aClass = module.getClassLoader().loadClass(clazz);
                            loaded.add(aClass);
                            URL jar = JarLocation.jarLocation(aClass).toURI().toURL();
                            List<String> list = this.map.get(jar);
                            if (list == null) {
                                list = new ArrayList<String>();
                                this.map.put(jar, list);
                            }
                            list.add(clazz);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalArgumentException(e);
                        }
                    }
                    this.archive = new ClassesArchive(loaded.toArray(new Class[loaded.size()]));
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.archive = new CompositeArchive(this.doScan(module.getClassLoader(), urls, filter));
    }

    private List<Archive> doScan(ClassLoader loader, Iterable<URL> urls, Filter filter) {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        for (URL url : urls) {
            ArrayList<String> classes = new ArrayList<String>();
            FilteredArchive archive = new FilteredArchive((Archive)new ConfigurableClasspathArchive(loader, Collections.singletonList(url)), (Filter)new ScanXmlSaverFilter(this.scanXmlExists, this.handler, classes, filter));
            this.map.put(url, classes);
            archives.add((Archive)archive);
        }
        return archives;
    }

    public WebappAggregatedArchive(Archive delegate, Iterable<URL> urls) {
        List<Archive> archives = this.doScan(Thread.currentThread().getContextClassLoader(), urls, null);
        ArrayList<String> classes = new ArrayList<String>();
        FilteredArchive archive = new FilteredArchive(delegate, (Filter)new ScanXmlSaverFilter(this.scanXmlExists, this.handler, classes, null));
        try {
            this.map.put(new URL("jar:file://!/META-INF/beans.xml"), classes);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        archives.add((Archive)archive);
        this.archive = new CompositeArchive(archives);
    }

    public WebappAggregatedArchive(Module module, Iterable<URL> urls) {
        this(module, urls, null);
    }

    public WebappAggregatedArchive(ClassLoader classLoader, Map<String, Object> altDDs, Collection<URL> xmls) {
        this(new ConfigurableClasspathArchive.FakeModule(classLoader, altDDs), xmls);
    }

    public Map<URL, List<String>> getClassesMap() {
        return this.map;
    }

    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        return this.archive.getBytecode(className);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.archive.loadClass(className);
    }

    public Iterator<Archive.Entry> iterator() {
        return this.archive.iterator();
    }

    public static class ScanXmlSaverFilter
    implements Filter {
        private final boolean scanXmlExists;
        private final ScanUtil.ScanHandler handler;
        private final List<String> classes;
        private final Filter otherFilter;

        public ScanXmlSaverFilter(boolean scanXmlExists, ScanUtil.ScanHandler handler, List<String> classes, Filter otherFilter) {
            this.scanXmlExists = scanXmlExists;
            this.handler = handler;
            this.classes = classes;
            this.otherFilter = otherFilter;
        }

        public boolean accept(String name) {
            boolean accept;
            boolean bl = accept = this.otherFilter == null || this.otherFilter.accept(name);
            if (this.scanXmlExists) {
                for (String packageName : this.handler.getPackages()) {
                    if (!name.startsWith(packageName) || !accept) continue;
                    this.classes.add(name);
                    return true;
                }
                for (String className : this.handler.getClasses()) {
                    if (!className.equals(name) || !accept) continue;
                    this.classes.add(name);
                    return true;
                }
                return false;
            }
            if (accept) {
                this.classes.add(name);
            }
            return accept;
        }
    }
}

