/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets;

import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import org.apache.myfaces.view.ViewDeclarationLanguageStrategy;
import org.apache.myfaces.view.facelets.FaceletViewDeclarationLanguage;

public class FaceletViewDeclarationLanguageStrategy
implements ViewDeclarationLanguageStrategy {
    private Pattern _acceptPatterns;
    private String _extension;
    private ViewDeclarationLanguage _language;

    public FaceletViewDeclarationLanguageStrategy() {
        FacesContext context = FacesContext.getCurrentInstance();
        ExternalContext eContext = context.getExternalContext();
        this._acceptPatterns = this.loadAcceptPattern(eContext);
        this._extension = this.loadFaceletExtension(eContext);
        this._language = new FaceletViewDeclarationLanguage(context, this);
    }

    @Override
    public ViewDeclarationLanguage getViewDeclarationLanguage() {
        return this._language;
    }

    @Override
    public boolean handles(String viewId) {
        if (viewId == null) {
            return false;
        }
        if (viewId.endsWith(this._extension)) {
            return true;
        }
        return this._acceptPatterns != null && this._acceptPatterns.matcher(viewId).matches();
    }

    private Pattern loadAcceptPattern(ExternalContext context) {
        assert (context != null);
        String mappings = context.getInitParameter("javax.faces.FACELETS_VIEW_MAPPINGS");
        if (mappings == null) {
            mappings = context.getInitParameter("facelets.VIEW_MAPPINGS");
        }
        if (mappings == null) {
            return null;
        }
        if ((mappings = mappings.trim()).length() == 0) {
            return null;
        }
        return Pattern.compile(this.toRegex(mappings));
    }

    private String loadFaceletExtension(ExternalContext context) {
        assert (context != null);
        String suffix = context.getInitParameter("javax.faces.FACELETS_SUFFIX");
        if (suffix == null) {
            suffix = ".xhtml";
        } else if ((suffix = suffix.trim()).length() == 0) {
            suffix = ".xhtml";
        }
        return suffix;
    }

    private String toRegex(String mappings) {
        assert (mappings != null);
        mappings = mappings.replaceAll("\\s", "");
        mappings = mappings.replaceAll("\\.", "\\\\.");
        mappings = mappings.replaceAll("\\*", ".*");
        mappings = mappings.replaceAll(";", "|");
        return mappings;
    }
}

