/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.transport.DestinationFactory;
import org.apache.cxf.transport.http.HTTPTransportFactory;
import org.apache.openejb.cdi.WebBeansContextBeforeDeploy;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.rest.AbstractRestThreadLocalProxy;
import org.apache.openejb.rest.RESTResourceFinder;
import org.apache.openejb.rest.ThreadLocalContextManager;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.cxf.rs.Contexts;
import org.apache.openejb.server.cxf.rs.CxfHacks;
import org.apache.openejb.server.cxf.rs.CxfRESTResourceFinder;
import org.apache.openejb.server.cxf.rs.CxfRsHttpListener;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.rest.RESTService;
import org.apache.openejb.server.rest.RsHttpListener;
import org.apache.openejb.threads.task.CUTask;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.EmptyAnnotationLiteral;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;

public class CxfRSService
extends RESTService {
    private static final String NAME = "cxf-rs";
    private DestinationFactory destinationFactory;
    private boolean factoryByListener;
    private Properties config;

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " cannot be invoked directly");
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " cannot be invoked directly");
    }

    public String getName() {
        return NAME;
    }

    public void integrateCDIAndJaxRsInjections(@Observes WebBeansContextBeforeDeploy event) {
        this.contextCDIIntegration(event.getContext());
    }

    private void contextCDIIntegration(WebBeansContext wbc) {
        if (!this.enabled) {
            return;
        }
        BeanManagerImpl beanManagerImpl = wbc.getBeanManagerImpl();
        if (!beanManagerImpl.getAdditionalQualifiers().contains(Context.class)) {
            beanManagerImpl.addAdditionalQualifier(Context.class);
        }
        if (!CxfRSService.hasBean(beanManagerImpl, SecurityContext.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<SecurityContext>(SecurityContext.class, (AbstractRestThreadLocalProxy<SecurityContext>)ThreadLocalContextManager.SECURITY_CONTEXT));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, UriInfo.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<UriInfo>(UriInfo.class, (AbstractRestThreadLocalProxy<UriInfo>)ThreadLocalContextManager.URI_INFO));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, HttpServletResponse.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<HttpServletResponse>(HttpServletResponse.class, (AbstractRestThreadLocalProxy<HttpServletResponse>)ThreadLocalContextManager.HTTP_SERVLET_RESPONSE));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, HttpHeaders.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<HttpHeaders>(HttpHeaders.class, (AbstractRestThreadLocalProxy<HttpHeaders>)ThreadLocalContextManager.HTTP_HEADERS));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, Request.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<Request>(Request.class, (AbstractRestThreadLocalProxy<Request>)ThreadLocalContextManager.REQUEST));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, ServletConfig.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<ServletConfig>(ServletConfig.class, (AbstractRestThreadLocalProxy<ServletConfig>)ThreadLocalContextManager.SERVLET_CONFIG));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, Providers.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<Providers>(Providers.class, (AbstractRestThreadLocalProxy<Providers>)ThreadLocalContextManager.PROVIDERS));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, ContextResolver.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<ContextResolver>(ContextResolver.class, (AbstractRestThreadLocalProxy<ContextResolver>)ThreadLocalContextManager.CONTEXT_RESOLVER));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, ResourceInfo.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<ResourceInfo>(ResourceInfo.class, (AbstractRestThreadLocalProxy<ResourceInfo>)ThreadLocalContextManager.RESOURCE_INFO));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, ResourceContext.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<ResourceContext>(ResourceContext.class, (AbstractRestThreadLocalProxy<ResourceContext>)ThreadLocalContextManager.RESOURCE_CONTEXT));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, HttpServletRequest.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<HttpServletRequest>(HttpServletRequest.class, (AbstractRestThreadLocalProxy<HttpServletRequest>)ThreadLocalContextManager.HTTP_SERVLET_REQUEST));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, ServletRequest.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<ServletRequest>(ServletRequest.class, (AbstractRestThreadLocalProxy<ServletRequest>)ThreadLocalContextManager.SERVLET_REQUEST));
        }
        if (!CxfRSService.hasBean(beanManagerImpl, ServletContext.class)) {
            beanManagerImpl.addInternalBean(new ContextBean<ServletContext>(ServletContext.class, (AbstractRestThreadLocalProxy<ServletContext>)ThreadLocalContextManager.SERVLET_CONTEXT));
        }
        beanManagerImpl.getInjectionResolver().clearCaches();
    }

    private static boolean hasBean(BeanManagerImpl beanManagerImpl, Class<?> type) {
        return beanManagerImpl.getInjectionResolver().implResolveByType(false, type, new Annotation[0]).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Properties properties) throws Exception {
        super.init(properties);
        this.config = properties;
        this.factoryByListener = "true".equalsIgnoreCase(properties.getProperty("openejb.cxf-rs.factoryByListener", "false"));
        System.setProperty("org.apache.johnzon.max-string-length", SystemInstance.get().getProperty("org.apache.johnzon.max-string-length", properties.getProperty("org.apache.johnzon.max-string-length", "8192")));
        SystemInstance.get().setComponent(RESTResourceFinder.class, (Object)new CxfRESTResourceFinder());
        try {
            CUTask.addContainerListener((CUTask.ContainerListener)new CUTask.ContainerListener(){

                public Object onCreation() {
                    return Contexts.state();
                }

                public Object onStart(Object state) {
                    return Contexts.restore(state);
                }

                public void onEnd(Object oldState) {
                    Contexts.restore(oldState);
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CxfUtil.configureBus();
        Bus bus = CxfUtil.getBus();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
        try {
            if (!CxfUtil.hasService((String)"http://apache.org/cxf/binding/jaxrs")) {
                BindingFactoryManager bfm = (BindingFactoryManager)bus.getExtension(BindingFactoryManager.class);
                try {
                    bfm.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)new JAXRSBindingFactory(bus));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.hacksOn();
            this.initCxfProviders(bus);
        }
        finally {
            if (oldLoader != null) {
                CxfUtil.clearBusLoader((ClassLoader)oldLoader);
            }
        }
    }

    private void initCxfProviders(Bus bus) {
        if (bus.getProperty("org.apache.cxf.jaxrs.bus.providers") == null) {
            bus.setProperty("skip.default.json.provider.registration", (Object)"true");
            ArrayList defaults = new ArrayList();
            String userConfiguredJsonProviders = SystemInstance.get().getProperty("openejb.jaxrs.jsonProviders");
            List<String> jsonProviders = userConfiguredJsonProviders == null ? Arrays.asList("org.apache.openejb.server.cxf.rs.johnzon.TomEEJohnzonProvider", "org.apache.openejb.server.cxf.rs.johnzon.TomEEJsonpProvider") : Arrays.asList(userConfiguredJsonProviders.split(","));
            for (String provider : jsonProviders) {
                if (!this.isActive(provider)) continue;
                try {
                    defaults.add(Class.forName(provider, true, CxfRSService.class.getClassLoader()).newInstance());
                }
                catch (Exception exception) {}
            }
            try {
                ArrayList all;
                String userProviders = SystemInstance.get().getProperty("openejb.jaxrs.client.providers");
                if (userProviders == null) {
                    all = new ArrayList(defaults.size());
                    all.addAll(defaults);
                } else {
                    all = new ArrayList(defaults.size() + 2);
                    for (String p : userProviders.split(" *, *")) {
                        if ((p = p.trim()).isEmpty()) continue;
                        all.add(Thread.currentThread().getContextClassLoader().loadClass(p).newInstance());
                    }
                    all.addAll(defaults);
                }
                bus.setProperty("org.apache.cxf.jaxrs.bus.providers", all);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void hacksOn() {
        CxfHacks.initCxfClassHelper();
    }

    public void stop() throws ServiceException {
        super.stop();
        CxfUtil.release();
    }

    protected void beforeStart() {
        super.beforeStart();
        this.destinationFactory = new HTTPTransportFactory();
    }

    protected boolean containsJaxRsConfiguration(Properties properties) {
        return properties.containsKey("cxf.jaxrs.providers") || properties.containsKey("cxf.jaxrs.in-fault-interceptors") || properties.containsKey("cxf.jaxrs.in-interceptors") || properties.containsKey("cxf.jaxrs.out-fault-interceptors") || properties.containsKey("cxf.jaxrs.out-interceptors") || properties.containsKey("cxf.jaxrs.databinding") || properties.containsKey("cxf.jaxrs.features") || properties.containsKey("cxf.jaxrs.address") || properties.containsKey("cxf.jaxrs.properties");
    }

    protected RsHttpListener createHttpListener() {
        return new CxfRsHttpListener((DestinationFactory)(!this.factoryByListener ? this.destinationFactory : new HTTPTransportFactory()), this.getWildcard(), this);
    }

    public boolean isActive(String name) {
        String key = name + ".activated";
        return "true".equalsIgnoreCase(SystemInstance.get().getProperty(key, this.config.getProperty(key, "true")));
    }

    private static class DelegateHandler<T>
    implements InvocationHandler {
        private final AbstractRestThreadLocalProxy<T> proxy;

        public DelegateHandler(AbstractRestThreadLocalProxy<T> proxy) {
            this.proxy = proxy;
        }

        @Override
        public Object invoke(Object ignored, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke(this.proxy.get(), args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }

    private static class ContextBean<T>
    implements Bean<T>,
    PassivationCapable {
        private final Class<T> type;
        private final Set<Type> types;
        private final Set<Annotation> qualifiers;
        private final T proxy;
        private final String id;

        public ContextBean(Class<T> type, AbstractRestThreadLocalProxy<T> proxy) {
            this.type = type;
            this.proxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type, Serializable.class}, new DelegateHandler<T>(proxy));
            this.types = new HashSet<Class>(Arrays.asList(Object.class, type));
            this.qualifiers = new HashSet<AnnotationLiteral>(Arrays.asList(ContextLiteral.INSTANCE, AnyLiteral.INSTANCE));
            this.id = ContextBean.class.getName() + "#" + type.getName();
        }

        public String getId() {
            return this.id;
        }

        public Set<Type> getTypes() {
            return this.types;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<? extends Annotation> getScope() {
            return ApplicationScoped.class;
        }

        public String getName() {
            return null;
        }

        public boolean isNullable() {
            return false;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public Class<?> getBeanClass() {
            return this.type;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }

        public T create(CreationalContext<T> tCreationalContext) {
            return this.proxy;
        }

        public void destroy(T t, CreationalContext<T> tCreationalContext) {
        }
    }

    private static class ContextLiteral
    extends EmptyAnnotationLiteral<Context>
    implements Context {
        private static final long serialVersionUID = 1L;
        public static final AnnotationLiteral<Context> INSTANCE = new ContextLiteral();

        private ContextLiteral() {
        }
    }
}

