/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.startup.Bootstrap;
import org.apache.catalina.startup.Catalina;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.assembler.WebAppDeployer;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.classloader.WebAppEnricher;
import org.apache.openejb.component.ClassLoaderEnricher;
import org.apache.openejb.config.ConfigUtils;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.sys.Tomee;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ThreadContextListener;
import org.apache.openejb.loader.Loader;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServiceManager;
import org.apache.openejb.server.ejbd.EjbServer;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.util.OptionsLog;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.tomcat.util.file.Matcher;
import org.apache.tomee.catalina.OpenEJBNamingContextListener;
import org.apache.tomee.catalina.TomEEClassLoaderEnricher;
import org.apache.tomee.catalina.TomEEServiceManager;
import org.apache.tomee.catalina.TomcatJndiBuilder;
import org.apache.tomee.catalina.TomcatThreadContextListener;
import org.apache.tomee.catalina.TomcatWebAppBuilder;
import org.apache.tomee.catalina.Warmup;
import org.apache.tomee.catalina.WebDeploymentListeners;
import org.apache.tomee.catalina.deployment.TomcatWebappDeployer;
import org.apache.tomee.installer.Installer;
import org.apache.tomee.installer.Paths;
import org.apache.tomee.installer.Status;
import org.apache.tomee.loader.TomcatHelper;
import org.apache.xbean.finder.filter.Filter;

public class TomcatLoader
implements Loader {
    private static final Logger logger = Logger.getLogger(TomcatLoader.class.getName());
    public static final String TOMEE_NOSHUTDOWNHOOK_PROP = "tomee.noshutdownhook";
    private static EjbServer ejbServer;
    private static ServiceManager manager;
    private static final List<ServerService> services;

    @Deprecated
    public void init(Properties properties) throws Exception {
        this.initSystemInstance(properties);
        this.initialize(properties);
    }

    public void initSystemInstance(Properties properties) throws Exception {
        this.initDefaults(properties);
        SystemInstance.init((Properties)properties);
    }

    public void initDefaults(Properties properties) {
        try {
            SecurityEnv.init();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.setIfNull(properties, "authconfigprovider.factory", "false");
        this.setIfNull(properties, "openejb.deployments.classpath", "false");
        this.setIfNull(properties, "openejb.deployments.classpath.filter.systemapps", "false");
        this.setIfNull(properties, "openejb.provider.default", "org.apache.tomee");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Properties properties) throws Exception {
        block28: {
            Installer installer;
            Paths paths;
            Warmup.warmup();
            OptionsLog.install();
            String openejbWarDir = properties.getProperty("tomee.war");
            if (openejbWarDir != null && (paths = new Paths(new File(openejbWarDir))).verify() && (installer = new Installer(paths)).getStatus() != Status.INSTALLED) {
                installer.installConfigFiles(false);
            }
            if (OpenEJB.isInitialized()) {
                ejbServer = (EjbServer)SystemInstance.get().getComponent(EjbServer.class);
                return;
            }
            File conf = new File(SystemInstance.get().getBase().getDirectory(), "conf");
            for (Installer possibleTomeePaths : ConfigUtils.deducePaths((String)"tomee.xml")) {
                File tomeeXml = new File(conf, (String)possibleTomeePaths);
                if (!tomeeXml.exists()) continue;
                SystemInstance.get().setProperty("openejb.configuration", tomeeXml.getAbsolutePath());
                SystemInstance.get().setProperty("openejb.configuration.class", Tomee.class.getName());
            }
            try {
                Class<?> creatorClass = TomcatLoader.class.getClassLoader().loadClass("org.apache.tomee.jdbc.TomEEDataSourceCreator");
                SystemInstance.get().setProperty("openejb.jdbc.datasource-creator", creatorClass.getName());
            }
            catch (Throwable creatorClass) {
                // empty catch block
            }
            SystemInstance.get().setProperty("openejb.default.deployment-module", System.getProperty("openejb.default.deployment-module", "org.apache.openejb.config.WebModule"));
            System.setProperty("openejb.home", SystemInstance.get().getHome().getDirectory().getAbsolutePath());
            System.setProperty("openejb.base", SystemInstance.get().getBase().getDirectory().getAbsolutePath());
            ThreadContext.addThreadContextListener((ThreadContextListener)new TomcatThreadContextListener());
            Class<?> scanner = Class.forName("org.apache.tomcat.util.scan.StandardJarScanFilter", true, TomcatLoader.class.getClassLoader());
            Set forcedScanJar = (Set)Set.class.cast(Reflections.get(scanner, null, (String)"defaultScanSet"));
            Set forcedSkipJar = (Set)Set.class.cast(Reflections.get(scanner, null, (String)"defaultSkipSet"));
            NewLoaderLogic.addAdditionalCustomFilter((Filter)(forcedSkipJar.isEmpty() ? null : new TomcatToXbeanFilter(forcedSkipJar)), (Filter)(forcedScanJar.isEmpty() ? null : new TomcatToXbeanFilter(forcedScanJar)));
            TomcatWebAppBuilder tomcatWebAppBuilder = (TomcatWebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
            if (tomcatWebAppBuilder == null) {
                tomcatWebAppBuilder = new TomcatWebAppBuilder();
                tomcatWebAppBuilder.start();
                SystemInstance.get().setComponent(WebAppBuilder.class, (Object)tomcatWebAppBuilder);
            }
            SystemInstance.get().setComponent(ParentClassLoaderFinder.class, (Object)tomcatWebAppBuilder);
            SystemInstance.get().setComponent(WebAppDeployer.class, (Object)new TomcatWebappDeployer());
            SystemInstance.get().setComponent(WebDeploymentListeners.class, (Object)new WebDeploymentListeners());
            TomEEClassLoaderEnricher classLoaderEnricher = new TomEEClassLoaderEnricher();
            SystemInstance.get().setComponent(WebAppEnricher.class, (Object)classLoaderEnricher);
            ClassLoaderEnricher enricher = (ClassLoaderEnricher)SystemInstance.get().getComponent(ClassLoaderEnricher.class);
            if (null != enricher) {
                for (URL url : classLoaderEnricher.enrichment(null)) {
                    enricher.addUrl(url);
                }
            }
            if (this.optionalService(properties, "org.apache.tomee.webservices.TomeeJaxRsService")) {
                SystemInstance.get().setProperty("openejb.rest.wildcard", "*");
            }
            this.optionalService(properties, "org.apache.tomee.webservices.TomeeJaxWsService");
            ejbServer = new EjbServer();
            SystemInstance.get().setComponent(EjbServer.class, (Object)ejbServer);
            OpenEJB.init((Properties)properties, (ApplicationServer)new ServerFederation());
            TomcatJndiBuilder.importOpenEJBResourcesInTomcat(((OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class)).facilities.resources, TomcatHelper.getServer());
            Properties ejbServerProps = new Properties();
            ejbServerProps.putAll((Map<?, ?>)properties);
            for (String prop : new String[]{"serializer", "gzip"}) {
                String value = SystemInstance.get().getProperty("ejbd." + prop);
                if (value == null) continue;
                ejbServerProps.put(prop, value);
            }
            ejbServerProps.setProperty("openejb.ejbd.uri", "http://127.0.0.1:8080/tomee/ejb");
            ejbServer.init(ejbServerProps);
            StandardServer standardServer = TomcatHelper.getServer();
            OpenEJBNamingContextListener namingContextListener = new OpenEJBNamingContextListener(standardServer);
            if (standardServer.getGlobalNamingContext() != null) {
                namingContextListener.start();
            }
            standardServer.addLifecycleListener((LifecycleListener)namingContextListener);
            this.processRunningApplications(tomcatWebAppBuilder, standardServer);
            ClassLoader cl = TomcatLoader.class.getClassLoader();
            if (SystemInstance.get().getOptions().get("openejb.servicemanager.enabled", true)) {
                String clazz = SystemInstance.get().getOptions().get("openejb.service.manager.class", (String)null);
                try {
                    manager = clazz == null ? new TomEEServiceManager() : (ServiceManager)cl.loadClass(clazz).newInstance();
                }
                catch (ClassNotFoundException cnfe) {
                    logger.severe("can't find the service manager " + clazz + ", the TomEE one will be used");
                    manager = new TomEEServiceManager();
                }
                manager.init();
                manager.start(false);
            } else {
                try {
                    ServerService cxfService = (ServerService)cl.loadClass("org.apache.openejb.server.cxf.CxfService").newInstance();
                    cxfService.init(properties);
                    cxfService.start();
                    services.add(cxfService);
                }
                catch (ClassNotFoundException cxfService) {
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Webservices failed to start", e);
                }
                try {
                    ServerService restService = (ServerService)cl.loadClass("org.apache.openejb.server.cxf.rs.CxfRSService").newInstance();
                    restService.init(properties);
                    restService.start();
                    services.add(restService);
                }
                catch (ClassNotFoundException restService) {
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "REST failed to start", e);
                }
            }
            if (SystemInstance.get().getOptions().get(TOMEE_NOSHUTDOWNHOOK_PROP, (String)null) != null) {
                Field daemonField = Bootstrap.class.getDeclaredField("daemon");
                boolean acc = daemonField.isAccessible();
                try {
                    daemonField.setAccessible(true);
                    Bootstrap daemon = (Bootstrap)daemonField.get(null);
                    if (daemon == null) break block28;
                    Field catalinaField = Bootstrap.class.getDeclaredField("catalinaDaemon");
                    boolean catalinaAcc = catalinaField.isAccessible();
                    catalinaField.setAccessible(true);
                    try {
                        Catalina.class.getMethod("setUseShutdownHook", Boolean.TYPE).invoke(catalinaField.get(daemon), false);
                    }
                    finally {
                        catalinaField.setAccessible(catalinaAcc);
                    }
                }
                finally {
                    daemonField.setAccessible(acc);
                }
            }
        }
    }

    private boolean optionalService(Properties properties, String className) {
        try {
            org.apache.openejb.spi.Service service = (org.apache.openejb.spi.Service)this.getClass().getClassLoader().loadClass(className).newInstance();
            service.init(properties);
            return true;
        }
        catch (ClassNotFoundException service) {
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to start: " + className, e);
        }
        return false;
    }

    private void setIfNull(Properties properties, String key, String value) {
        if (!properties.containsKey(key) && !System.getProperties().containsKey(key)) {
            properties.setProperty(key, value);
        }
    }

    public static void destroy() {
        TomcatWebAppBuilder tomcatWebAppBuilder;
        for (ServerService s : services) {
            try {
                s.stop();
            }
            catch (ServiceException serviceException) {}
        }
        if (manager != null) {
            try {
                manager.stop();
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            manager = null;
        }
        if (ejbServer != null) {
            try {
                ejbServer.stop();
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
            ejbServer = null;
        }
        if ((tomcatWebAppBuilder = (TomcatWebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class)) != null) {
            try {
                tomcatWebAppBuilder.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OpenEJB.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRunningApplications(TomcatWebAppBuilder tomcatWebAppBuilder, StandardServer standardServer) {
        for (Service service : standardServer.findServices()) {
            if (!(service.getContainer() instanceof Engine)) continue;
            Engine engine = service.getContainer();
            for (Container engineChild : engine.findChildren()) {
                if (!(engineChild instanceof Host)) continue;
                Host host = (Host)engineChild;
                for (Container hostChild : host.findChildren()) {
                    if (!(hostChild instanceof StandardContext)) continue;
                    StandardContext standardContext = (StandardContext)hostChild;
                    int state = TomcatHelper.getContextState((StandardContext)standardContext);
                    if (state == 0) {
                        tomcatWebAppBuilder.init(standardContext);
                        continue;
                    }
                    if (state != 1) continue;
                    standardContext.addParameter("openejb.start.late", "true");
                    ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(standardContext.getLoader().getClassLoader());
                    try {
                        tomcatWebAppBuilder.init(standardContext);
                        tomcatWebAppBuilder.beforeStart(standardContext);
                        tomcatWebAppBuilder.start(standardContext);
                        tomcatWebAppBuilder.afterStart(standardContext);
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldCL);
                    }
                    standardContext.removeParameter("openejb.start.late");
                }
            }
        }
    }

    static {
        services = new ArrayList<ServerService>();
    }

    private static final class TomcatToXbeanFilter
    implements Filter {
        private final Set<String> entries;

        private TomcatToXbeanFilter(Set<String> entries) {
            this.entries = entries;
        }

        public boolean accept(String name) {
            return Matcher.matchName(this.entries, (String)name);
        }
    }

    private static final class SecurityEnv {
        private SecurityEnv() {
        }

        public static void init() {
            if (Security.getProperty("authconfigprovider.factory") == null) {
                Security.setProperty("authconfigprovider.factory", "org.apache.catalina.authenticator.jaspic.AuthConfigFactoryImpl");
            }
        }
    }
}

