/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public final class JAXBContextFactory {
    private static final boolean USE_FAST_BOOT = "true".equals(System.getProperty("openejb.jaxb.fastBoot", "true"));
    private static final String FAST_BOOT = "com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot";
    private static final Logger log = Logger.getLogger(JAXBContextFactory.class.getName());

    private static String setFastBoot() {
        String fastBoot = System.getProperty(FAST_BOOT);
        if (USE_FAST_BOOT) {
            System.setProperty(FAST_BOOT, Boolean.TRUE.toString());
        }
        return fastBoot;
    }

    private static void resetFastBoot(String fastBoot) {
        if (USE_FAST_BOOT) {
            if (fastBoot == null) {
                System.clearProperty(FAST_BOOT);
            } else {
                System.setProperty(FAST_BOOT, fastBoot);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext newInstance(String s) throws JAXBException {
        Event event = Event.start(s);
        try {
            JAXBContext jAXBContext;
            String fastBoot = JAXBContextFactory.setFastBoot();
            try {
                jAXBContext = JAXBContext.newInstance((String)s);
            }
            catch (Throwable throwable) {
                JAXBContextFactory.resetFastBoot(fastBoot);
                throw throwable;
            }
            JAXBContextFactory.resetFastBoot(fastBoot);
            return jAXBContext;
        }
        finally {
            event.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext newInstance(String s, ClassLoader classLoader) throws JAXBException {
        Event event = Event.start(s);
        try {
            JAXBContext jAXBContext;
            String fastBoot = JAXBContextFactory.setFastBoot();
            try {
                jAXBContext = JAXBContext.newInstance((String)s, (ClassLoader)classLoader);
            }
            catch (Throwable throwable) {
                JAXBContextFactory.resetFastBoot(fastBoot);
                throw throwable;
            }
            JAXBContextFactory.resetFastBoot(fastBoot);
            return jAXBContext;
        }
        finally {
            event.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext newInstance(String s, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        Event event = Event.start(s);
        try {
            JAXBContext jAXBContext;
            String fastBoot = JAXBContextFactory.setFastBoot();
            try {
                jAXBContext = JAXBContext.newInstance((String)s, (ClassLoader)classLoader, properties);
            }
            catch (Throwable throwable) {
                JAXBContextFactory.resetFastBoot(fastBoot);
                throw throwable;
            }
            JAXBContextFactory.resetFastBoot(fastBoot);
            return jAXBContext;
        }
        finally {
            event.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext newInstance(Class ... classes) throws JAXBException {
        StringBuilder sb = new StringBuilder();
        for (Class clazz : classes) {
            sb.append(clazz.getName());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        Event event = Event.start(sb.toString());
        try {
            JAXBContext jAXBContext;
            String fastBoot = JAXBContextFactory.setFastBoot();
            try {
                jAXBContext = JAXBContext.newInstance((Class[])classes);
            }
            catch (LinkageError ignore) {
                JAXBContext jAXBContext2;
                try {
                    jAXBContext2 = JAXBContext.newInstance((Class[])classes);
                }
                catch (Throwable throwable) {
                    JAXBContextFactory.resetFastBoot(fastBoot);
                    throw throwable;
                }
                JAXBContextFactory.resetFastBoot(fastBoot);
                event.stop();
                return jAXBContext2;
            }
            JAXBContextFactory.resetFastBoot(fastBoot);
            return jAXBContext;
        }
        finally {
            event.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext newInstance(Class[] classes, Map<String, ?> properties) throws JAXBException {
        StringBuilder sb = new StringBuilder();
        for (Class clazz : classes) {
            sb.append(clazz.getName());
            sb.append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        Event event = Event.start(sb.toString());
        try {
            JAXBContext jAXBContext;
            String fastBoot = JAXBContextFactory.setFastBoot();
            try {
                jAXBContext = JAXBContext.newInstance((Class[])classes, properties);
            }
            catch (Throwable throwable) {
                JAXBContextFactory.resetFastBoot(fastBoot);
                throw throwable;
            }
            JAXBContextFactory.resetFastBoot(fastBoot);
            return jAXBContext;
        }
        finally {
            event.stop();
        }
    }

    private static class Event {
        protected final long start = System.nanoTime();
        private final String description;

        private Event(String description) {
            this.description = description;
        }

        public static Event start(String description) {
            return new Event(description);
        }

        public void stop() {
            log.log(Level.FINE, String.format("JAXBContext.newInstance %s  %s", TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.start), this.description));
        }
    }
}

