/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.entity.cmp;

import jakarta.ejb.CreateException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.FinderException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.openejb.test.ApplicationException;
import org.apache.openejb.test.object.OperationsPolicy;

public abstract class BasicCmp2PojoBean
implements EntityBean {
    private static int nextId;
    private String firstName;
    public EntityContext ejbContext;
    public Map<String, OperationsPolicy> allowedOperationsTable = new HashMap<String, OperationsPolicy>();

    public abstract Integer getId();

    public abstract void setId(Integer var1);

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public abstract String getLastName();

    public abstract void setLastName(String var1);

    public abstract void ejbSelectRemoveById(Integer var1) throws FinderException;

    public int ejbHomeSum(int x, int y) {
        this.testAllowedOperations("ejbHome");
        return x + y;
    }

    public void ejbHomeVoidSelect() throws FinderException {
        this.ejbSelectRemoveById(999999);
    }

    public Integer ejbCreateObject(String name) throws CreateException {
        this.setId(nextId++);
        StringTokenizer st = new StringTokenizer(name, " ");
        this.setFirstName(st.nextToken());
        this.setLastName(st.nextToken());
        return null;
    }

    public void ejbPostCreateObject(String name) {
    }

    public String businessMethod(String text) {
        this.testAllowedOperations("businessMethod");
        StringBuffer b = new StringBuffer(text);
        return b.reverse().toString();
    }

    public void throwApplicationException() throws ApplicationException {
        throw new ApplicationException("Testing ability to throw Application Exceptions");
    }

    public void throwSystemException_NullPointer() {
        throw new NullPointerException("Testing ability to throw System Exceptions");
    }

    public Properties getPermissionsReport() {
        return null;
    }

    public OperationsPolicy getAllowedOperationsReport(String methodName) {
        return this.allowedOperationsTable.get(methodName);
    }

    public void ejbLoad() {
    }

    public void setEntityContext(EntityContext ctx) {
        this.ejbContext = ctx;
        this.testAllowedOperations("setEntityContext");
    }

    public void unsetEntityContext() {
        this.testAllowedOperations("unsetEntityContext");
    }

    public void ejbStore() {
    }

    public void ejbRemove() {
    }

    public void ejbActivate() {
        this.testAllowedOperations("ejbActivate");
    }

    public void ejbPassivate() {
        this.testAllowedOperations("ejbPassivate");
    }

    protected void testAllowedOperations(String methodName) {
        OperationsPolicy policy = new OperationsPolicy();
        try {
            this.ejbContext.getEJBHome();
            policy.allow(0);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getCallerPrincipal();
            policy.allow(1);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.isCallerInRole("TheMan");
            policy.allow(2);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getRollbackOnly();
            policy.allow(3);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.setRollbackOnly();
            policy.allow(4);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getUserTransaction();
            policy.allow(5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.ejbContext.getEJBObject();
            policy.allow(6);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.ejbContext.getPrimaryKey();
            policy.allow(7);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.allowedOperationsTable.put(methodName, policy);
    }
}

