/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import jakarta.ejb.CreateException;
import jakarta.ejb.EJBContext;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import junit.framework.AssertionFailedError;
import org.apache.openejb.test.TestFailureException;
import org.apache.openejb.test.entity.bmp.BasicBmpHome;
import org.apache.openejb.test.entity.bmp.BasicBmpObject;
import org.apache.openejb.test.mdb.EncMdbObject;
import org.apache.openejb.test.mdb.MdbInvoker;
import org.apache.openejb.test.stateful.BasicStatefulBusinessLocal;
import org.apache.openejb.test.stateful.BasicStatefulBusinessRemote;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateful.BasicStatefulObject;
import org.apache.openejb.test.stateless.BasicStatelessBusinessLocal;
import org.apache.openejb.test.stateless.BasicStatelessBusinessRemote;
import org.apache.openejb.test.stateless.BasicStatelessHome;
import org.apache.openejb.test.stateless.BasicStatelessObject;
import org.junit.Assert;

public class ContextLookupMdbBean
implements EncMdbObject,
MessageDrivenBean,
MessageListener {
    private MessageDrivenContext mdbContext = null;
    private MdbInvoker mdbInvoker;

    public void setMessageDrivenContext(MessageDrivenContext ctx) throws EJBException {
        this.mdbContext = ctx;
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)new InitialContext().lookup("java:comp/env/jms");
            this.mdbInvoker = new MdbInvoker(connectionFactory, this);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
    }

    public void onMessage(Message message) {
        try {
            try {
                message.acknowledge();
            }
            catch (JMSException e) {
                e.printStackTrace();
            }
            this.mdbInvoker.onMessage(message);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void lookupEntityBean() throws TestFailureException {
        try {
            try {
                BasicBmpHome home = (BasicBmpHome)this.mdbContext.lookup("stateless/beanReferences/bmp_entity");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicBmpObject object = home.createObject("Enc Bean");
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupStatefulBean() throws TestFailureException {
        try {
            try {
                BasicStatefulHome home = (BasicStatefulHome)this.mdbContext.lookup("stateless/beanReferences/stateful");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicStatefulObject object = home.createObject("Enc Bean");
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupStatelessBean() throws TestFailureException {
        try {
            try {
                BasicStatelessHome home = (BasicStatelessHome)this.mdbContext.lookup("stateless/beanReferences/stateless");
                Assert.assertNotNull((String)"The EJBHome looked up is null", (Object)home);
                BasicStatelessObject object = home.createObject();
                Assert.assertNotNull((String)"The EJBObject is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupStatelessBusinessLocal() throws TestFailureException {
        try {
            try {
                BasicStatelessBusinessLocal object = (BasicStatelessBusinessLocal)this.mdbContext.lookup("stateless/beanReferences/stateless-business-local");
                Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupStatelessBusinessRemote() throws TestFailureException {
        try {
            try {
                BasicStatelessBusinessRemote object = (BasicStatelessBusinessRemote)this.mdbContext.lookup("stateless/beanReferences/stateless-business-remote");
                Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupStatefulBusinessLocal() throws TestFailureException {
        try {
            try {
                BasicStatefulBusinessLocal object = (BasicStatefulBusinessLocal)this.mdbContext.lookup("stateless/beanReferences/stateful-business-local");
                Assert.assertNotNull((String)"The EJB BusinessLocal is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupStatefulBusinessRemote() throws TestFailureException {
        try {
            try {
                BasicStatefulBusinessRemote object = (BasicStatefulBusinessRemote)this.mdbContext.lookup("stateless/beanReferences/stateful-business-remote");
                Assert.assertNotNull((String)"The EJB BusinessRemote is null", (Object)object);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupStringEntry() throws TestFailureException {
        try {
            try {
                String expected = "1";
                String actual = (String)this.mdbContext.lookup("stateless/references/String");
                Assert.assertNotNull((String)"The String looked up is null", (Object)actual);
                Assert.assertEquals((Object)"1", (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupDoubleEntry() throws TestFailureException {
        try {
            try {
                Double expected = 1.0;
                Double actual = (Double)this.mdbContext.lookup("stateless/references/Double");
                Assert.assertNotNull((String)"The Double looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupLongEntry() throws TestFailureException {
        try {
            try {
                Long expected = 1L;
                Long actual = (Long)this.mdbContext.lookup("stateless/references/Long");
                Assert.assertNotNull((String)"The Long looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupFloatEntry() throws TestFailureException {
        try {
            try {
                Float expected = Float.valueOf(1.0f);
                Float actual = (Float)this.mdbContext.lookup("stateless/references/Float");
                Assert.assertNotNull((String)"The Float looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupIntegerEntry() throws TestFailureException {
        try {
            try {
                Integer expected = 1;
                Integer actual = (Integer)this.mdbContext.lookup("stateless/references/Integer");
                Assert.assertNotNull((String)"The Integer looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupShortEntry() throws TestFailureException {
        try {
            try {
                Short expected = 1;
                Short actual = (Short)this.mdbContext.lookup("stateless/references/Short");
                Assert.assertNotNull((String)"The Short looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupBooleanEntry() throws TestFailureException {
        try {
            try {
                Boolean expected = true;
                Boolean actual = (Boolean)this.mdbContext.lookup("stateless/references/Boolean");
                Assert.assertNotNull((String)"The Boolean looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupByteEntry() throws TestFailureException {
        try {
            try {
                Byte expected = 1;
                Byte actual = (Byte)this.mdbContext.lookup("stateless/references/Byte");
                Assert.assertNotNull((String)"The Byte looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupCharacterEntry() throws TestFailureException {
        try {
            try {
                Character expected = Character.valueOf('D');
                Character actual = (Character)this.mdbContext.lookup("stateless/references/Character");
                Assert.assertNotNull((String)"The Character looked up is null", (Object)actual);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupResource() throws TestFailureException {
        try {
            try {
                Object obj = this.mdbContext.lookup("datasource");
                Assert.assertNotNull((String)"The DataSource is null", (Object)obj);
                Assert.assertTrue((String)"Not an instance of DataSource", (boolean)(obj instanceof DataSource));
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupJMSConnectionFactory() throws TestFailureException {
        try {
            try {
                Object obj = this.mdbContext.lookup("jms");
                Assert.assertNotNull((String)"The JMS ConnectionFactory is null", (Object)obj);
                Assert.assertTrue((String)"Not an instance of ConnectionFactory", (boolean)(obj instanceof ConnectionFactory));
                ConnectionFactory connectionFactory = (ConnectionFactory)obj;
                this.testJmsConnection(connectionFactory.createConnection());
                obj = this.mdbContext.lookup("TopicCF");
                Assert.assertNotNull((String)"The JMS TopicConnectionFactory is null", (Object)obj);
                Assert.assertTrue((String)"Not an instance of TopicConnectionFactory", (boolean)(obj instanceof TopicConnectionFactory));
                TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)obj;
                this.testJmsConnection(topicConnectionFactory.createConnection());
                obj = this.mdbContext.lookup("QueueCF");
                Assert.assertNotNull((String)"The JMS QueueConnectionFactory is null", (Object)obj);
                Assert.assertTrue((String)"Not an instance of QueueConnectionFactory", (boolean)(obj instanceof QueueConnectionFactory));
                QueueConnectionFactory queueConnectionFactory = (QueueConnectionFactory)obj;
                this.testJmsConnection(queueConnectionFactory.createConnection());
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    private void testJmsConnection(Connection connection) throws JMSException {
        Session session = connection.createSession(false, 3);
        Topic topic = session.createTopic("test");
        MessageProducer producer = session.createProducer((Destination)topic);
        producer.send(session.createMessage());
        producer.close();
        session.close();
        connection.close();
    }

    @Override
    public void lookupPersistenceUnit() throws TestFailureException {
        try {
            try {
                EntityManagerFactory emf = (EntityManagerFactory)this.mdbContext.lookup("persistence/TestUnit");
                Assert.assertNotNull((String)"The EntityManagerFactory is null", (Object)emf);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupPersistenceContext() throws TestFailureException {
        try {
            try {
                EntityManager em = (EntityManager)this.mdbContext.lookup("persistence/TestContext");
                Assert.assertNotNull((String)"The EntityManager is null", (Object)em);
                em.getFlushMode();
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    @Override
    public void lookupMessageDrivenContext() throws TestFailureException {
        try {
            try {
                InitialContext ctx = new InitialContext();
                Assert.assertNotNull((String)"The InitialContext is null", (Object)ctx);
                MessageDrivenContext sctx = (MessageDrivenContext)ctx.lookup("java:comp/env/mdbcontext");
                Assert.assertNotNull((String)"The MessageDrivenContext got from java:comp/env/mdbcontext is null", (Object)sctx);
                EJBContext ejbCtx = (EJBContext)ctx.lookup("java:comp/EJBContext");
                Assert.assertNotNull((String)"The MessageDrivenContext got from java:comp/EJBContext is null ", (Object)ejbCtx);
                Assert.assertNotNull((String)"The MessageDrivenContext is null from setter method", (Object)this.mdbContext);
            }
            catch (Exception e) {
                Assert.fail((String)("Received Exception " + e.getClass() + " : " + e.getMessage()));
            }
        }
        catch (AssertionFailedError afe) {
            throw new TestFailureException(afe);
        }
    }

    public void ejbCreate() throws CreateException {
    }

    public void ejbRemove() throws EJBException {
        if (null != this.mdbInvoker) {
            this.mdbInvoker.destroy();
        }
    }
}

