/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.test.mdb;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.MessageDrivenContext;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import jakarta.jms.Message;
import org.apache.openejb.test.entity.bmp.BasicBmpHome;
import org.apache.openejb.test.mdb.InterceptorMdbBean;
import org.apache.openejb.test.stateful.BasicStatefulHome;
import org.apache.openejb.test.stateless.BasicStatelessHome;

public class MdbInterceptor {
    @Resource
    private MessageDrivenContext mdbContext;
    @EJB(beanName="BasicBmpBean")
    private BasicBmpHome bmpHome;
    @EJB(beanName="BasicStatefulBean")
    private BasicStatefulHome statefulHome;
    @EJB(beanName="BasicStatelessBean")
    private BasicStatelessHome statelessHome;

    @AroundInvoke
    public Object mdbInterceptor(InvocationContext ctx) throws Exception {
        Object[] objArr = ctx.getParameters();
        Message msg = (Message)objArr[0];
        msg.clearProperties();
        msg.setBooleanProperty("ClassLevelBusinessMethodInterception", true);
        ctx.setParameters(objArr);
        return ctx.proceed();
    }

    @PreDestroy
    public void interceptRemove(InvocationContext ctx) throws Exception {
        ctx.proceed();
    }

    @PostConstruct
    public void postConstruct(InvocationContext ctx) throws Exception {
        InterceptorMdbBean.classLevelCreateMethodInterception = true;
        ctx.proceed();
    }
}

